/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.deployer;

import com.liferay.object.deployer.ObjectDefinitionDeployer;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.graphql.dto.v1_0.ObjectDefinitionGraphQLDTOContributor;
import com.liferay.object.rest.internal.jaxrs.context.provider.ObjectDefinitionContextProvider;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectEntryManagerHttpExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectEntryValuesExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.ObjectValidationRuleEngineExceptionMapper;
import com.liferay.object.rest.internal.jaxrs.exception.mapper.RequiredObjectRelationshipExceptionMapper;
import com.liferay.object.rest.internal.resource.v1_0.BaseObjectEntryResourceImpl;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerTracker;
import com.liferay.object.rest.petra.sql.dsl.expression.FilterPredicateFactory;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionMetadata;
import com.liferay.object.system.SystemObjectDefinitionMetadataTracker;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.ExceptionMapper;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ObjectDefinitionDeployer.class})
public class ObjectDefinitionDeployerImpl
implements ObjectDefinitionDeployer {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDefinitionDeployerImpl.class);
    private BundleContext _bundleContext;
    private final Map<String, List<ComponentInstance>> _componentInstancesMap = new HashMap<String, List<ComponentInstance>>();
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private FilterPredicateFactory _filterPredicateFactory;
    private final Map<String, Map<Long, ObjectDefinition>> _objectDefinitionsMap = new HashMap<String, Map<Long, ObjectDefinition>>();
    @Reference(target="(component.factory=com.liferay.object.internal.jaxrs.application.ObjectEntryApplication)")
    private ComponentFactory _objectEntryApplicationComponentFactory;
    @Reference
    private ObjectEntryManagerTracker _objectEntryManagerTracker;
    @Reference(target="(component.factory=com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResource)")
    private ComponentFactory _objectEntryResourceComponentFactory;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference(target="(component.factory=com.liferay.object.rest.internal.resource.v1_0.RelatedObjectEntryResource)")
    private ComponentFactory _relatedObjectEntryResourceFactory;
    @Reference
    private SystemObjectDefinitionMetadataTracker _systemObjectDefinitionMetadataTracker;

    public synchronized List<ServiceRegistration<?>> deploy(ObjectDefinition objectDefinition) {
        if (objectDefinition.isSystem()) {
            if (!GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-153324"))) {
                return Collections.emptyList();
            }
            SystemObjectDefinitionMetadata systemObjectDefinitionMetadata = this._systemObjectDefinitionMetadataTracker.getSystemObjectDefinitionMetadata(objectDefinition.getName());
            this._componentInstancesMap.computeIfAbsent(systemObjectDefinitionMetadata.getRESTContextPath(), key -> Arrays.asList(this._relatedObjectEntryResourceFactory.newInstance((Dictionary)HashMapDictionaryBuilder.put((Object)"api.version", (Object)"v1.0").put((Object)"osgi.jaxrs.application.select", () -> {
                String jaxRsApplicationName = systemObjectDefinitionMetadata.getJaxRsApplicationName();
                return "(osgi.jaxrs.name=" + jaxRsApplicationName + ")";
            }).put((Object)"osgi.jaxrs.resource", (Object)"true").build())));
            return Collections.emptyList();
        }
        ArrayList serviceRegistrations = new ArrayList();
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (!this._objectDefinitionsMap.containsKey(objectDefinition.getRESTContextPath())) {
            this._excludeScopedMethods(objectDefinition, objectScopeProvider);
            this._componentInstancesMap.put(objectDefinition.getRESTContextPath(), Arrays.asList(this._objectEntryApplicationComponentFactory.newInstance((Dictionary)HashMapDictionaryBuilder.put((Object)"liferay.jackson", (Object)false).put((Object)"liferay.object.definition.id", (Object)objectDefinition.getObjectDefinitionId()).put((Object)"liferay.object.definition.name", (Object)objectDefinition.getShortName()).put((Object)"osgi.jaxrs.application.base", (Object)objectDefinition.getRESTContextPath()).put((Object)"osgi.jaxrs.extension.select", (Object)"(osgi.jaxrs.name=Liferay.Vulcan)").put((Object)"osgi.jaxrs.name", (Object)objectDefinition.getName()).build()), this._objectEntryResourceComponentFactory.newInstance((Dictionary)HashMapDictionaryBuilder.put((Object)"api.version", (Object)"v1.0").put((Object)"batch.engine.entity.class.name", (Object)(ObjectEntry.class.getName() + "#" + objectDefinition.getName())).put((Object)"batch.engine.task.item.delegate", (Object)"true").put((Object)"batch.engine.task.item.delegate.name", (Object)objectDefinition.getShortName()).put((Object)"batch.planner.export.enabled", (Object)"true").put((Object)"batch.planner.import.enabled", (Object)"true").put((Object)"entity.class.name", (Object)(ObjectEntry.class.getName() + "#" + objectDefinition.getName())).put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.resource", (Object)"true").build())));
            Collections.addAll(serviceRegistrations, this._bundleContext.registerService(ContextProvider.class, (Object)new ObjectDefinitionContextProvider(this, this._portal), (Dictionary)HashMapDictionaryBuilder.put((Object)"enabled", (Object)"false").put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)(objectDefinition.getName() + "ObjectDefinitionContextProvider")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectEntryManagerHttpExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)(objectDefinition.getName() + "ObjectEntryManagerHttpExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectEntryValuesExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)(objectDefinition.getName() + "ObjectEntryValuesExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new ObjectValidationRuleEngineExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)(objectDefinition.getName() + "ObjectValidationRuleEngineExceptionMapper")).build()), this._bundleContext.registerService(ExceptionMapper.class, (Object)new RequiredObjectRelationshipExceptionMapper(), (Dictionary)HashMapDictionaryBuilder.put((Object)"osgi.jaxrs.application.select", (Object)("(osgi.jaxrs.name=" + objectDefinition.getName() + ")")).put((Object)"osgi.jaxrs.extension", (Object)"true").put((Object)"osgi.jaxrs.name", (Object)(objectDefinition.getName() + "RequiredObjectRelationshipExceptionMapper")).build()));
        }
        serviceRegistrations.add(this._bundleContext.registerService(GraphQLDTOContributor.class, (Object)ObjectDefinitionGraphQLDTOContributor.of(this._filterPredicateFactory, objectDefinition, this._objectEntryManagerTracker.getObjectEntryManager(objectDefinition.getStorageType()), this._objectFieldLocalService, this._objectRelationshipLocalService, objectScopeProvider), (Dictionary)HashMapDictionaryBuilder.put((Object)"dto.name", (Object)objectDefinition.getDBTableName()).build()));
        Map objectDefinitions = this._objectDefinitionsMap.computeIfAbsent(objectDefinition.getRESTContextPath(), k -> new HashMap());
        objectDefinitions.put(objectDefinition.getCompanyId(), objectDefinition);
        return serviceRegistrations;
    }

    public ObjectDefinition getObjectDefinition(long companyId, String restContextPath) {
        Map<Long, ObjectDefinition> objectDefinitions = this._objectDefinitionsMap.get(restContextPath);
        if (objectDefinitions != null) {
            return objectDefinitions.get(companyId);
        }
        return null;
    }

    public synchronized void undeploy(ObjectDefinition objectDefinition) {
        List<ComponentInstance> componentInstances;
        Map<Long, ObjectDefinition> objectDefinitions = this._objectDefinitionsMap.get(objectDefinition.getRESTContextPath());
        if (objectDefinitions != null) {
            objectDefinitions.remove(objectDefinition.getCompanyId());
            if (objectDefinitions.isEmpty()) {
                this._objectDefinitionsMap.remove(objectDefinition.getRESTContextPath());
            }
        }
        if (!this._objectDefinitionsMap.containsKey(objectDefinition.getRESTContextPath()) && (componentInstances = this._componentInstancesMap.get(objectDefinition.getRESTContextPath())) != null) {
            for (ComponentInstance componentInstance : componentInstances) {
                componentInstance.dispose();
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    private void _excludeScopedMethods(ObjectDefinition objectDefinition, ObjectScopeProvider objectScopeProvider) {
        block3: {
            try {
                String factoryPid = "com.liferay.portal.vulcan.internal.configuration.VulcanConfiguration";
                Configuration configuration = this._configurationAdmin.createFactoryConfiguration(factoryPid, "?");
                Method[] methods = BaseObjectEntryResourceImpl.class.getMethods();
                ArrayList<String> excludedOperationIds = new ArrayList<String>();
                for (Method method : methods) {
                    Path path = method.getAnnotation(Path.class);
                    if (path == null) continue;
                    String value = path.value();
                    boolean groupAware = objectScopeProvider.isGroupAware();
                    boolean hasScope = value.contains("scopes");
                    if ((groupAware || !hasScope) && (!groupAware || hasScope || value.equals("/{objectEntryId}"))) continue;
                    excludedOperationIds.add(method.getName());
                }
                configuration.update((Dictionary)HashMapDictionaryBuilder.put((Object)"excludedOperationIds", (Object)StringUtil.merge(excludedOperationIds, (String)",")).put((Object)"path", (Object)objectDefinition.getRESTContextPath()).build());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Throwable)exception);
            }
        }
    }
}

