/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.odata.entity.v1_0;

import com.liferay.object.model.ObjectField;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.DateEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IdEntityField;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ObjectEntryEntityModel
implements EntityModel {
    private final Map<String, EntityField> _entityFieldsMap = HashMapBuilder.put((Object)"creator", (Object)new StringEntityField("creator", locale -> "userName")).put((Object)"creatorId", (Object)new IntegerEntityField("creatorId", locale -> "userId")).put((Object)"dateCreated", (Object)new DateTimeEntityField("dateCreated", locale -> Field.getSortableFieldName((String)"createDate"), locale -> "createDate")).put((Object)"dateModified", (Object)new DateTimeEntityField("dateModified", locale -> Field.getSortableFieldName((String)"modified"), locale -> "modified")).put((Object)"id", (Object)new IdEntityField("id", locale -> Field.getSortableFieldName((String)"entryClassPK"), String::valueOf)).put((Object)"objectDefinitionId", (Object)new IntegerEntityField("objectDefinitionId", locale -> "objectDefinitionId")).put((Object)"siteId", (Object)new IntegerEntityField("siteId", locale -> "groupId")).put((Object)"status", (Object)new CollectionEntityField((EntityField)new IntegerEntityField("status", locale -> "status"))).put((Object)"userId", (Object)new IntegerEntityField("userId", locale -> "userId")).build();

    public ObjectEntryEntityModel(List<ObjectField> objectFields) {
        for (ObjectField objectField : objectFields) {
            if (Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                String objectFieldName = objectField.getName();
                String relationshipIdName = objectFieldName.substring(objectFieldName.lastIndexOf("_") + 1);
                this._entityFieldsMap.put(relationshipIdName, (EntityField)new IdEntityField(relationshipIdName, locale -> "nestedFieldArray.value_long#" + objectFieldName, String::valueOf));
                continue;
            }
            this._getEntityField(objectField).ifPresent(entityField -> this._entityFieldsMap.put(objectField.getName(), (EntityField)entityField));
        }
    }

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    private Optional<EntityField> _getEntityField(ObjectField objectField) {
        if (objectField.isIndexedAsKeyword()) {
            return Optional.of(new StringEntityField(objectField.getName(), locale -> "nestedFieldArray.value_keyword#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getBusinessType(), "Attachment") || Objects.equals(objectField.getDBType(), "Clob") || Objects.equals(objectField.getDBType(), "String")) {
            return Optional.of(new StringEntityField(objectField.getName(), locale -> "nestedFieldArray.value_keyword_lowercase#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "BigDecimal") || Objects.equals(objectField.getDBType(), "Double")) {
            return Optional.of(new DoubleEntityField(objectField.getName(), locale -> "nestedFieldArray.value_double#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "Boolean")) {
            return Optional.of(new BooleanEntityField(objectField.getName(), locale -> "nestedFieldArray.value_boolean#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "Date")) {
            return Optional.of(new DateEntityField(objectField.getName(), locale -> "nestedFieldArray.value_date#" + objectField.getName(), locale -> "nestedFieldArray.value_date#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "Integer")) {
            return Optional.of(new IntegerEntityField(objectField.getName(), locale -> "nestedFieldArray.value_integer#" + objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "Long")) {
            return Optional.of(new IntegerEntityField(objectField.getName(), locale -> "nestedFieldArray.value_long#" + objectField.getName()));
        }
        return Optional.empty();
    }
}

