/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.graphql.dto.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.internal.odata.entity.v1_0.ObjectEntryEntityModel;
import com.liferay.object.rest.internal.petra.sql.dsl.expression.PredicateUtil;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOContributor;
import com.liferay.portal.vulcan.graphql.dto.GraphQLDTOProperty;
import com.liferay.portal.vulcan.graphql.dto.v1_0.Creator;
import com.liferay.portal.vulcan.list.type.ListEntry;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.TransformUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

public class ObjectDefinitionGraphQLDTOContributor
implements GraphQLDTOContributor<Map<String, Object>, Map<String, Object>> {
    private static final Map<String, Class<?>> _typedClasses = HashMapBuilder.put((Object)"BigDecimal", BigDecimal.class).put((Object)"Blob", Blob.class).put((Object)"Boolean", Boolean.class).put((Object)"Date", Date.class).put((Object)"Double", Double.class).put((Object)"Integer", Integer.class).put((Object)"Long", Long.class).put((Object)"String", String.class).build();
    private final long _companyId;
    private final EntityModel _entityModel;
    private final FilterParserProvider _filterParserProvider;
    private final List<GraphQLDTOProperty> _graphQLDTOProperties;
    private final String _idName;
    private final ObjectDefinition _objectDefinition;
    private final ObjectEntryManager _objectEntryManager;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectScopeProvider _objectScopeProvider;
    private final List<GraphQLDTOProperty> _relationshipGraphQLDTOProperties;
    private final String _resourceName;
    private final String _typeName;

    public static ObjectDefinitionGraphQLDTOContributor of(FilterParserProvider filterParserProvider, ObjectDefinition objectDefinition, ObjectEntryManager objectEntryManager, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, ObjectScopeProvider objectScopeProvider) {
        ArrayList<GraphQLDTOProperty> graphQLDTOProperties = new ArrayList<GraphQLDTOProperty>();
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)objectDefinition.getPKObjectFieldName(), (boolean)true, Long.class));
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)"creator", (boolean)true, Creator.class));
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)"dateCreated", (boolean)true, Date.class));
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)"dateModified", (boolean)true, Date.class));
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)"externalReferenceCode", String.class));
        graphQLDTOProperties.add(GraphQLDTOProperty.of((String)"status", (boolean)true, String.class));
        ArrayList<GraphQLDTOProperty> relationshipGraphQLDTOProperties = new ArrayList<GraphQLDTOProperty>();
        List objectFields = objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId());
        for (ObjectField objectField : objectFields) {
            if (objectField.getListTypeDefinitionId() != 0L) {
                graphQLDTOProperties.add(GraphQLDTOProperty.of((String)objectField.getName(), ListEntry.class));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                String objectFieldName = objectField.getName();
                String relationshipIdName = objectFieldName.split("_")[1];
                graphQLDTOProperties.add(GraphQLDTOProperty.of((String)relationshipIdName, Long.class));
                String relationshipName = StringUtil.replaceLast((String)relationshipIdName, (String)"Id", (String)"");
                relationshipGraphQLDTOProperties.add(GraphQLDTOProperty.of((String)relationshipName, Map.class));
                continue;
            }
            graphQLDTOProperties.add(GraphQLDTOProperty.of((String)objectField.getName(), _typedClasses.getOrDefault(objectField.getDBType(), Object.class)));
        }
        List objectRelationships = objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            if (!Objects.equals(objectRelationship.getType(), "manyToMany")) continue;
            graphQLDTOProperties.add(GraphQLDTOProperty.of((String)objectRelationship.getName(), Long.class));
            relationshipGraphQLDTOProperties.add(GraphQLDTOProperty.of((String)objectRelationship.getName(), Map.class));
        }
        return new ObjectDefinitionGraphQLDTOContributor(objectDefinition.getCompanyId(), new ObjectEntryEntityModel(objectFields), filterParserProvider, graphQLDTOProperties, StringUtil.removeSubstring((String)objectDefinition.getPKObjectFieldName(), (String)"c_"), objectDefinition, objectEntryManager, objectFieldLocalService, objectScopeProvider, relationshipGraphQLDTOProperties, objectDefinition.getShortName(), objectDefinition.getName());
    }

    public Map<String, Object> createDTO(Map<String, Object> dto, DTOConverterContext dtoConverterContext) throws Exception {
        return this._toMap(this._objectEntryManager.addObjectEntry(dtoConverterContext, this._objectDefinition, this._toObjectEntry(dto), (String)dtoConverterContext.getAttribute("scopeKey")));
    }

    public boolean deleteDTO(long id) throws Exception {
        this._objectEntryManager.deleteObjectEntry(this._objectDefinition, id);
        return true;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public Map<String, Object> getDTO(DTOConverterContext dtoConverterContext, long id) throws Exception {
        return this._toMap(this._objectEntryManager.getObjectEntry(dtoConverterContext, this._objectDefinition, id));
    }

    public Page<Map<String, Object>> getDTOs(Aggregation aggregation, DTOConverterContext dtoConverterContext, Filter filter, Pagination pagination, String search, Sort[] sorts) throws Exception {
        Page page = null;
        page = GetterUtil.getBoolean((String)PropsUtil.get((String)"feature.flag.LPS-153768")) ? this._objectEntryManager.getObjectEntries(((Long)dtoConverterContext.getAttribute("companyId")).longValue(), this._objectDefinition, (String)dtoConverterContext.getAttribute("scopeKey"), aggregation, dtoConverterContext, pagination, PredicateUtil.toPredicate(this._filterParserProvider, ParamUtil.getString((HttpServletRequest)dtoConverterContext.getHttpServletRequest(), (String)"filter"), this._objectDefinition.getObjectDefinitionId(), this._objectFieldLocalService), search, sorts) : this._objectEntryManager.getObjectEntries(((Long)dtoConverterContext.getAttribute("companyId")).longValue(), this._objectDefinition, (String)dtoConverterContext.getAttribute("scopeKey"), aggregation, dtoConverterContext, filter, pagination, search, sorts);
        Collection items = page.getItems();
        Stream stream = items.stream();
        return Page.of((Map)page.getActions(), (List)page.getFacets(), (Collection)stream.map(this::_toMap).collect(Collectors.toList()), (Pagination)pagination, (long)page.getTotalCount());
    }

    public EntityModel getEntityModel() {
        return this._entityModel;
    }

    public List<GraphQLDTOProperty> getGraphQLDTOProperties() {
        return this._graphQLDTOProperties;
    }

    public String getIdName() {
        return this._idName;
    }

    public List<GraphQLDTOProperty> getRelationshipGraphQLDTOProperties() {
        return this._relationshipGraphQLDTOProperties;
    }

    public <T> T getRelationshipValue(DTOConverterContext dtoConverterContext, long id, Class<T> relationshipClass, String relationshipName) throws Exception {
        if (!Objects.equals(relationshipClass, Map.class)) {
            return null;
        }
        String relationshipIdName = null;
        ObjectEntry objectEntry = this._objectEntryManager.getObjectEntry(dtoConverterContext, this._objectDefinition, id);
        Map properties = objectEntry.getProperties();
        for (String key : properties.keySet()) {
            if (!key.contains(relationshipName)) continue;
            relationshipIdName = key;
            break;
        }
        if (relationshipIdName == null) {
            Page page = this._objectEntryManager.getObjectEntryRelatedObjectEntries(dtoConverterContext, this._objectDefinition, Long.valueOf(id), relationshipName, Pagination.of((int)-1, (int)-1));
            return (T)TransformUtil.transform((Collection)page.getItems(), itemObjectEntry -> this._toMap((ObjectEntry)itemObjectEntry));
        }
        Object relationshipId = properties.get(relationshipIdName);
        if (!(relationshipId instanceof Long)) {
            return null;
        }
        return (T)this._toMap(this._objectEntryManager.fetchObjectEntry(dtoConverterContext, null, ((Long)relationshipId).longValue()), relationshipIdName);
    }

    public String getResourceName() {
        return this._resourceName;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public boolean hasScope() {
        return this._objectScopeProvider.isGroupAware();
    }

    public Map<String, Object> updateDTO(Map<String, Object> dto, DTOConverterContext dtoConverterContext, long id) throws Exception {
        return this._toMap(this._objectEntryManager.updateObjectEntry(dtoConverterContext, this._objectDefinition, id, this._toObjectEntry(dto)));
    }

    private ObjectDefinitionGraphQLDTOContributor(long companyId, EntityModel entityModel, FilterParserProvider filterParserProvider, List<GraphQLDTOProperty> graphQLDTOProperties, String idName, ObjectDefinition objectDefinition, ObjectEntryManager objectEntryManager, ObjectFieldLocalService objectFieldLocalService, ObjectScopeProvider objectScopeProvider, List<GraphQLDTOProperty> relationshipGraphQLDTOProperties, String resourceName, String typeName) {
        this._companyId = companyId;
        this._entityModel = entityModel;
        this._filterParserProvider = filterParserProvider;
        this._graphQLDTOProperties = graphQLDTOProperties;
        this._idName = idName;
        this._objectDefinition = objectDefinition;
        this._objectEntryManager = objectEntryManager;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectScopeProvider = objectScopeProvider;
        this._relationshipGraphQLDTOProperties = relationshipGraphQLDTOProperties;
        this._resourceName = resourceName;
        this._typeName = typeName;
    }

    private Map<String, Object> _toMap(ObjectEntry objectEntry) {
        return this._toMap(objectEntry, this.getIdName());
    }

    private Map<String, Object> _toMap(ObjectEntry objectEntry, String objectEntryIdName) {
        if (objectEntry == null) {
            return null;
        }
        Map properties = objectEntry.getProperties();
        properties.put(objectEntryIdName, objectEntry.getId());
        properties.put("creator", objectEntry.getCreator());
        properties.put("dateCreated", objectEntry.getDateCreated());
        properties.put("dateModified", objectEntry.getDateModified());
        properties.put("externalReferenceCode", objectEntry.getExternalReferenceCode());
        Status status = objectEntry.getStatus();
        properties.put("status", status.getLabel());
        return properties;
    }

    private ObjectEntry _toObjectEntry(Map<String, Object> map) {
        ObjectEntry objectEntry = new ObjectEntry();
        if (map == null) {
            return objectEntry;
        }
        objectEntry.setId((Long)map.get(this.getIdName()));
        Map properties = objectEntry.getProperties();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return objectEntry;
    }
}

