/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor.util;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OpenAPIContributorUtil {
    public static void copySchemas(String schemaName, Map<String, Schema> sourceSchemas, boolean system, OpenAPI targetOpenAPI) {
        if (system) {
            for (String sourceSchemaName : sourceSchemas.keySet()) {
                OpenAPIContributorUtil._copySchema(false, sourceSchemaName, sourceSchemas, targetOpenAPI);
            }
        } else {
            OpenAPIContributorUtil._copySchema(true, schemaName, sourceSchemas, targetOpenAPI);
            OpenAPIContributorUtil._copySchema(true, OpenAPIContributorUtil.getPageSchemaName(schemaName), sourceSchemas, targetOpenAPI);
        }
    }

    public static String getPageSchemaName(String schemaName) {
        return "Page" + schemaName;
    }

    public static Map<String, Schema> getSystemObjectSchemas(BundleContext bundleContext, String externalDTOClassName, OpenAPIResource openAPIResource) throws Exception {
        Object[] serviceReferences = bundleContext.getServiceReferences((String)null, "(&(entity.class.name=" + externalDTOClassName + ")(osgi.jaxrs.resource=true))");
        if (ArrayUtil.isEmpty((Object[])serviceReferences)) {
            throw new IllegalStateException();
        }
        Object object = bundleContext.getService((ServiceReference)serviceReferences[0]);
        return openAPIResource.getSchemas(SetUtil.fromArray((Object[])new Class[]{object.getClass()}));
    }

    private static void _copySchema(boolean force, String schemaName, Map<String, Schema> sourceSchemas, OpenAPI targetOpenAPI) {
        Components targetComponents = targetOpenAPI.getComponents();
        Map targetSchemas = targetComponents.getSchemas();
        if (!force && targetSchemas.containsKey(schemaName)) {
            return;
        }
        targetSchemas.put(schemaName, sourceSchemas.get(schemaName));
    }
}

