/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.BaseOpenAPIContributor;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.util.OpenAPIContributorUtil;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResourceProvider;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.OpenAPIContext;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={OpenAPIContributor.class})
public class RelatedObjectEntryOpenAPIContributor
extends BaseOpenAPIContributor {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryOpenAPIResourceProvider _objectEntryOpenAPIResourceProvider;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public void contribute(OpenAPI openAPI, OpenAPIContext openAPIContext) throws Exception {
        if (openAPIContext == null) {
            return;
        }
        HashMap<ObjectDefinition, SystemObjectDefinitionManager> systemObjectDefinitionManagerMap = new HashMap<ObjectDefinition, SystemObjectDefinitionManager>();
        for (ObjectDefinition objectDefinition : this._objectDefinitionLocalService.getSystemObjectDefinitions()) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            if (systemObjectDefinitionManager == null) continue;
            JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
            String path = openAPIContext.getPath();
            if (!path.contains(jaxRsApplicationDescriptor.getApplicationPath())) continue;
            systemObjectDefinitionManagerMap.put(objectDefinition, systemObjectDefinitionManager);
        }
        for (Map.Entry entry : systemObjectDefinitionManagerMap.entrySet()) {
            ObjectDefinition systemObjectDefinition = (ObjectDefinition)entry.getKey();
            for (ObjectRelationship systemObjectRelationship : this._objectRelationshipLocalService.getObjectRelationships(systemObjectDefinition.getObjectDefinitionId())) {
                this._contribute(openAPI, systemObjectDefinition, (SystemObjectDefinitionManager)entry.getValue(), systemObjectRelationship, openAPIContext.getVersion());
            }
        }
    }

    @Activate
    protected void activate() {
        this.init(this._dtoConverterRegistry, this._systemObjectDefinitionManagerRegistry);
    }

    private void _contribute(OpenAPI openAPI, ObjectDefinition systemObjectDefinition, SystemObjectDefinitionManager systemObjectDefinitionManager, final ObjectRelationship systemObjectRelationship, String version) throws Exception {
        ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)systemObjectDefinition, (ObjectRelationship)systemObjectRelationship);
        if (!relatedObjectDefinition.isActive()) {
            return;
        }
        Paths paths = openAPI.getPaths();
        final String relatedSchemaName = this.getSchemaName(relatedObjectDefinition);
        ObjectEntryOpenAPIResource objectEntryOpenAPIResource = this._objectEntryOpenAPIResourceProvider.getObjectEntryOpenAPIResource(relatedObjectDefinition);
        Map relatedSchemas = objectEntryOpenAPIResource.getSchemas();
        OpenAPIContributorUtil.copySchemas(relatedSchemaName, relatedSchemas, relatedObjectDefinition.isUnmodifiableSystemObject(), openAPI);
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
        final String schemaName = this.getSchemaName(systemObjectDefinition);
        String name = StringBundler.concat((String[])new String[]{"/", version, "/", jaxRsApplicationDescriptor.getPath(), "/", this._getIdParameterTemplate(schemaName), "/", systemObjectRelationship.getName()});
        paths.addPathItem(name, new PathItem(){
            {
                this.get(RelatedObjectEntryOpenAPIContributor.this._getGetOperation(systemObjectRelationship, relatedSchemaName, schemaName));
            }
        });
        paths.addPathItem(StringBundler.concat((String[])new String[]{name, "/", this._getIdParameterTemplate(relatedObjectDefinition.getShortName())}), new PathItem(){
            {
                this.delete(RelatedObjectEntryOpenAPIContributor.this._getDeleteOperation(systemObjectRelationship, relatedSchemaName, schemaName));
                this.put(RelatedObjectEntryOpenAPIContributor.this._getPutOperation(systemObjectRelationship, relatedSchemaName, schemaName));
            }
        });
    }

    private Content _getContent(String schemaName) {
        Content content = new Content();
        MediaType mediaType = new MediaType();
        if (schemaName != null) {
            Schema schema = new Schema();
            schema.set$ref(schemaName);
            mediaType.setSchema(schema);
        }
        content.addMediaType("application/json", mediaType);
        content.addMediaType("application/xml", mediaType);
        return content;
    }

    private Operation _getDeleteOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("delete", objectRelationship.getName(), schemaName));
                this.parameters(Arrays.asList(new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(schemaName));
                        this.required(true);
                    }
                }, new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(relatedSchemaName));
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(null));
                            }
                        });
                    }
                });
                this.tags(Arrays.asList(schemaName));
            }
        };
    }

    private Operation _getGetOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        final String parameterName = this._getIdParameterName(schemaName);
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("get", objectRelationship.getName(), schemaName));
                this.parameters(Arrays.asList(new Parameter(){
                    {
                        this.in("path");
                        this.name(parameterName);
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(OpenAPIContributorUtil.getPageSchemaName(relatedSchemaName)));
                            }
                        });
                    }
                });
                this.tags(Arrays.asList(schemaName));
            }
        };
    }

    private String _getIdParameterName(String name) {
        return StringUtil.lowerCaseFirstLetter((String)name) + "Id";
    }

    private String _getIdParameterTemplate(String name) {
        return "{" + this._getIdParameterName(name) + "}";
    }

    private String _getOperationId(String method, String objectRelationshipName, String systemObjectDefinitionName) {
        String sufix = "";
        if (StringUtil.equals((String)method, (String)"get")) {
            sufix = "Page";
        }
        return StringBundler.concat((String[])new String[]{method, systemObjectDefinitionName, StringUtil.upperCaseFirstLetter((String)objectRelationshipName), sufix});
    }

    private Operation _getPutOperation(final ObjectRelationship objectRelationship, final String relatedSchemaName, final String schemaName) {
        return new Operation(){
            {
                this.operationId(RelatedObjectEntryOpenAPIContributor.this._getOperationId("put", objectRelationship.getName(), schemaName));
                this.parameters(Arrays.asList(new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(schemaName));
                        this.required(true);
                    }
                }, new Parameter(){
                    {
                        this.in("path");
                        this.name(RelatedObjectEntryOpenAPIContributor.this._getIdParameterName(relatedSchemaName));
                        this.required(true);
                    }
                }));
                this.responses(new ApiResponses(){
                    {
                        this.setDefault(new ApiResponse(){
                            {
                                this.setContent(RelatedObjectEntryOpenAPIContributor.this._getContent(relatedSchemaName));
                            }
                        });
                    }
                });
                this.tags(Arrays.asList(schemaName));
            }
        };
    }
}

