/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor;

import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.BaseOpenAPIContributor;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.util.OpenAPIContributorUtil;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResourceProvider;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.OpenAPIContext;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.framework.BundleContext;

public class ObjectEntryOpenAPIContributor
extends BaseOpenAPIContributor {
    private final boolean _addRelatedSchemas;
    private final BundleContext _bundleContext;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryOpenAPIResource _objectEntryOpenAPIResource;
    private final ObjectEntryOpenAPIResourceProvider _objectEntryOpenAPIResourceProvider;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final OpenAPIResource _openAPIResource;

    public ObjectEntryOpenAPIContributor(boolean addRelatedSchemas, BundleContext bundleContext, DTOConverterRegistry dtoConverterRegistry, ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryOpenAPIResource objectEntryOpenAPIResource, ObjectEntryOpenAPIResourceProvider objectEntryOpenAPIResourceProvider, ObjectRelationshipLocalService objectRelationshipLocalService, OpenAPIResource openAPIResource, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._addRelatedSchemas = addRelatedSchemas;
        this._bundleContext = bundleContext;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryOpenAPIResource = objectEntryOpenAPIResource;
        this._objectEntryOpenAPIResourceProvider = objectEntryOpenAPIResourceProvider;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._openAPIResource = openAPIResource;
        this.init(dtoConverterRegistry, systemObjectDefinitionManagerRegistry);
    }

    public void contribute(OpenAPI openAPI, OpenAPIContext openAPIContext) throws Exception {
        List objectActions = this._objectActionLocalService.getObjectActions(this._objectDefinition.getObjectDefinitionId(), "standalone");
        Map<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = this._getRelatedObjectDefinitionsMap();
        Paths paths = openAPI.getPaths();
        for (String key : new ArrayList(paths.keySet())) {
            if (!key.contains("objectActionName") && !key.contains("objectRelationshipName")) continue;
            if (key.contains("objectActionName")) {
                ListUtil.isNotEmptyForEach((List)objectActions, objectAction -> this._addObjectActionPathItem(key, (ObjectAction)objectAction, paths));
            } else if (key.contains("objectRelationshipName")) {
                for (Map.Entry<ObjectRelationship, ObjectDefinition> entry : relatedObjectDefinitionsMap.entrySet()) {
                    ObjectRelationship objectRelationship = entry.getKey();
                    ObjectDefinition relatedObjectDefinition = entry.getValue();
                    String relatedSchemaName = this.getSchemaName(relatedObjectDefinition);
                    if (this._addRelatedSchemas) {
                        this._addObjectRelationshipSchema(relatedObjectDefinition, openAPI, relatedSchemaName);
                    }
                    if (Objects.equals(objectRelationship.getType(), "manyToMany") || Objects.equals(objectRelationship.getType(), "oneToMany") && objectRelationship.getObjectDefinitionId1() == this._objectDefinition.getObjectDefinitionId()) {
                        this._addObjectRelationshipPathItem(key, objectRelationship, paths, relatedSchemaName);
                    }
                    if (this._addRelatedSchemas && relatedSchemaName != null) {
                        this._setSchemaDescription(objectRelationship, openAPI, relatedSchemaName);
                        ((Schema)openAPI.getComponents().getSchemas().get(this._objectDefinition.getShortName())).getProperties().put(objectRelationship.getName(), this._getSchema(objectRelationship, relatedSchemaName));
                        continue;
                    }
                    ((Schema)openAPI.getComponents().getSchemas().get(this._objectDefinition.getShortName())).getProperties().put(objectRelationship.getName(), this._getSchema(objectRelationship, null));
                }
            }
            paths.remove((Object)key);
        }
        if (!this._objectDefinition.isEnableCategorization()) {
            Components components = openAPI.getComponents();
            Map schemas = components.getSchemas();
            Schema objectDefinitionSchema = (Schema)schemas.get(this._objectDefinition.getShortName());
            Map properties = objectDefinitionSchema.getProperties();
            properties.remove("keywords");
            properties.remove("taxonomyCategoryBriefs");
            properties.remove("taxonomyCategoryIds");
            schemas.remove("TaxonomyCategoryBrief");
        }
        if (openAPIContext != null && FeatureFlagManagerUtil.isEnabled((String)"LPS-180090")) {
            MapSchema collectionActionsMapSchema = this._getActionsMapSchema(openAPI, "Page" + this._objectDefinition.getShortName());
            collectionActionsMapSchema.setAdditionalProperties(null);
            collectionActionsMapSchema.setProperties(this._getCollectionActionSchemas(openAPIContext, openAPI.getPaths()));
            MapSchema individualActionsMapSchema = this._getActionsMapSchema(openAPI, this._objectDefinition.getShortName());
            individualActionsMapSchema.setAdditionalProperties(null);
            individualActionsMapSchema.setProperties(this._getIndividualActionSchemas(openAPIContext, openAPI.getPaths()));
            MapSchema permissionActionsMapSchema = this._getActionsMapSchema(openAPI, "PagePermission");
            permissionActionsMapSchema.setAdditionalProperties(null);
            permissionActionsMapSchema.setProperties(this._getIndividualActionSchemas(openAPIContext, openAPI.getPaths()));
        }
    }

    private void _addObjectActionPathItem(String key, ObjectAction objectAction, Paths paths) {
        paths.addPathItem(StringUtil.replace((String)key, (String[])new String[]{"objectEntry", "{objectActionName}"}, (String[])new String[]{StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), objectAction.getName()}), this._createObjectActionPathItem(objectAction, (PathItem)paths.get((Object)key)));
    }

    private void _addObjectRelationshipPathItem(String key, ObjectRelationship objectRelationship, Paths paths, String schemaName) {
        paths.addPathItem(StringUtil.replace((String)key, (String[])new String[]{"currentObjectEntry", "{objectRelationshipName}", "relatedObjectEntry"}, (String[])new String[]{StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), objectRelationship.getName(), StringUtil.lowerCaseFirstLetter((String)schemaName)}), this._createObjectRelationshipPathItem((PathItem)paths.get((Object)key), objectRelationship, schemaName));
    }

    private void _addObjectRelationshipSchema(ObjectDefinition objectDefinition, OpenAPI openAPI, String schemaName) throws Exception {
        ObjectEntryOpenAPIResource objectEntryOpenAPIResource;
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        if (schemas.containsKey(schemaName)) {
            return;
        }
        HashMap<String, Schema> sourceSchemas = null;
        sourceSchemas = objectDefinition.isUnmodifiableSystemObject() ? OpenAPIContributorUtil.getSystemObjectSchemas(this._bundleContext, this.getExternalDTOClassName(objectDefinition), this._openAPIResource) : ((objectEntryOpenAPIResource = this._objectEntryOpenAPIResourceProvider.getObjectEntryOpenAPIResource(objectDefinition)) != null ? objectEntryOpenAPIResource.getSchemas() : new HashMap<String, Schema>());
        OpenAPIContributorUtil.copySchemas(schemaName, sourceSchemas, objectDefinition.isUnmodifiableSystemObject(), openAPI);
    }

    private String _buildActionsURL(OpenAPIContext openAPIContext, String pathName) {
        return openAPIContext.getBaseURL() + StringUtil.removeFirst((String)pathName, (String)"/");
    }

    private Schema _createActionSchema(OpenAPIContext openAPIContext, Map.Entry<PathItem.HttpMethod, Operation> operation, String pathName) {
        Schema actionSchema = new Schema();
        actionSchema.setProperties((Map)HashMapBuilder.put((Object)"href", () -> {
            StringSchema stringSchema = new StringSchema();
            stringSchema.setDefault((Object)this._buildActionsURL(openAPIContext, pathName));
            return stringSchema;
        }).put((Object)"method", () -> {
            StringSchema stringSchema = new StringSchema();
            stringSchema.setDefault(operation.getKey());
            return stringSchema;
        }).build());
        return actionSchema;
    }

    private PathItem _createObjectActionPathItem(final ObjectAction objectAction, PathItem pathItem) {
        Map operations = pathItem.readOperationsMap();
        final Operation operation = (Operation)operations.get(PathItem.HttpMethod.PUT);
        if (operation == null) {
            return new PathItem();
        }
        return new PathItem(){
            {
                this.put(new Operation(){
                    {
                        this.operationId(StringBundler.concat((String[])new String[]{"put", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectAction.getName())}));
                        this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, null));
                        this.responses(operation.getResponses());
                        this.tags(operation.getTags());
                    }
                });
            }
        };
    }

    private PathItem _createObjectRelationshipPathItem(PathItem existingPathItem, ObjectRelationship objectRelationship, String schemaName) {
        PathItem pathItem = new PathItem();
        Map operations = existingPathItem.readOperationsMap();
        if (operations.containsKey(PathItem.HttpMethod.DELETE)) {
            pathItem.delete(this._getObjectRelationshipDeleteOperation(objectRelationship, existingPathItem.getDelete(), schemaName));
        }
        if (operations.containsKey(PathItem.HttpMethod.GET)) {
            pathItem.get(this._getObjectRelationshipGetOperation(objectRelationship, existingPathItem.getGet(), schemaName));
        }
        if (operations.containsKey(PathItem.HttpMethod.PUT)) {
            pathItem.put(this._getObjectRelationshipPutOperation(objectRelationship, existingPathItem.getPut(), schemaName));
        }
        return pathItem;
    }

    private MapSchema _getActionsMapSchema(OpenAPI openAPI, String schemaName) {
        Components components = openAPI.getComponents();
        Map schemas1 = components.getSchemas();
        Schema schema = (Schema)schemas1.get(schemaName);
        Map schemas2 = schema.getProperties();
        return (MapSchema)schemas2.get("actions");
    }

    private Map<String, Schema> _getCollectionActionSchemas(OpenAPIContext openAPIContext, Paths paths) {
        HashMap<String, Schema> collectionActionSchemas = new HashMap<String, Schema>();
        for (Map.Entry key : paths.entrySet()) {
            String pathName = (String)key.getKey();
            PathItem pathItem = (PathItem)key.getValue();
            Map operations = pathItem.readOperationsMap();
            if (StringUtil.equals((String)this._objectDefinition.getScope(), (String)"site")) {
                if (!pathName.equals("/scopes/{scopeKey}")) continue;
                this._setCollectionActionSchemas(collectionActionSchemas, openAPIContext, operations, pathName);
                continue;
            }
            if (pathName.equals("/")) {
                this._setCollectionActionSchemas(collectionActionSchemas, openAPIContext, operations, pathName);
                continue;
            }
            if (!pathName.equals("/batch")) continue;
            this._setCollectionActionSchemas(collectionActionSchemas, openAPIContext, operations, pathName);
        }
        return collectionActionSchemas;
    }

    private Content _getContent(Content originalContent, String schemaName) {
        Content content = new Content();
        Schema schema = null;
        if (schemaName != null) {
            schema = new Schema();
            schema.set$ref(schemaName);
        }
        for (String key : originalContent.keySet()) {
            final Schema finalSchema = schema;
            content.addMediaType(key, new MediaType(){
                {
                    this.setSchema(finalSchema);
                }
            });
        }
        return content;
    }

    private String _getDescription(ObjectRelationship objectRelationship) {
        return StringBundler.concat((String[])new String[]{"Information about the relationship ", objectRelationship.getName(), " can be embedded with \"nestedFields\"."});
    }

    private Map<String, Schema> _getIndividualActionSchemas(OpenAPIContext openAPIContext, Paths paths) {
        HashMap<String, Schema> individualActionSchemas = new HashMap<String, Schema>();
        String objectEntryIdPathName = StringBundler.concat((String[])new String[]{"/", "{", StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()), "Id}"});
        for (Map.Entry key : paths.entrySet()) {
            String pathName = (String)key.getKey();
            PathItem pathItem = (PathItem)key.getValue();
            Map operations = pathItem.readOperationsMap();
            if (pathName.equals(objectEntryIdPathName)) {
                this._setIndividualActionSchemas(individualActionSchemas, openAPIContext, operations, pathName);
                continue;
            }
            if (pathName.equals(objectEntryIdPathName + "/permissions")) {
                this._setIndividualActionSchemas(individualActionSchemas, openAPIContext, operations, pathName);
                continue;
            }
            if (!pathName.contains("by-external-reference-code") || !pathName.contains("object-actions")) continue;
            this._setIndividualActionSchemas(individualActionSchemas, openAPIContext, operations, pathName);
        }
        return individualActionSchemas;
    }

    private ApiResponses _getObjectRelationshipApiResponses(Operation operation, final String schemaName) {
        ApiResponses apiResponses = new ApiResponses();
        ApiResponses operationApiResponses = operation.getResponses();
        for (Map.Entry entry : operationApiResponses.entrySet()) {
            final ApiResponse apiResponse = (ApiResponse)entry.getValue();
            apiResponses.put(entry.getKey(), (Object)new ApiResponse(){
                {
                    this.setContent(ObjectEntryOpenAPIContributor.this._getContent(apiResponse.getContent(), schemaName));
                    this.setDescription(apiResponse.getDescription());
                }
            });
        }
        return apiResponses;
    }

    private Operation _getObjectRelationshipDeleteOperation(final ObjectRelationship objectRelationship, final Operation operation, final String schemaName) {
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{"delete", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), schemaName}));
                this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, schemaName));
                this.responses(ObjectEntryOpenAPIContributor.this._getObjectRelationshipApiResponses(operation, null));
                this.tags(operation.getTags());
            }
        };
    }

    private Operation _getObjectRelationshipGetOperation(final ObjectRelationship objectRelationship, final Operation operation, final String schemaName) {
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{"get", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), schemaName, "Page"}));
                this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, schemaName));
                this.responses(ObjectEntryOpenAPIContributor.this._getObjectRelationshipApiResponses(operation, OpenAPIContributorUtil.getPageSchemaName(schemaName)));
                this.tags(operation.getTags());
            }
        };
    }

    private Operation _getObjectRelationshipPutOperation(final ObjectRelationship objectRelationship, final Operation operation, final String schemaName) {
        return new Operation(){
            {
                this.operationId(StringBundler.concat((String[])new String[]{"put", ObjectEntryOpenAPIContributor.this._objectDefinition.getShortName(), StringUtil.upperCaseFirstLetter((String)objectRelationship.getName()), schemaName}));
                this.parameters(ObjectEntryOpenAPIContributor.this._getParameters(operation, schemaName));
                this.responses(ObjectEntryOpenAPIContributor.this._getObjectRelationshipApiResponses(operation, schemaName));
                this.tags(operation.getTags());
            }
        };
    }

    private List<Parameter> _getParameters(Operation operation, String schemaName) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (final Parameter parameter : operation.getParameters()) {
            String parameterName = parameter.getName();
            if (Objects.equals(parameterName, "objectActionName") || Objects.equals(parameterName, "objectRelationshipName")) continue;
            if (Objects.equals(parameterName, "currentObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"currentObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)this._objectDefinition.getShortName()));
            } else if (Objects.equals(parameterName, "relatedObjectEntryId")) {
                parameterName = StringUtil.replace((String)parameterName, (String)"relatedObjectEntry", (String)StringUtil.lowerCaseFirstLetter((String)schemaName));
            }
            final String finalParameterName = parameterName;
            parameters.add(new Parameter(){
                {
                    this.in(parameter.getIn());
                    this.name(finalParameterName);
                    this.required(parameter.getRequired());
                    this.schema(parameter.getSchema());
                }
            });
        }
        return parameters;
    }

    private Map<ObjectRelationship, ObjectDefinition> _getRelatedObjectDefinitionsMap() throws Exception {
        HashMap<ObjectRelationship, ObjectDefinition> relatedObjectDefinitionsMap = new HashMap<ObjectRelationship, ObjectDefinition>();
        List objectRelationships = this._objectRelationshipLocalService.getAllObjectRelationships(this._objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            relatedObjectDefinitionsMap.put(objectRelationship, ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)this._objectDefinition, (ObjectRelationship)objectRelationship));
        }
        return relatedObjectDefinitionsMap;
    }

    private Schema _getSchema(final ObjectRelationship objectRelationship, String schemaName) {
        final ObjectSchema objectSchema = new ObjectSchema();
        objectSchema.set$ref(schemaName);
        if (Objects.equals(objectRelationship.getType(), "manyToMany") || Objects.equals(objectRelationship.getType(), "oneToMany") && objectRelationship.getObjectDefinitionId1() == this._objectDefinition.getObjectDefinitionId()) {
            return new ArraySchema(){
                {
                    this.setDescription(ObjectEntryOpenAPIContributor.this._getDescription(objectRelationship));
                    this.setItems((Schema)objectSchema);
                }
            };
        }
        objectSchema.setDescription(this._getDescription(objectRelationship));
        return objectSchema;
    }

    private void _setCollectionActionSchemas(Map<String, Schema> actionSchemas, OpenAPIContext openAPIContext, Map<PathItem.HttpMethod, Operation> operations, String pathName) {
        for (Map.Entry<PathItem.HttpMethod, Operation> operation : operations.entrySet()) {
            PathItem.HttpMethod pathItemHttpMethod = operation.getKey();
            Schema actionSchema = this._createActionSchema(openAPIContext, operation, pathName);
            if (Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.DELETE) && pathName.contains("/batch")) {
                actionSchemas.put("deleteBatch", actionSchema);
                continue;
            }
            if (Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.POST)) {
                if (pathName.contains("/batch")) {
                    actionSchemas.put("createBatch", actionSchema);
                    continue;
                }
                if (pathName.contains("scopeKey")) {
                    actionSchemas.put("create", actionSchema);
                    continue;
                }
                if (!pathName.equals("/")) continue;
                actionSchemas.put("create", actionSchema);
                continue;
            }
            if (!Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.PUT) || !pathName.contains("/batch")) continue;
            actionSchemas.put("updateBatch", actionSchema);
        }
    }

    private void _setIndividualActionSchemas(Map<String, Schema> actionSchemas, OpenAPIContext openAPIContext, Map<PathItem.HttpMethod, Operation> operations, String pathName) {
        for (Map.Entry<PathItem.HttpMethod, Operation> operation : operations.entrySet()) {
            PathItem.HttpMethod pathItemHttpMethod = operation.getKey();
            Schema actionSchema = this._createActionSchema(openAPIContext, operation, pathName);
            if (Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.GET)) {
                if (pathName.contains("/permissions")) {
                    actionSchemas.put("permissions", actionSchema);
                    continue;
                }
                actionSchemas.put(StringUtil.toLowerCase((String)pathItemHttpMethod.name()), actionSchema);
                continue;
            }
            if (Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.PATCH)) {
                actionSchemas.put("update", actionSchema);
                continue;
            }
            if (Objects.equals(pathItemHttpMethod, PathItem.HttpMethod.PUT) && !pathName.contains("/permissions")) {
                if (pathName.contains("object-actions")) {
                    actionSchemas.put(StringUtil.extractLast((String)pathName, (String)"/"), actionSchema);
                    continue;
                }
                actionSchemas.put("replace", actionSchema);
                continue;
            }
            if (pathName.contains("/permissions")) continue;
            actionSchemas.put(StringUtil.toLowerCase((String)pathItemHttpMethod.name()), actionSchema);
        }
    }

    private void _setSchemaDescription(ObjectRelationship objectRelationship, OpenAPI openAPI, String relatedSchemaName) {
        if (Objects.equals(objectRelationship.getType(), "oneToMany") && objectRelationship.getObjectDefinitionId2() == this._objectDefinition.getObjectDefinitionId()) {
            Components components = openAPI.getComponents();
            Map schemas = components.getSchemas();
            Schema schema = (Schema)schemas.get(relatedSchemaName);
            schema.setDescription(this._getDescription(objectRelationship));
        }
    }
}

