/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.openapi.contributor;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.system.JaxRsApplicationDescriptor;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;

public abstract class BaseOpenAPIContributor
implements OpenAPIContributor {
    private DTOConverterRegistry _dtoConverterRegistry;
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    protected String getExternalDTOClassName(ObjectDefinition systemObjectDefinition) {
        SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(systemObjectDefinition.getName());
        JaxRsApplicationDescriptor jaxRsApplicationDescriptor = systemObjectDefinitionManager.getJaxRsApplicationDescriptor();
        DTOConverter dtoConverter = this._dtoConverterRegistry.getDTOConverter(jaxRsApplicationDescriptor.getApplicationName(), systemObjectDefinition.getClassName(), jaxRsApplicationDescriptor.getVersion());
        return dtoConverter.getExternalDTOClassName();
    }

    protected String getSchemaName(ObjectDefinition objectDefinition) {
        if (objectDefinition.isUnmodifiableSystemObject()) {
            return StringUtil.extractLast((String)this.getExternalDTOClassName(objectDefinition), (String)".");
        }
        return objectDefinition.getShortName();
    }

    protected void init(DTOConverterRegistry dtoConverterRegistry, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
    }
}

