/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.vulcan.extension.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.internal.vulcan.extension.v1_0.BaseObjectExtensionProvider;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.rest.manager.v1_0.ObjectRelationshipElementsParser;
import com.liferay.object.rest.manager.v1_0.ObjectRelationshipElementsParserRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.extension.ExtensionProvider;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import com.liferay.portal.vulcan.extension.validation.DefaultPropertyValidator;
import com.liferay.portal.vulcan.extension.validation.PropertyValidator;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ExtensionProvider.class})
public class ObjectRelationshipExtensionProvider
extends BaseObjectExtensionProvider {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipElementsParserRegistry _objectRelationshipElementsParserRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipService _objectRelationshipService;

    public Map<String, Serializable> getExtendedProperties(long companyId, String className, Object entity) throws Exception {
        ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
        return NestedFieldsSupplier.supply(nestedFieldName -> {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), nestedFieldName);
            if (objectRelationship == null || !objectRelationship.isAllowedObjectRelationshipType(objectRelationship.getType())) {
                return null;
            }
            ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
            if (!relatedObjectDefinition.isActive() || relatedObjectDefinition.isUnmodifiableSystemObject()) {
                return null;
            }
            long primaryKey = this.getPrimaryKey(entity);
            if (this._isManyToOneObjectRelationship(objectDefinition, objectRelationship, relatedObjectDefinition)) {
                DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
                return defaultObjectEntryManager.fetchRelatedManyToOneObjectEntry((DTOConverterContext)this._getDefaultDTOConverterContext(objectDefinition, primaryKey, null), objectDefinition, Long.valueOf(primaryKey), objectRelationship.getName());
            }
            DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
            Page relatedObjectEntriesPage = defaultObjectEntryManager.getObjectEntryRelatedObjectEntries((DTOConverterContext)this._getDefaultDTOConverterContext(objectDefinition, primaryKey, null), objectDefinition, Long.valueOf(primaryKey), objectRelationship.getName(), Pagination.of((int)-1, (int)-1));
            return (Serializable)((Object)relatedObjectEntriesPage.getItems());
        });
    }

    public Map<String, PropertyDefinition> getExtendedPropertyDefinitions(long companyId, String className) throws Exception {
        HashMap<String, PropertyDefinition> extendedPropertyDefinitions = new HashMap<String, PropertyDefinition>();
        ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getAllObjectRelationships(objectDefinition.getObjectDefinitionId())) {
            ObjectDefinition relatedObjectDefinition;
            if (!objectRelationship.isAllowedObjectRelationshipType(objectRelationship.getType()) || !(relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship)).isActive() || relatedObjectDefinition.isUnmodifiableSystemObject()) continue;
            extendedPropertyDefinitions.put(objectRelationship.getName(), new PropertyDefinition(Collections.singleton(ObjectEntry.class), null, StringUtil.removeFirst((String)relatedObjectDefinition.getName(), (String)"C_"), StringBundler.concat((String[])new String[]{"Information about the object relationship ", objectRelationship.getName(), " can be embedded with \"nestedFields\"."}), objectRelationship.getName(), this._getPropertyType(objectDefinition, objectRelationship), (PropertyValidator)new DefaultPropertyValidator(), false));
        }
        return extendedPropertyDefinitions;
    }

    public void setExtendedProperties(long companyId, long userId, String className, Object entity, Map<String, Serializable> extendedProperties) throws Exception {
        ObjectDefinition objectDefinition = this.fetchObjectDefinition(companyId, className);
        if (objectDefinition == null) {
            throw new IllegalStateException("No object definition exists with class name " + className);
        }
        long primaryKey = this.getPrimaryKey(entity);
        for (Map.Entry<String, Serializable> entry : extendedProperties.entrySet()) {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), entry.getKey());
            ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
            ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(relatedObjectDefinition.getStorageType());
            ObjectRelationshipElementsParser objectRelationshipElementsParser = this._objectRelationshipElementsParserRegistry.getObjectRelationshipElementsParser(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
            List nestedObjectEntries = objectRelationshipElementsParser.parse(objectRelationship, (Object)entry.getValue());
            DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getStorageType()));
            defaultObjectEntryManager.disassociateRelatedModels((DTOConverterContext)this._getDefaultDTOConverterContext(objectDefinition, primaryKey, null), objectDefinition, objectRelationship, primaryKey, relatedObjectDefinition, userId);
            for (ObjectEntry nestedObjectEntry : nestedObjectEntries) {
                nestedObjectEntry = objectEntryManager.updateObjectEntry(objectDefinition.getCompanyId(), (DTOConverterContext)this._getDefaultDTOConverterContext(objectDefinition, primaryKey, null), nestedObjectEntry.getExternalReferenceCode(), relatedObjectDefinition, nestedObjectEntry, relatedObjectDefinition.getScope());
                this._relateNestedObjectEntry(objectDefinition, objectRelationship, primaryKey, nestedObjectEntry.getId());
            }
            NestedFieldsSupplier.addFieldName((String)entry.getKey());
        }
    }

    private DefaultDTOConverterContext _getDefaultDTOConverterContext(ObjectDefinition objectDefinition, Long objectEntryId, UriInfo uriInfo) {
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(false, null, this._dtoConverterRegistry, (Object)objectEntryId, LocaleUtil.fromLanguageId((String)objectDefinition.getDefaultLanguageId(), (boolean)true, (boolean)false), uriInfo, null);
        defaultDTOConverterContext.setAttribute("addActions", (Object)Boolean.FALSE);
        return defaultDTOConverterContext;
    }

    private PropertyDefinition.PropertyType _getPropertyType(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) {
        if (Objects.equals(objectRelationship.getType(), "oneToMany") && objectDefinition.getObjectDefinitionId() == objectRelationship.getObjectDefinitionId2()) {
            return PropertyDefinition.PropertyType.SINGLE_ELEMENT;
        }
        return PropertyDefinition.PropertyType.MULTIPLE_ELEMENT;
    }

    private boolean _isManyToOneObjectRelationship(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, ObjectDefinition relatedObjectDefinition) {
        return Objects.equals(objectRelationship.getType(), "oneToMany") && objectRelationship.getObjectDefinitionId1() == relatedObjectDefinition.getObjectDefinitionId() && objectRelationship.getObjectDefinitionId2() == objectDefinition.getObjectDefinitionId();
    }

    private void _relateNestedObjectEntry(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey, long relatedPrimaryKey) throws Exception {
        long primaryKey1 = relatedPrimaryKey;
        long primaryKey2 = primaryKey;
        if (objectDefinition.getObjectDefinitionId() == objectRelationship.getObjectDefinitionId1()) {
            primaryKey1 = primaryKey;
            primaryKey2 = relatedPrimaryKey;
        }
        this._objectRelationshipService.addObjectRelationshipMappingTableValues(objectRelationship.getObjectRelationshipId(), primaryKey1, primaryKey2, new ServiceContext());
    }
}

