/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.resource.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.internal.security.permission.LiberalPermissionChecker;
import com.liferay.object.rest.resource.v1_0.ObjectEntryResource;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceActionLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.sort.SortParserProvider;
import com.liferay.portal.vulcan.accept.language.AcceptLanguage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.UriInfo;

public class ObjectEntryResourceFactoryImpl
implements ObjectEntryResource.Factory {
    private static final Function<InvocationHandler, ObjectEntryResource> _objectEntryResourceProxyProviderFunction = ObjectEntryResourceFactoryImpl._getProxyProviderFunction();
    private final CompanyLocalService _companyLocalService;
    private final PermissionCheckerFactory _defaultPermissionCheckerFactory;
    private final ExpressionConvert<Filter> _expressionConvert;
    private final FilterParserProvider _filterParserProvider;
    private final GroupLocalService _groupLocalService;
    private final ObjectDefinition _objectDefinition;
    private final Supplier<ObjectEntryResourceImpl> _objectEntryResourceImplSupplier;
    private final ResourceActionLocalService _resourceActionLocalService;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;
    private final RoleLocalService _roleLocalService;
    private final SortParserProvider _sortParserProvider;
    private final UserLocalService _userLocalService;

    public ObjectEntryResourceFactoryImpl(CompanyLocalService companyLocalService, PermissionCheckerFactory defaultPermissionCheckerFactory, ExpressionConvert<Filter> expressionConvert, FilterParserProvider filterParserProvider, GroupLocalService groupLocalService, ObjectDefinition objectDefinition, Supplier<ObjectEntryResourceImpl> objectEntryResourceImplSupplier, ResourceActionLocalService resourceActionLocalService, ResourcePermissionLocalService resourcePermissionLocalService, RoleLocalService roleLocalService, SortParserProvider sortParserProvider, UserLocalService userLocalService) {
        this._companyLocalService = companyLocalService;
        this._defaultPermissionCheckerFactory = defaultPermissionCheckerFactory;
        this._expressionConvert = expressionConvert;
        this._filterParserProvider = filterParserProvider;
        this._groupLocalService = groupLocalService;
        this._objectDefinition = objectDefinition;
        this._objectEntryResourceImplSupplier = objectEntryResourceImplSupplier;
        this._resourceActionLocalService = resourceActionLocalService;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
        this._roleLocalService = roleLocalService;
        this._sortParserProvider = sortParserProvider;
        this._userLocalService = userLocalService;
    }

    public ObjectEntryResource.Builder create() {
        return new ObjectEntryResource.Builder(){
            private boolean _checkPermissions = true;
            private HttpServletRequest _httpServletRequest;
            private HttpServletResponse _httpServletResponse;
            private Locale _preferredLocale;
            private UriInfo _uriInfo;
            private User _user;

            public ObjectEntryResource build() {
                if (this._user == null) {
                    throw new IllegalArgumentException("User is not set");
                }
                return (ObjectEntryResource)_objectEntryResourceProxyProviderFunction.apply((proxy, method, arguments) -> ObjectEntryResourceFactoryImpl.this._invoke(method, arguments, this._checkPermissions, this._httpServletRequest, this._httpServletResponse, this._preferredLocale, this._user));
            }

            public ObjectEntryResource.Builder checkPermissions(boolean checkPermissions) {
                this._checkPermissions = checkPermissions;
                return this;
            }

            public ObjectEntryResource.Builder httpServletRequest(HttpServletRequest httpServletRequest) {
                this._httpServletRequest = httpServletRequest;
                return this;
            }

            public ObjectEntryResource.Builder httpServletResponse(HttpServletResponse httpServletResponse) {
                this._httpServletResponse = httpServletResponse;
                return this;
            }

            public ObjectEntryResource.Builder preferredLocale(Locale preferredLocale) {
                this._preferredLocale = preferredLocale;
                return this;
            }

            public ObjectEntryResource.Builder uriInfo(UriInfo uriInfo) {
                this._uriInfo = uriInfo;
                return this;
            }

            public ObjectEntryResource.Builder user(User user) {
                this._user = user;
                return this;
            }
        };
    }

    private static Function<InvocationHandler, ObjectEntryResource> _getProxyProviderFunction() {
        Class proxyClass = ProxyUtil.getProxyClass((ClassLoader)ObjectEntryResource.class.getClassLoader(), (Class[])new Class[]{ObjectEntryResource.class});
        try {
            Constructor constructor = proxyClass.getConstructor(InvocationHandler.class);
            return invocationHandler -> {
                try {
                    return (ObjectEntryResource)constructor.newInstance(invocationHandler);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new InternalError(reflectiveOperationException);
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InternalError(noSuchMethodException);
        }
    }

    private Object _invoke(Method method, Object[] arguments, boolean checkPermissions, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale preferredLocale, User user) throws Throwable {
        String name = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName((long)user.getUserId());
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (checkPermissions) {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)this._defaultPermissionCheckerFactory.create(user));
        } else {
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)new LiberalPermissionChecker(user));
        }
        ObjectEntryResourceImpl objectEntryResourceImpl = this._objectEntryResourceImplSupplier.get();
        objectEntryResourceImpl.setContextAcceptLanguage(new AcceptLanguageImpl(httpServletRequest, preferredLocale, user));
        objectEntryResourceImpl.setContextCompany(this._companyLocalService.getCompany(user.getCompanyId()));
        objectEntryResourceImpl.setContextHttpServletRequest(httpServletRequest);
        objectEntryResourceImpl.setContextHttpServletResponse(httpServletResponse);
        objectEntryResourceImpl.setContextUser(user);
        objectEntryResourceImpl.setExpressionConvert(this._expressionConvert);
        objectEntryResourceImpl.setFilterParserProvider(this._filterParserProvider);
        objectEntryResourceImpl.setGroupLocalService(this._groupLocalService);
        objectEntryResourceImpl.setObjectDefinition(this._objectDefinition);
        objectEntryResourceImpl.setResourceActionLocalService(this._resourceActionLocalService);
        objectEntryResourceImpl.setResourcePermissionLocalService(this._resourcePermissionLocalService);
        objectEntryResourceImpl.setRoleLocalService(this._roleLocalService);
        objectEntryResourceImpl.setSortParserProvider(this._sortParserProvider);
        try {
            Object object = method.invoke((Object)objectEntryResourceImpl, arguments);
            return object;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
        finally {
            PrincipalThreadLocal.setName((String)name);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
    }

    private class AcceptLanguageImpl
    implements AcceptLanguage {
        private final HttpServletRequest _httpServletRequest;
        private final Locale _preferredLocale;
        private final User _user;

        public AcceptLanguageImpl(HttpServletRequest httpServletRequest, Locale preferredLocale, User user) {
            this._httpServletRequest = httpServletRequest;
            this._preferredLocale = preferredLocale;
            this._user = user;
        }

        public List<Locale> getLocales() {
            return Arrays.asList(this.getPreferredLocale());
        }

        public String getPreferredLanguageId() {
            return LocaleUtil.toLanguageId((Locale)this.getPreferredLocale());
        }

        public Locale getPreferredLocale() {
            Locale locale;
            if (this._preferredLocale != null) {
                return this._preferredLocale;
            }
            if (this._httpServletRequest != null && (locale = (Locale)this._httpServletRequest.getAttribute("LOCALE")) != null) {
                return locale;
            }
            return this._user.getLocale();
        }

        public boolean isAcceptAllLanguages() {
            return false;
        }
    }
}

