/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.openapi.v1_0;

import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.OpenAPIResourceImpl;
import com.liferay.object.rest.internal.vulcan.openapi.contributor.ObjectEntryOpenAPIContributor;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResource;
import com.liferay.object.rest.openapi.v1_0.ObjectEntryOpenAPIResourceProvider;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.TreeMapBuilder;
import com.liferay.portal.vulcan.batch.engine.Field;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.openapi.DTOProperty;
import com.liferay.portal.vulcan.openapi.OpenAPISchemaFilter;
import com.liferay.portal.vulcan.openapi.contributor.OpenAPIContributor;
import com.liferay.portal.vulcan.resource.OpenAPIResource;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.osgi.framework.BundleContext;

public class ObjectEntryOpenAPIResourceImpl
implements ObjectEntryOpenAPIResource {
    private final BundleContext _bundleContext;
    private final DTOConverterRegistry _dtoConverterRegistry;
    private final ObjectActionLocalService _objectActionLocalService;
    private final ObjectDefinition _objectDefinition;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final ObjectEntryOpenAPIResourceProvider _objectEntryOpenAPIResourceProvider;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;
    private final OpenAPIResource _openAPIResource;
    private final Set<String> _readOnlyFieldNames = SetUtil.fromArray((Object[])new String[]{"dateCreated", "dateModified", "id"});
    private final SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;

    public ObjectEntryOpenAPIResourceImpl(BundleContext bundleContext, DTOConverterRegistry dtoConverterRegistry, ObjectActionLocalService objectActionLocalService, ObjectDefinition objectDefinition, ObjectDefinitionLocalService objectDefinitionLocalService, ObjectEntryOpenAPIResourceProvider objectEntryOpenAPIResourceProvider, ObjectFieldLocalService objectFieldLocalService, ObjectRelationshipLocalService objectRelationshipLocalService, OpenAPIResource openAPIResource, SystemObjectDefinitionManagerRegistry systemObjectDefinitionManagerRegistry) {
        this._bundleContext = bundleContext;
        this._dtoConverterRegistry = dtoConverterRegistry;
        this._objectActionLocalService = objectActionLocalService;
        this._objectDefinition = objectDefinition;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._objectEntryOpenAPIResourceProvider = objectEntryOpenAPIResourceProvider;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._openAPIResource = openAPIResource;
        this._systemObjectDefinitionManagerRegistry = systemObjectDefinitionManagerRegistry;
    }

    public Map<String, Field> getFields(UriInfo uriInfo) throws Exception {
        Response response = this.getOpenAPI(null, "json", uriInfo);
        Schema schema = this._getObjectDefinitionSchema((OpenAPI)response.getEntity());
        if (schema == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Field> fields = new HashMap<String, Field>();
        List<String> requiredPropertySchemaNames = this._getRequiredPropertySchemaNames(schema);
        Map properties = schema.getProperties();
        for (Map.Entry schemaEntry : properties.entrySet()) {
            String propertyName = (String)schemaEntry.getKey();
            Schema propertySchema = (Schema)schemaEntry.getValue();
            fields.put(propertyName, Field.of((String)propertySchema.getDescription(), (String)propertyName, (boolean)GetterUtil.getBoolean((Object)propertySchema.getReadOnly()), (String)this._getRef(propertySchema), (boolean)requiredPropertySchemaNames.contains(propertyName), (String)propertySchema.getType(), (boolean)GetterUtil.getBoolean((Object)propertySchema.getWriteOnly())));
        }
        return fields;
    }

    public Response getOpenAPI(HttpServletRequest httpServletRequest, String type, UriInfo uriInfo) throws Exception {
        return this._getOpenAPI(true, type, uriInfo);
    }

    public Map<String, Schema> getSchemas() throws Exception {
        Response response = this._getOpenAPI(false, "json", null);
        OpenAPI openAPI = (OpenAPI)response.getEntity();
        Components components = openAPI.getComponents();
        return components.getSchemas();
    }

    private DTOProperty _getDTOProperty(final ObjectField objectField) {
        if (Objects.equals(objectField.getBusinessType(), "Attachment")) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), FileEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "id", Long.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        if (Objects.equals(objectField.getBusinessType(), "DateTime")) {
            return new DTOProperty(HashMapBuilder.put((Object)"x-parent-map", (Object)"properties").put((Object)"x-timeStorage", (Object)ObjectFieldSettingUtil.getValue((String)"timeStorage", (ObjectField)objectField)).build(), objectField.getName(), objectField.getDBType()){
                {
                    super(x0, x1, x2);
                    this.setRequired(objectField.isRequired());
                }
            };
        }
        if (objectField.getListTypeDefinitionId() != 0L) {
            DTOProperty dtoProperty = new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), ListEntry.class.getSimpleName());
            dtoProperty.setDTOProperties(Arrays.asList(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "key", String.class.getSimpleName()), new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), "name", String.class.getSimpleName())));
            dtoProperty.setRequired(objectField.isRequired());
            return dtoProperty;
        }
        return new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getName(), objectField.getDBType()){
            {
                super(x0, x1, x2);
                this.setRequired(objectField.isRequired());
            }
        };
    }

    private Schema _getObjectDefinitionSchema(OpenAPI openAPI) {
        Components components = openAPI.getComponents();
        Map schemas = components.getSchemas();
        return (Schema)schemas.get(this._objectDefinition.getShortName());
    }

    private Response _getOpenAPI(boolean addRelatedSchemas, String type, UriInfo uriInfo) throws Exception {
        return this._setReadOnly(this._openAPIResource.getOpenAPI((OpenAPIContributor)new ObjectEntryOpenAPIContributor(addRelatedSchemas, this._bundleContext, this._dtoConverterRegistry, this._objectActionLocalService, this._objectDefinition, this._objectDefinitionLocalService, this, this._objectEntryOpenAPIResourceProvider, this._objectRelationshipLocalService, this._openAPIResource, this._systemObjectDefinitionManagerRegistry), this._getOpenAPISchemaFilter(this._objectDefinition), (Set)new HashSet<Class<?>>(){
            {
                this.add(ObjectEntryRelatedObjectsResourceImpl.class);
                this.add(ObjectEntryResourceImpl.class);
                this.add(OpenAPIResourceImpl.class);
            }
        }, type, uriInfo));
    }

    private OpenAPISchemaFilter _getOpenAPISchemaFilter(ObjectDefinition objectDefinition) {
        OpenAPISchemaFilter openAPISchemaFilter = new OpenAPISchemaFilter();
        openAPISchemaFilter.setApplicationPath(objectDefinition.getRESTContextPath());
        DTOProperty dtoProperty = new DTOProperty(new HashMap(), "ObjectEntry", "Object");
        ArrayList<DTOProperty> dtoProperties = new ArrayList<DTOProperty>();
        for (final ObjectField objectField : this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            dtoProperties.add(this._getDTOProperty(objectField));
            if (objectField.isLocalized() && FeatureFlagManagerUtil.isEnabled((String)"LPS-172017")) {
                dtoProperties.add(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectField.getI18nObjectFieldName(), Map.class.getSimpleName()){
                    {
                        super(x0, x1, x2);
                        this.setRequired(objectField.isRequired());
                    }
                });
            }
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) continue;
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
            dtoProperties.add(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), objectRelationship.getName(), String.class.getSimpleName()){
                {
                    super(x0, x1, x2);
                    this.setRequired(objectField.isRequired());
                }
            });
            dtoProperties.add(new DTOProperty(Collections.singletonMap("x-parent-map", "properties"), ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField), String.class.getSimpleName()){
                {
                    super(x0, x1, x2);
                    this.setRequired(objectField.isRequired());
                }
            });
        }
        dtoProperty.setDTOProperties(dtoProperties);
        DTOProperty pageDTOProperty = new DTOProperty(new HashMap(), "PageObject", "Object");
        pageDTOProperty.setDTOProperties(Arrays.asList(new DTOProperty(new HashMap(), "items", "Array"){
            {
                this.setDTOProperties(Arrays.asList(new DTOProperty(new HashMap(), "ObjectEntry", "Object")));
            }
        }));
        openAPISchemaFilter.setDTOProperties(Arrays.asList(dtoProperty, pageDTOProperty));
        openAPISchemaFilter.setSchemaMappings((Map)TreeMapBuilder.create(Collections.reverseOrder()).put((Object)"ObjectEntry", (Object)objectDefinition.getShortName()).put((Object)"PageObject", (Object)("Page" + objectDefinition.getShortName())).put((Object)"PageObjectEntry", (Object)("Page" + objectDefinition.getShortName())).build());
        return openAPISchemaFilter;
    }

    private String _getRef(Schema schema) {
        if (schema instanceof ArraySchema) {
            Schema itemsSchema = ((ArraySchema)schema).getItems();
            return itemsSchema.get$ref();
        }
        return schema.get$ref();
    }

    private List<String> _getRequiredPropertySchemaNames(Schema schema) {
        List<String> requiredPropertySchemaNames = schema.getRequired();
        if (requiredPropertySchemaNames == null) {
            requiredPropertySchemaNames = Collections.emptyList();
        }
        return requiredPropertySchemaNames;
    }

    private Response _setReadOnly(Response response) {
        Map objectFields = ObjectFieldUtil.toObjectFieldsMap((List)this._objectFieldLocalService.getObjectFields(this._objectDefinition.getObjectDefinitionId()));
        Schema schema = this._getObjectDefinitionSchema((OpenAPI)response.getEntity());
        Map properties = schema.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            schema = (Schema)entry.getValue();
            if (this._readOnlyFieldNames.contains(key)) {
                schema.readOnly(Boolean.valueOf(true));
                continue;
            }
            ObjectField objectField = (ObjectField)objectFields.get(key);
            if (objectField == null) continue;
            if (Objects.equals(objectField.getReadOnly(), "conditional") || Objects.equals(objectField.getReadOnly(), "false")) {
                schema.readOnly(Boolean.valueOf(false));
                continue;
            }
            schema.readOnly(Boolean.valueOf(true));
        }
        return response;
    }
}

