/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.odata.filter.expression;

import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.odata.filter.expression.field.predicate.provider.FieldPredicateProvider;
import com.liferay.object.related.models.ObjectRelatedModelsPredicateProvider;
import com.liferay.object.related.models.ObjectRelatedModelsPredicateProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.internal.odata.filter.expression.field.predicate.provider.FieldPredicateProviderTracker;
import com.liferay.object.rest.internal.util.BinaryExpressionConverterUtil;
import com.liferay.object.rest.odata.entity.v1_0.provider.EntityModelProvider;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalServiceUtil;
import com.liferay.petra.function.UnsafeBiFunction;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.InvalidFilterException;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.ServerErrorException;

public class PredicateExpressionVisitorImpl
implements ExpressionVisitor<Object> {
    private static final Log _log = LogFactoryUtil.getLog(PredicateExpressionVisitorImpl.class);
    private EntityModelProvider _entityModelProvider;
    private final Map<Long, EntityModel> _entityModels = new HashMap<Long, EntityModel>();
    private FieldPredicateProviderTracker _fieldPredicateProviderTracker;
    private final Map<String, String> _lambdaVariableExpressionFieldNames;
    private final ObjectDefinition _objectDefinition;
    private final ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    private final ObjectFieldLocalService _objectFieldLocalService;
    private final ObjectRelatedModelsPredicateProviderRegistry _objectRelatedModelsPredicateProviderRegistry;

    public PredicateExpressionVisitorImpl(EntityModel entityModel, EntityModelProvider entityModelProvider, FieldPredicateProviderTracker fieldPredicateProviderTracker, ObjectDefinition objectDefinition, ObjectFieldBusinessTypeRegistry objectFieldBusinessTypeRegistry, ObjectFieldLocalService objectFieldLocalService, ObjectRelatedModelsPredicateProviderRegistry objectRelatedModelsPredicateProviderRegistry) {
        this(entityModel, entityModelProvider, fieldPredicateProviderTracker, new HashMap<String, String>(), objectDefinition, objectFieldBusinessTypeRegistry, objectFieldLocalService, objectRelatedModelsPredicateProviderRegistry);
    }

    public Predicate visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Predicate predicate = null;
        predicate = this._isComplexProperExpression(left) ? this._getObjectRelationshipPredicate(left, (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._getPredicate(objectFieldName, (ObjectDefinition)relatedObjectDefinition, operation, right))) : this._getPredicate(left, this._objectDefinition, operation, right);
        if (predicate != null) {
            return predicate;
        }
        throw new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation);
    }

    public Predicate visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        return this._visitCollectionPropertyExpression(collectionPropertyExpression, this._objectDefinition);
    }

    public Object visitComplexPropertyExpression(final ComplexPropertyExpression complexPropertyExpression) throws ExpressionVisitException {
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        if (propertyExpression instanceof CollectionPropertyExpression) {
            return this._getObjectRelationshipPredicate(complexPropertyExpression.toString(), (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._visitCollectionPropertyExpression((CollectionPropertyExpression)propertyExpression, (ObjectDefinition)relatedObjectDefinition)));
        }
        if (propertyExpression instanceof ComplexPropertyExpression) {
            return this._handleComplexPropertyExpression(propertyExpression, (List<String>)new ArrayList<String>(){
                {
                    this.add(complexPropertyExpression.getName());
                }
            });
        }
        return complexPropertyExpression.toString();
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variableName, Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) {
        return this._lambdaVariableExpressionFieldNames.get(lambdaVariableExpression.getVariableName());
    }

    public Predicate visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> rights) throws ExpressionVisitException {
        if (Objects.equals(ListExpression.Operation.IN, operation)) {
            Predicate predicate = null;
            predicate = this._isComplexProperExpression(left) ? this._getObjectRelationshipPredicate(left, (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._getInPredicate(objectFieldName, (ObjectDefinition)relatedObjectDefinition, rights))) : this._getInPredicate(left, this._objectDefinition, rights);
            return predicate;
        }
        throw new UnsupportedOperationException("Unsupported method visitListExpressionOperation with operation " + operation);
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return GetterUtil.getBoolean((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType())) {
            return GetterUtil.getDate((String)literalExpression.getText(), (DateFormat)DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd"));
        }
        if (Objects.equals(LiteralExpression.Type.DOUBLE, literalExpression.getType())) {
            return GetterUtil.getDouble((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.INTEGER, literalExpression.getType())) {
            return GetterUtil.getLong((String)literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.NULL, literalExpression.getType())) {
            return null;
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return StringUtil.replace((String)StringUtil.unquote((String)literalExpression.getText()), (String)"''", (String)"'");
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (expressions.size() == 2) {
            String left = (String)expressions.get(0);
            Object fieldValue = expressions.get(1);
            Predicate predicate = null;
            if (type == MethodExpression.Type.CONTAINS ? (predicate = this._isComplexProperExpression(left) ? this._getObjectRelationshipPredicate(left, (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._contains(objectFieldName, fieldValue, (ObjectDefinition)relatedObjectDefinition))) : this._contains(left, fieldValue, this._objectDefinition)) != null : type == MethodExpression.Type.STARTS_WITH && (predicate = this._isComplexProperExpression(left) ? this._getObjectRelationshipPredicate(left, (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._startsWith(objectFieldName, fieldValue, (ObjectDefinition)relatedObjectDefinition))) : this._startsWith(left, fieldValue, this._objectDefinition)) != null) {
                return predicate;
            }
        }
        throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method type ", type, " and ", expressions.size(), " parameters"}));
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        return primitivePropertyExpression.getName();
    }

    public Predicate visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (!Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
        }
        DefaultPredicate defaultPredicate = (DefaultPredicate)operand;
        if (Objects.equals(Operand.IN, defaultPredicate.getOperand())) {
            return new DefaultPredicate(defaultPredicate.getLeftExpression(), Operand.NOT_IN, defaultPredicate.getRightExpression());
        }
        return Predicate.not((Predicate)defaultPredicate);
    }

    private PredicateExpressionVisitorImpl(EntityModel entityModel, EntityModelProvider entityModelProvider, FieldPredicateProviderTracker fieldPredicateProviderTracker, Map<String, String> lambdaVariableExpressionFieldNames, ObjectDefinition objectDefinition, ObjectFieldBusinessTypeRegistry objectFieldBusinessTypeRegistry, ObjectFieldLocalService objectFieldLocalService, ObjectRelatedModelsPredicateProviderRegistry objectRelatedModelsPredicateProviderRegistry) {
        this._entityModels.put(objectDefinition.getObjectDefinitionId(), entityModel);
        this._entityModelProvider = entityModelProvider;
        this._fieldPredicateProviderTracker = fieldPredicateProviderTracker;
        this._lambdaVariableExpressionFieldNames = lambdaVariableExpressionFieldNames;
        this._objectDefinition = objectDefinition;
        this._objectFieldBusinessTypeRegistry = objectFieldBusinessTypeRegistry;
        this._objectFieldLocalService = objectFieldLocalService;
        this._objectRelatedModelsPredicateProviderRegistry = objectRelatedModelsPredicateProviderRegistry;
    }

    private Predicate _contains(Column<?, ?> column, Object value) {
        return column.like("%" + value + "%");
    }

    private Predicate _contains(Object fieldName, Object fieldValue, ObjectDefinition objectDefinition) {
        FieldPredicateProvider fieldPredicateProvider = this._fieldPredicateProviderTracker.getFieldPredicateProvider(String.valueOf(fieldName));
        if (fieldPredicateProvider != null) {
            return fieldPredicateProvider.getContainsPredicate(name -> this._getColumn(name, objectDefinition), fieldValue);
        }
        return this._contains(this._getColumn(fieldName, objectDefinition), this._getValue(fieldName, objectDefinition, fieldValue));
    }

    private ObjectRelationship _fetchObjectRelationship(ObjectDefinition objectDefinition, String objectRelationshipName) {
        try {
            return ObjectRelationshipLocalServiceUtil.getObjectRelationshipByObjectDefinitionId((long)objectDefinition.getObjectDefinitionId(), (String)objectRelationshipName);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }

    private Column<?, Object> _getColumn(Object fieldName, ObjectDefinition objectDefinition) {
        EntityField entityField = this._getEntityField(fieldName, objectDefinition);
        return this._objectFieldLocalService.getColumn(objectDefinition.getObjectDefinitionId(), entityField.getFilterableName(null));
    }

    private EntityField _getEntityField(Object fieldName, ObjectDefinition objectDefinition) {
        Map<String, EntityField> entityFieldsMap = this._getEntityFieldsMap(objectDefinition);
        return entityFieldsMap.get(GetterUtil.getString((Object)fieldName));
    }

    private Map<String, EntityField> _getEntityFieldsMap(ObjectDefinition objectDefinition) {
        EntityModel entityModel = this._getObjectDefinitionEntityModel(objectDefinition);
        return entityModel.getEntityFieldsMap();
    }

    private Predicate _getInPredicate(Object left, ObjectDefinition objectDefinition, List<Object> rights) {
        FieldPredicateProvider fieldPredicateProvider = this._fieldPredicateProviderTracker.getFieldPredicateProvider(String.valueOf(left));
        if (fieldPredicateProvider != null) {
            return fieldPredicateProvider.getInPredicate(name -> this._getColumn(name, objectDefinition), rights);
        }
        return this._getColumn(left, objectDefinition).in(TransformUtil.transformToArray(rights, right -> this._getValue(left, objectDefinition, right), Object.class));
    }

    private EntityModel _getObjectDefinitionEntityModel(ObjectDefinition objectDefinition) {
        EntityModel entityModel = this._entityModels.get(objectDefinition.getObjectDefinitionId());
        if (entityModel == null) {
            entityModel = this._entityModelProvider.getEntityModel(objectDefinition);
            this._entityModels.put(objectDefinition.getObjectDefinitionId(), entityModel);
        }
        return entityModel;
    }

    private Predicate _getObjectRelationshipPredicate(Object left, UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception> unsafeBiFunction) {
        List leftParts = ListUtil.fromString((String)((String)left), (String)"/");
        ArrayList<String> objectRelationshipNames = new ArrayList<String>(leftParts.subList(0, leftParts.size() - 1));
        List<ObjectValuePair<ObjectRelationship, ObjectDefinition>> objectValuePairs = this._getObjectValuePairs(this._objectDefinition, objectRelationshipNames);
        ObjectValuePair<ObjectRelationship, ObjectDefinition> objectValuePair = objectValuePairs.remove(0);
        try {
            return this._getObjectRelationshipPredicate((ObjectDefinition)objectValuePair.getValue(), objectValuePairs, (ObjectRelationship)objectValuePair.getKey(), (Predicate)unsafeBiFunction.apply(leftParts.get(leftParts.size() - 1), (Object)ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)((ObjectDefinition)objectValuePair.getValue()), (ObjectRelationship)((ObjectRelationship)objectValuePair.getKey()))));
        }
        catch (InvalidFilterException invalidFilterException) {
            throw invalidFilterException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private Predicate _getObjectRelationshipPredicate(ObjectDefinition objectDefinition, List<ObjectValuePair<ObjectRelationship, ObjectDefinition>> objectValuePairs, ObjectRelationship objectRelationship, Predicate predicate) throws Exception {
        ObjectRelatedModelsPredicateProvider objectRelatedModelsPredicateProvider = this._objectRelatedModelsPredicateProviderRegistry.getObjectRelatedModelsPredicateProvider(objectDefinition.getClassName(), objectRelationship.getType());
        if (objectValuePairs.isEmpty()) {
            return objectRelatedModelsPredicateProvider.getPredicate(objectRelationship, predicate);
        }
        ObjectValuePair<ObjectRelationship, ObjectDefinition> objectValuePair = objectValuePairs.remove(0);
        return this._getObjectRelationshipPredicate((ObjectDefinition)objectValuePair.getValue(), objectValuePairs, (ObjectRelationship)objectValuePair.getKey(), objectRelatedModelsPredicateProvider.getPredicate(objectRelationship, predicate));
    }

    private List<ObjectValuePair<ObjectRelationship, ObjectDefinition>> _getObjectValuePairs(ObjectDefinition objectDefinition, List<String> objectRelationshipNames) {
        ArrayList<ObjectValuePair<ObjectRelationship, ObjectDefinition>> objectValuePairs = new ArrayList<ObjectValuePair<ObjectRelationship, ObjectDefinition>>();
        for (String objectRelationshipName : objectRelationshipNames) {
            ObjectRelationship objectRelationship = this._fetchObjectRelationship(objectDefinition, objectRelationshipName);
            if (objectRelationship == null) continue;
            objectValuePairs.add((ObjectValuePair<ObjectRelationship, ObjectDefinition>)new ObjectValuePair((Object)objectRelationship, (Object)objectDefinition));
            objectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
        }
        if (objectValuePairs.isEmpty()) {
            throw new ServerErrorException(500, (Throwable)new Exception(StringBundler.concat((Object[])new Object[]{"Unable to get object value pairs for object ", "definition ", objectDefinition.getObjectDefinitionId(), " and object relationship: ", StringUtil.merge(objectRelationshipNames)})));
        }
        Collections.reverse(objectValuePairs);
        return objectValuePairs;
    }

    private Predicate _getPredicate(Object left, ObjectDefinition objectDefinition, BinaryExpression.Operation operation, Object right) {
        Predicate predicate = null;
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            predicate = Predicate.and((Predicate)Predicate.withParentheses((Predicate)((Predicate)left)), (Predicate)Predicate.withParentheses((Predicate)((Predicate)right)));
        } else if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            predicate = Predicate.or((Predicate)Predicate.withParentheses((Predicate)((Predicate)left)), (Predicate)Predicate.withParentheses((Predicate)((Predicate)right)));
        } else {
            ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getObjectDefinitionId(), String.valueOf(left));
            if (objectField == null) {
                FieldPredicateProvider fieldPredicateProvider = this._fieldPredicateProviderTracker.getFieldPredicateProvider(String.valueOf(left));
                if (fieldPredicateProvider != null) {
                    predicate = fieldPredicateProvider.getBinaryExpressionPredicate(name -> this._getColumn(name, objectDefinition), left, objectDefinition.getObjectDefinitionId(), operation, right);
                }
            } else if (StringUtil.equals((String)objectField.getBusinessType(), (String)"MultiselectPicklist")) {
                predicate = this._contains(left, right, objectDefinition);
            }
        }
        if (predicate != null) {
            return predicate;
        }
        return BinaryExpressionConverterUtil.getExpressionPredicate(this._getColumn(left, objectDefinition), operation, this._getValue(left, objectDefinition, right));
    }

    private Object _getValue(Object left, ObjectDefinition objectDefinition, Object right) {
        EntityField entityField = this._getEntityField(left, objectDefinition);
        EntityField.Type entityType = entityField.getType();
        DB db = DBManagerUtil.getDB();
        if (entityType.equals((Object)EntityField.Type.DATE_TIME) && db.getDBType() == DBType.HYPERSONIC) {
            try {
                Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"dd-MMM-yyyy HH:mm:ss.SSS");
                DateFormat dateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss");
                Date date = dateFormat.parse(right.toString());
                right = format.format(date);
            }
            catch (ParseException parseException) {
                throw new RuntimeException(parseException);
            }
        }
        String entityFieldFilterableName = entityField.getFilterableName(null);
        String entityFieldName = entityField.getName();
        try {
            ObjectField objectField = this._objectFieldLocalService.getObjectField(this._objectDefinition.getObjectDefinitionId(), entityFieldFilterableName);
            ObjectFieldBusinessType objectFieldBusinessType = this._objectFieldBusinessTypeRegistry.getObjectFieldBusinessType(objectField.getBusinessType());
            Object value = objectFieldBusinessType.getValue(objectField, PrincipalThreadLocal.getUserId(), Collections.singletonMap(entityFieldName, right));
            if (value == null) {
                return right;
            }
            if (Objects.equals(objectFieldBusinessType.getDBType(), "Long") && Validator.isNumber((String)String.valueOf(value))) {
                return GetterUtil.getLong((Object)value);
            }
            return value;
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return right;
        }
    }

    private Object _handleComplexPropertyExpression(PropertyExpression propertyExpression, List<String> relationshipsNames) {
        if (propertyExpression instanceof CollectionPropertyExpression) {
            relationshipsNames.add(propertyExpression.toString());
            return this._getObjectRelationshipPredicate(StringUtil.merge(relationshipsNames, (String)"/"), (UnsafeBiFunction<String, ObjectDefinition, Predicate, Exception>)((UnsafeBiFunction)(objectFieldName, relatedObjectDefinition) -> this._visitCollectionPropertyExpression((CollectionPropertyExpression)propertyExpression, (ObjectDefinition)relatedObjectDefinition)));
        }
        if (propertyExpression instanceof ComplexPropertyExpression) {
            ComplexPropertyExpression complexPropertyExpression = (ComplexPropertyExpression)propertyExpression;
            relationshipsNames.add(propertyExpression.getName());
            return this._handleComplexPropertyExpression(complexPropertyExpression.getPropertyExpression(), relationshipsNames);
        }
        relationshipsNames.add(propertyExpression.toString());
        return StringUtil.merge(relationshipsNames, (String)"/");
    }

    private boolean _isComplexProperExpression(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.contains("/");
        }
        return false;
    }

    private Predicate _startsWith(Column<?, ?> column, Object value) {
        return column.like(value + "%");
    }

    private Predicate _startsWith(Object fieldName, Object fieldValue, ObjectDefinition objectDefinition) {
        FieldPredicateProvider fieldPredicateProvider = this._fieldPredicateProviderTracker.getFieldPredicateProvider(String.valueOf(fieldName));
        if (fieldPredicateProvider != null) {
            return fieldPredicateProvider.getStartsWithPredicate(name -> this._getColumn(name, objectDefinition), fieldValue);
        }
        return this._startsWith(this._getColumn(fieldName, objectDefinition), this._getValue(fieldName, objectDefinition, fieldValue));
    }

    private Predicate _visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression, ObjectDefinition objectDefinition) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        return (Predicate)lambdaFunctionExpression.accept((ExpressionVisitor)new PredicateExpressionVisitorImpl(this._getObjectDefinitionEntityModel(objectDefinition), this._entityModelProvider, this._fieldPredicateProviderTracker, Collections.singletonMap(lambdaFunctionExpression.getVariableName(), collectionPropertyExpression.getName()), objectDefinition, this._objectFieldBusinessTypeRegistry, this._objectFieldLocalService, this._objectRelatedModelsPredicateProviderRegistry));
    }
}

