/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.odata.entity.v1_0;

import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.service.ObjectFieldLocalServiceUtil;
import com.liferay.object.service.ObjectRelationshipLocalServiceUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.odata.entity.BooleanEntityField;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.DateEntityField;
import com.liferay.portal.odata.entity.DateTimeEntityField;
import com.liferay.portal.odata.entity.DoubleEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.IdEntityField;
import com.liferay.portal.odata.entity.IntegerEntityField;
import com.liferay.portal.odata.entity.StringEntityField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.BadRequestException;

public class ObjectEntryEntityModel
implements EntityModel {
    private final Map<String, EntityField> _entityFieldsMap;
    private final List<Long> _handledObjectDefinitions = new ArrayList<Long>();
    private final Set<String> _unsupportedBusinessTypes = SetUtil.fromArray((Object[])new String[]{"Aggregation", "Attachment", "Formula", "RichText"});

    public ObjectEntryEntityModel(ObjectDefinition objectDefinition, List<ObjectField> objectFields) throws Exception {
        this._entityFieldsMap = this._getStringEntityFieldsMap(objectFields);
        List objectRelationships = ObjectRelationshipLocalServiceUtil.getAllObjectRelationships((long)objectDefinition.getObjectDefinitionId());
        for (ObjectRelationship objectRelationship : objectRelationships) {
            this._entityFieldsMap.put(objectRelationship.getName(), (EntityField)new ComplexEntityField(objectRelationship.getName(), this._getRelatedObjectDefinitionEntityFields(objectRelationship, objectDefinition)));
            this._handledObjectDefinitions.clear();
        }
    }

    public Map<String, EntityField> getEntityFieldsMap() {
        return this._entityFieldsMap;
    }

    private EntityField _getEntityField(ObjectField objectField) {
        if (this._unsupportedBusinessTypes.contains(objectField.getBusinessType())) {
            return null;
        }
        if (Objects.equals(objectField.getBusinessType(), "DateTime")) {
            return new DateTimeEntityField(objectField.getName(), locale -> objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getBusinessType(), "MultiselectPicklist")) {
            return new CollectionEntityField((EntityField)new StringEntityField(objectField.getName(), locale -> objectField.getName()));
        }
        if (Objects.equals(objectField.getDBType(), "BigDecimal") || Objects.equals(objectField.getDBType(), "Double")) {
            return new DoubleEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Boolean")) {
            return new BooleanEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Clob") || Objects.equals(objectField.getDBType(), "String")) {
            return new StringEntityField(objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Date")) {
            return new DateEntityField(objectField.getName(), locale -> objectField.getName(), locale -> objectField.getName());
        }
        if (Objects.equals(objectField.getDBType(), "Integer") || Objects.equals(objectField.getDBType(), "Long")) {
            return new IntegerEntityField(objectField.getName(), locale -> objectField.getName());
        }
        throw new BadRequestException("Unable to get entity field for bject field " + objectField);
    }

    private List<EntityField> _getRelatedObjectDefinitionEntityFields(ObjectRelationship objectRelationship, ObjectDefinition objectDefinition) throws Exception {
        this._handledObjectDefinitions.add(objectDefinition.getObjectDefinitionId());
        ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
        Map<String, EntityField> relatedObjectDefinitionEntityFieldsMap = this._getStringEntityFieldsMap(ObjectFieldLocalServiceUtil.getObjectFields((long)relatedObjectDefinition.getObjectDefinitionId()));
        ArrayList<EntityField> relatedObjectDefinitionEntityFields = new ArrayList<EntityField>(relatedObjectDefinitionEntityFieldsMap.values());
        if (this._handledObjectDefinitions.contains(relatedObjectDefinition.getObjectDefinitionId())) {
            this._handledObjectDefinitions.remove(objectDefinition.getObjectDefinitionId());
            return relatedObjectDefinitionEntityFields;
        }
        List relatedObjectDefinitionObjectRelationships = ObjectRelationshipLocalServiceUtil.getAllObjectRelationships((long)relatedObjectDefinition.getObjectDefinitionId());
        for (ObjectRelationship relatedObjectRelationship : relatedObjectDefinitionObjectRelationships) {
            if (relatedObjectRelationship.getObjectRelationshipId() == objectRelationship.getObjectRelationshipId() || this._isHandledObjectDefinition(relatedObjectDefinition, relatedObjectRelationship)) continue;
            relatedObjectDefinitionEntityFields.add((EntityField)new ComplexEntityField(relatedObjectRelationship.getName(), new ArrayList<EntityField>(this._getRelatedObjectDefinitionEntityFields(relatedObjectRelationship, relatedObjectDefinition))));
        }
        return relatedObjectDefinitionEntityFields;
    }

    private Map<String, EntityField> _getStringEntityFieldsMap(List<ObjectField> objectFields) {
        HashMap entityFieldsMap = HashMapBuilder.put((Object)"creator", (Object)new StringEntityField("creator", locale -> "creator")).put((Object)"creatorId", (Object)new IntegerEntityField("creatorId", locale -> "userId")).put((Object)"dateCreated", (Object)new DateTimeEntityField("dateCreated", locale -> "createDate", locale -> "createDate")).put((Object)"dateModified", (Object)new DateTimeEntityField("dateModified", locale -> "modifiedDate", locale -> "modifiedDate")).put((Object)"externalReferenceCode", () -> new StringEntityField("externalReferenceCode", locale -> "externalReferenceCode")).put((Object)"id", (Object)new IdEntityField("id", locale -> "id", String::valueOf)).put((Object)"keywords", (Object)new CollectionEntityField((EntityField)new StringEntityField("keywords", locale -> "assetTagNames.raw"))).put((Object)"objectDefinitionId", (Object)new IntegerEntityField("objectDefinitionId", locale -> "objectDefinitionId")).put((Object)"siteId", (Object)new IntegerEntityField("siteId", locale -> "groupId")).put((Object)"status", (Object)new CollectionEntityField((EntityField)new IntegerEntityField("status", locale -> "status"))).put((Object)"taxonomyCategoryIds", (Object)new CollectionEntityField((EntityField)new IntegerEntityField("taxonomyCategoryIds", locale -> "assetCategoryIds"))).put((Object)"userId", (Object)new IntegerEntityField("userId", locale -> "userId")).build();
        for (ObjectField objectField : objectFields) {
            if (objectField.isSystem()) continue;
            if (!Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                EntityField entityField = this._getEntityField(objectField);
                if (entityField == null) continue;
                entityFieldsMap.putIfAbsent(objectField.getName(), entityField);
                continue;
            }
            String objectFieldName = objectField.getName();
            entityFieldsMap.put(objectFieldName, new IdEntityField(objectFieldName, locale -> objectFieldName, String::valueOf));
            String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
            entityFieldsMap.put(objectRelationshipERCObjectFieldName, new StringEntityField(objectRelationshipERCObjectFieldName, locale -> objectFieldName));
            String relationshipIdName = objectFieldName.substring(objectFieldName.lastIndexOf("_") + 1);
            entityFieldsMap.put(relationshipIdName, new IdEntityField(relationshipIdName, locale -> objectFieldName, String::valueOf));
        }
        return entityFieldsMap;
    }

    private boolean _isHandledObjectDefinition(ObjectDefinition relatedObjectDefinition, ObjectRelationship relatedObjectRelationship) throws Exception {
        ObjectDefinition objectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)relatedObjectDefinition, (ObjectRelationship)relatedObjectRelationship);
        return this._handledObjectDefinitions.contains(objectDefinition.getObjectDefinitionId());
    }
}

