/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.manager.v1_0;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.internal.configuration.FunctionObjectEntryManagerConfiguration;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.scope.CompanyScoped;
import com.liferay.osgi.util.configuration.ConfigurationFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.catapult.PortalCatapult;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.object.rest.internal.configuration.FunctionObjectEntryManagerConfiguration"}, factory="com.liferay.object.rest.internal.manager.v1_0.FunctionObjectEntryManagerImpl", service={ObjectEntryManager.class})
public class FunctionObjectEntryManagerImpl
extends BaseObjectEntryManager
implements CompanyScoped,
ObjectEntryManager {
    private long _companyId;
    @Reference
    private CompanyLocalService _companyLocalService;
    private FunctionObjectEntryManagerConfiguration _functionObjectEntryManagerConfiguration;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private PortalCatapult _portalCatapult;
    private String _storageLabel;
    private String _storageType;

    public ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("ADD_OBJECT_ENTRY", objectDefinition, scopeKey, dtoConverterContext.getUser());
        return this._toObjectEntry(this._launch(Http.Method.POST, this._toJSONObject(dtoConverterContext, scopeKey).put("objectEntry", this._toJSONObject(objectEntry)), StringBundler.concat((String[])new String[]{this._functionObjectEntryManagerConfiguration.resourcePath(), "/", HttpComponentsUtil.encodePath((String)objectDefinition.getExternalReferenceCode())}), dtoConverterContext.getUserId()), objectDefinition, scopeKey, dtoConverterContext.getUser());
    }

    public void deleteObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("DELETE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        String resourcePath = StringBundler.concat((String[])new String[]{this._functionObjectEntryManagerConfiguration.resourcePath(), "/", HttpComponentsUtil.encodePath((String)objectDefinition.getExternalReferenceCode()), "/", externalReferenceCode});
        this._launch(Http.Method.DELETE, null, this._appendBaseParameters(dtoConverterContext, resourcePath, scopeKey), dtoConverterContext.getUserId());
    }

    public long getAllowedCompanyId() {
        return this._companyId;
    }

    public Page<ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        String resourcePath = StringBundler.concat((String[])new String[]{this._functionObjectEntryManagerConfiguration.resourcePath(), "/", HttpComponentsUtil.encodePath((String)objectDefinition.getExternalReferenceCode())});
        resourcePath = this._appendBaseParameters(dtoConverterContext, resourcePath, scopeKey);
        resourcePath = this._appendCollectionParameters(filterString, pagination, resourcePath, search, sorts);
        return this._toObjectEntries(this._launch(Http.Method.GET, null, resourcePath, dtoConverterContext.getUserId()), objectDefinition, pagination, scopeKey, dtoConverterContext.getUser());
    }

    public ObjectEntry getObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("VIEW", objectDefinition, scopeKey, dtoConverterContext.getUser());
        if (Validator.isNull((String)externalReferenceCode)) {
            return null;
        }
        String resourcePath = StringBundler.concat((String[])new String[]{this._functionObjectEntryManagerConfiguration.resourcePath(), "/", HttpComponentsUtil.encodePath((String)objectDefinition.getExternalReferenceCode()), "/", externalReferenceCode});
        return this._toObjectEntry(this._launch(Http.Method.GET, null, this._appendBaseParameters(dtoConverterContext, resourcePath, scopeKey), dtoConverterContext.getUserId()), objectDefinition, scopeKey, dtoConverterContext.getUser());
    }

    public String getStorageLabel(Locale locale) {
        return this._storageLabel;
    }

    public String getStorageType() {
        return this._storageType;
    }

    public ObjectEntry updateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.checkPortletResourcePermission("UPDATE", objectDefinition, scopeKey, dtoConverterContext.getUser());
        return this._toObjectEntry(this._launch(Http.Method.PUT, this._toJSONObject(dtoConverterContext, scopeKey).put("objectEntry", this._toJSONObject(objectEntry)), StringBundler.concat((String[])new String[]{this._functionObjectEntryManagerConfiguration.resourcePath(), "/", HttpComponentsUtil.encodePath((String)objectDefinition.getExternalReferenceCode()), "/", externalReferenceCode}), dtoConverterContext.getUserId()), objectDefinition, scopeKey, dtoConverterContext.getUser());
    }

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        this._companyId = ConfigurationFactoryUtil.getCompanyId((CompanyLocalService)this._companyLocalService, properties);
        this._functionObjectEntryManagerConfiguration = (FunctionObjectEntryManagerConfiguration)ConfigurableUtil.createConfigurable(FunctionObjectEntryManagerConfiguration.class, properties);
        this._storageLabel = GetterUtil.getString((Object)properties.get("name"));
        this._storageType = GetterUtil.getString((Object)properties.get("storage.type"));
    }

    private String _appendBaseParameters(DTOConverterContext dtoConverterContext, String resourcePath, String scopeKey) {
        resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"companyId", (long)this._companyId);
        resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"languageId", (String)LocaleUtil.toLanguageId((Locale)dtoConverterContext.getLocale()));
        resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"scopeKey", (String)scopeKey);
        resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"userId", (long)dtoConverterContext.getUserId());
        return resourcePath;
    }

    private String _appendCollectionParameters(String filterString, Pagination pagination, String resourcePath, String search, Sort[] sorts) {
        if (Validator.isNotNull((String)filterString)) {
            resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"filter", (String)filterString);
        }
        if (pagination != null) {
            resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"page", (int)pagination.getPage());
            resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"pageSize", (int)pagination.getPageSize());
        }
        if (search != null) {
            resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"search", (String)search);
        }
        if (ArrayUtil.isNotEmpty((Object[])sorts)) {
            StringBundler sb = new StringBundler(sorts.length * 3);
            for (int i = 0; i < sorts.length; ++i) {
                Sort sort = sorts[i];
                sb.append(sort.getFieldName());
                sb.append(":");
                if (sort.isReverse()) {
                    sb.append("desc");
                } else {
                    sb.append("asc");
                }
                if (i == sorts.length - 1) continue;
                sb.append(",");
            }
            resourcePath = HttpComponentsUtil.addParameter((String)resourcePath, (String)"sort", (String)sb.toString());
        }
        return resourcePath;
    }

    private byte[] _launch(Http.Method method, JSONObject payloadJSONObject, String resourcePath, long userId) throws Exception {
        return this._portalCatapult.launch(this._companyId, method, this._functionObjectEntryManagerConfiguration.oAuth2ApplicationExternalReferenceCode(), payloadJSONObject, resourcePath, userId);
    }

    private JSONObject _toJSONObject(DTOConverterContext dtoConverterContext, String scopeKey) throws Exception {
        return this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize((Object)HashMapBuilder.put((Object)"companyId", (Object)this._companyId).put((Object)"languageId", (Object)LocaleUtil.toLanguageId((Locale)dtoConverterContext.getLocale())).put((Object)"scopeKey", (Object)scopeKey).put((Object)"userId", (Object)dtoConverterContext.getUserId()).build()));
    }

    private JSONObject _toJSONObject(ObjectEntry objectEntry) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerialize((Object)objectEntry));
        jsonObject = this._jsonFactory.createJSONObject((Map)HashMapBuilder.put((Object)"creator", (Object)jsonObject.get("creator")).put((Object)"dateCreated", jsonObject.get("dateCreated")).put((Object)"dateModified", jsonObject.get("dateModified")).put((Object)"externalReferenceCode", jsonObject.get("externalReferenceCode")).put((Object)"status", jsonObject.get("status")).build());
        Map properties = objectEntry.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            jsonObject.put((String)entry.getKey(), entry.getValue());
        }
        return jsonObject;
    }

    private Page<ObjectEntry> _toObjectEntries(byte[] bytes, ObjectDefinition objectDefinition, Pagination pagination, String scopeKey, User user) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(new String(bytes));
        return Page.of((Collection)JSONUtil.toList((JSONArray)((JSONArray)jsonObject.get("items")), itemJSONObject -> this._toObjectEntry(itemJSONObject.toString(), objectDefinition, scopeKey, user)), (Pagination)pagination, (long)((Integer)jsonObject.get("totalCount")).intValue());
    }

    private ObjectEntry _toObjectEntry(byte[] bytes, ObjectDefinition objectDefinition, String scopeKey, User user) {
        return this._toObjectEntry(new String(bytes), objectDefinition, scopeKey, user);
    }

    private ObjectEntry _toObjectEntry(String json, ObjectDefinition objectDefinition, String scopeKey, final User user) {
        ObjectEntry objectEntry = ObjectEntry.unsafeToDTO((String)json);
        objectEntry.setActions((Map)HashMapBuilder.put((Object)"delete", (Object)this.addDeleteAction(objectDefinition, scopeKey, user)).build());
        objectEntry.setExternalReferenceCode(() -> {
            Map properties = objectEntry.getProperties();
            return String.valueOf(properties.get("externalReferenceCode"));
        });
        if (objectEntry.getStatus() == null) {
            objectEntry.setStatus(new Status(){
                {
                    this.code = 0;
                    this.label = "approved";
                    this.label_i18n = FunctionObjectEntryManagerImpl.this.language.get(user.getLocale(), "approved");
                }
            });
        }
        return objectEntry;
    }
}

