/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.manager.v1_0;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.exception.NoSuchObjectEntryException;
import com.liferay.object.field.business.type.ObjectFieldBusinessTypeRegistry;
import com.liferay.object.model.ObjectAction;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ManyToOneObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.relationship.util.ObjectRelationshipUtil;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.filter.factory.FilterFactory;
import com.liferay.object.rest.filter.parser.ObjectDefinitionFilterParser;
import com.liferay.object.rest.internal.petra.sql.dsl.expression.OrderByExpressionUtil;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryRelatedObjectsResourceImpl;
import com.liferay.object.rest.internal.resource.v1_0.ObjectEntryResourceImpl;
import com.liferay.object.rest.internal.util.ObjectEntryValuesUtil;
import com.liferay.object.rest.manager.v1_0.BaseObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.rest.manager.v1_0.ObjectRelationshipElementsParser;
import com.liferay.object.rest.manager.v1_0.ObjectRelationshipElementsParserRegistry;
import com.liferay.object.service.ObjectActionLocalService;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.service.ObjectRelationshipService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermFilter;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.search.aggregation.Aggregations;
import com.liferay.portal.search.aggregation.bucket.FilterAggregation;
import com.liferay.portal.search.aggregation.bucket.NestedAggregation;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.vulcan.aggregation.Aggregation;
import com.liferay.portal.vulcan.aggregation.Facet;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.ActionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"object.entry.manager.storage.type=default"}, service={ObjectEntryManager.class})
public class DefaultObjectEntryManagerImpl
extends BaseObjectEntryManager
implements DefaultObjectEntryManager {
    private static final Log _log = LogFactoryUtil.getLog(DefaultObjectEntryManagerImpl.class);
    @Reference
    private Aggregations _aggregations;
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference(target="(filter.factory.key=default)")
    private FilterFactory<Predicate> _filterFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;
    @Reference
    private ObjectActionLocalService _objectActionLocalService;
    @Reference
    private ObjectDefinitionFilterParser _objectDefinitionFilterParser;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(component.name=com.liferay.object.rest.internal.dto.v1_0.converter.ObjectEntryDTOConverter)")
    private DTOConverter<ObjectEntry, com.liferay.object.rest.dto.v1_0.ObjectEntry> _objectEntryDTOConverter;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldBusinessTypeRegistry _objectFieldBusinessTypeRegistry;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipElementsParserRegistry _objectRelationshipElementsParserRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectRelationshipService _objectRelationshipService;
    @Reference
    private PersistedModelLocalServiceRegistry _persistedModelLocalServiceRegistry;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public com.liferay.object.rest.dto.v1_0.ObjectEntry addObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.validateReadOnlyObjectFields(null, objectDefinition, objectEntry);
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.addObjectEntry(this.getGroupId(objectDefinition, scopeKey), objectDefinition.getObjectDefinitionId(), this._toObjectValues(dtoConverterContext.getUserId(), objectDefinition, objectEntry, dtoConverterContext.getLocale()), this._createServiceContext(objectEntry, dtoConverterContext.getUserId()));
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._addOrUpdateNestedObjectEntries(dtoConverterContext, objectDefinition, objectEntry, this._getObjectRelationships(objectDefinition, objectEntry), serviceBuilderObjectEntry.getPrimaryKey()));
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry addObjectRelationshipMappingTableValues(DTOConverterContext dtoConverterContext, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) throws Exception {
        this._objectRelationshipService.addObjectRelationshipMappingTableValues(objectRelationship.getObjectRelationshipId(), primaryKey1, primaryKey2, new ServiceContext());
        return this.getObjectEntry(dtoConverterContext, this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2()), primaryKey2);
    }

    public Object addSystemObjectRelationshipMappingTableValues(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey1, long primaryKey2) throws Exception {
        this._objectRelationshipService.addObjectRelationshipMappingTableValues(objectRelationship.getObjectRelationshipId(), primaryKey1, primaryKey2, new ServiceContext());
        SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(systemObjectDefinitionManager.getModelClassName());
        return this._toDTO((BaseModel)persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(primaryKey2)), this._objectEntryService.getObjectEntry(primaryKey1), systemObjectDefinitionManager);
    }

    public void deleteObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(externalReferenceCode, companyId, this.getGroupId(objectDefinition, scopeKey));
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        this._objectEntryService.deleteObjectEntry(serviceBuilderObjectEntry.getObjectEntryId());
    }

    public void deleteObjectEntry(ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        this._checkObjectEntryObjectDefinitionId(objectDefinition, this._objectEntryService.getObjectEntry(objectEntryId));
        this._objectEntryService.deleteObjectEntry(objectEntryId);
    }

    public void disassociateRelatedModels(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey, ObjectDefinition relatedObjectDefinition, long userId) throws Exception {
        ObjectRelatedModelsProvider objectRelatedModelsProvider = null;
        if (this._isManyToOneObjectRelationship(relatedObjectDefinition, objectRelationship, objectDefinition)) {
            objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition.getClassName(), objectDefinition.getCompanyId(), objectRelationship.getType());
            long relatedPrimaryKey = this._getPrimaryKey(this._getManyToOneRelatedModel(dtoConverterContext, objectDefinition, objectRelationship, primaryKey, relatedObjectDefinition));
            objectRelatedModelsProvider.disassociateRelatedModels(userId, objectRelationship.getObjectRelationshipId(), relatedPrimaryKey, primaryKey);
        } else {
            objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
            if (objectRelationship.getObjectDefinitionId1() != objectDefinition.getObjectDefinitionId() && Objects.equals("manyToMany", objectRelationship.getType())) {
                objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationship.getName());
            }
            for (Object relatedModel : objectRelatedModelsProvider.getRelatedModels(GroupThreadLocal.getGroupId().longValue(), objectRelationship.getObjectRelationshipId(), primaryKey, null, -1, -1)) {
                objectRelatedModelsProvider.disassociateRelatedModels(userId, objectRelationship.getObjectRelationshipId(), primaryKey, this._getPrimaryKey(relatedModel));
            }
        }
    }

    public void executeObjectAction(DTOConverterContext dtoConverterContext, String objectActionName, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        this._executeObjectAction(dtoConverterContext, objectActionName, objectDefinition, this.objectEntryLocalService.getObjectEntry(objectEntryId));
    }

    public void executeObjectAction(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, String objectActionName, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        this._executeObjectAction(dtoConverterContext, objectActionName, objectDefinition, this.objectEntryLocalService.getObjectEntry(externalReferenceCode, companyId, this.getGroupId(objectDefinition, scopeKey)));
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry fetchObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.fetchObjectEntry(objectEntryId);
        if (serviceBuilderObjectEntry == null) {
            return null;
        }
        if (objectDefinition == null) {
            objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(serviceBuilderObjectEntry.getObjectDefinitionId());
        }
        return this._toObjectEntry(dtoConverterContext, objectDefinition, serviceBuilderObjectEntry);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry fetchRelatedManyToOneObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
        ManyToOneObjectRelatedModelsProvider objectRelatedModelsProvider = (ManyToOneObjectRelatedModelsProvider)this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
        ObjectEntry serviceBuilderObjectEntry = (ObjectEntry)objectRelatedModelsProvider.fetchRelatedModel(GroupThreadLocal.getGroupId().longValue(), objectRelationship.getObjectRelationshipId(), objectEntryId.longValue());
        if (serviceBuilderObjectEntry == null) {
            return null;
        }
        return this._toObjectEntry(dtoConverterContext, relatedObjectDefinition, serviceBuilderObjectEntry);
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, Expression filterExpression, Pagination pagination, String search, Sort[] sorts) throws Exception {
        Predicate predicate = (Predicate)this._filterFactory.create(filterExpression, objectDefinition);
        long groupId = this.getGroupId(objectDefinition, scopeKey);
        int start = this._getStartPosition(pagination);
        int end = this._getEndPosition(pagination);
        ArrayList<Facet> facets = new ArrayList<Facet>();
        if (aggregation != null && aggregation.getAggregationTerms() != null) {
            Map aggregationTerms = aggregation.getAggregationTerms();
            for (Map.Entry entry1 : aggregationTerms.entrySet()) {
                ArrayList<Facet.FacetValue> facetValues = new ArrayList<Facet.FacetValue>();
                Map aggregationCounts = this.objectEntryLocalService.getAggregationCounts(groupId, objectDefinition.getObjectDefinitionId(), (String)entry1.getKey(), predicate, start, end);
                for (Map.Entry entry2 : aggregationCounts.entrySet()) {
                    Long value = (Long)entry2.getValue();
                    facetValues.add(new Facet.FacetValue(Integer.valueOf(value.intValue()), String.valueOf(entry2.getKey())));
                }
                facets.add(new Facet((String)entry1.getKey(), facetValues));
            }
        }
        return Page.of((Map)HashMapBuilder.put((Object)"create", (Object)ActionUtil.addAction((String)"ADD_OBJECT_ENTRY", ObjectEntryResourceImpl.class, (Long)0L, (String)"postObjectEntry", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"createBatch", (Object)ActionUtil.addAction((String)"ADD_OBJECT_ENTRY", ObjectEntryResourceImpl.class, (Long)0L, (String)"postObjectEntryBatch", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"deleteBatch", (Object)ActionUtil.addAction((String)"DELETE", ObjectEntryResourceImpl.class, null, (String)"deleteObjectEntryBatch", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)0L, (String)"getObjectEntriesPage", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"updateBatch", (Object)ActionUtil.addAction((String)"UPDATE", ObjectEntryResourceImpl.class, null, (String)"putObjectEntryBatch", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).build(), facets, (Collection)TransformUtil.transform((Collection)this.objectEntryLocalService.getValuesList(groupId, companyId, dtoConverterContext.getUserId(), objectDefinition.getObjectDefinitionId(), predicate, search, start, end, OrderByExpressionUtil.getOrderByExpressions(objectDefinition.getObjectDefinitionId(), this.objectFieldLocalService, sorts)), values -> this._getObjectEntry(dtoConverterContext, objectDefinition, (Map<String, Serializable>)values)), (Pagination)pagination, (long)this.objectEntryLocalService.getValuesListCount(groupId, companyId, dtoConverterContext.getUserId(), objectDefinition.getObjectDefinitionId(), predicate, search));
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, Filter filter, Pagination pagination, String search, Sort[] sorts) throws Exception {
        long groupId = this.getGroupId(objectDefinition, scopeKey);
        return SearchUtil.search((Map)HashMapBuilder.put((Object)"create", (Object)ActionUtil.addAction((String)"ADD_OBJECT_ENTRY", ObjectEntryResourceImpl.class, (Long)0L, (String)"postObjectEntry", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryResourceImpl.class, (Long)0L, (String)"getObjectEntriesPage", null, (Long)objectDefinition.getUserId(), (String)this._getObjectEntriesPermissionName(objectDefinition.getObjectDefinitionId()), (Long)groupId, (UriInfo)dtoConverterContext.getUriInfo())).build(), booleanQuery -> {
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new TermFilter("objectDefinitionId", String.valueOf(objectDefinition.getObjectDefinitionId())), BooleanClauseOccur.MUST);
        }, (Filter)filter, (String)objectDefinition.getClassName(), (String)search, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            searchContext.addVulcanAggregation(aggregation);
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("objectDefinitionId", (Serializable)Long.valueOf(objectDefinition.getObjectDefinitionId()));
            UriInfo uriInfo = dtoConverterContext.getUriInfo();
            if (uriInfo != null) {
                MultivaluedMap queryParameters = uriInfo.getQueryParameters();
                searchContext.setAttribute("searchByObjectView", (Serializable)Boolean.valueOf(queryParameters.containsKey((Object)"searchByObjectView")));
            }
            searchContext.setCompanyId(companyId);
            searchContext.setGroupIds(new long[]{groupId});
            SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder((SearchContext)searchContext);
            this._processVulcanAggregation(this._aggregations, this._queries, searchRequestBuilder, aggregation);
        }, (Sort[])sorts, document -> this.getObjectEntry(dtoConverterContext, objectDefinition, GetterUtil.getLong((String)document.get("entryClassPK"))));
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntries(long companyId, ObjectDefinition objectDefinition, String scopeKey, Aggregation aggregation, DTOConverterContext dtoConverterContext, String filterString, Pagination pagination, String search, Sort[] sorts) throws Exception {
        return this.getObjectEntries(companyId, objectDefinition, scopeKey, aggregation, dtoConverterContext, this._objectDefinitionFilterParser.parse(filterString, objectDefinition), pagination, search, sorts);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(objectEntryId);
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, serviceBuilderObjectEntry);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry getObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, String scopeKey) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(externalReferenceCode, companyId, this.getGroupId(objectDefinition, scopeKey));
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, serviceBuilderObjectEntry);
    }

    public Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> getObjectEntryRelatedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
        ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
        if (objectDefinition.isUnmodifiableSystemObject()) {
            return this._getSystemObjectRelatedObjectEntries(dtoConverterContext, objectDefinition, objectEntryId, objectRelationship, objectRelatedModelsProvider, pagination);
        }
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(objectEntryId.longValue());
        return Page.of((Map)HashMapBuilder.put((Object)"get", (Object)ActionUtil.addAction((String)"VIEW", ObjectEntryRelatedObjectsResourceImpl.class, (Long)objectEntryId, (String)"getCurrentObjectEntriesObjectRelationshipNamePage", null, (Long)serviceBuilderObjectEntry.getUserId(), (String)this._getObjectEntryPermissionName(objectDefinition.getObjectDefinitionId()), (Long)serviceBuilderObjectEntry.getGroupId(), (UriInfo)dtoConverterContext.getUriInfo())).build(), this._toObjectEntries(dtoConverterContext, objectRelatedModelsProvider.getRelatedModels(serviceBuilderObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), serviceBuilderObjectEntry.getPrimaryKey(), null, this._getStartPosition(pagination), this._getEndPosition(pagination))), (Pagination)pagination, (long)objectRelatedModelsProvider.getRelatedModelsCount(serviceBuilderObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), serviceBuilderObjectEntry.getPrimaryKey(), null));
    }

    public Page<Object> getRelatedSystemObjectEntries(ObjectDefinition objectDefinition, Long objectEntryId, String objectRelationshipName, Pagination pagination) throws Exception {
        ObjectRelationship objectRelationship = this._objectRelationshipService.getObjectRelationship(objectDefinition.getObjectDefinitionId(), objectRelationshipName);
        ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
        ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(objectEntryId.longValue());
        return Page.of((Collection)TransformUtil.transform((Collection)objectRelatedModelsProvider.getRelatedModels(serviceBuilderObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), serviceBuilderObjectEntry.getPrimaryKey(), null, this._getStartPosition(pagination), this._getEndPosition(pagination)), baseModel -> this._toDTO((BaseModel<?>)baseModel, serviceBuilderObjectEntry, this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(relatedObjectDefinition.getName()))), (Pagination)pagination, (long)objectRelatedModelsProvider.getRelatedModelsCount(serviceBuilderObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), serviceBuilderObjectEntry.getPrimaryKey(), null));
    }

    public String getStorageLabel(Locale locale) {
        return this.language.get(locale, "default");
    }

    public String getStorageType() {
        return "default";
    }

    public Object getSystemObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long primaryKey) throws Exception {
        if (!objectDefinition.isUnmodifiableSystemObject()) {
            return null;
        }
        if (FeatureFlagManagerUtil.isEnabled((String)"LPS-183882")) {
            SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
            return ObjectEntryDTOConverterUtil.toDTO((BaseModel)systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey), objectDefinition.getCompanyId()), (DTOConverterRegistry)this._dtoConverterRegistry, (SystemObjectDefinitionManager)systemObjectDefinitionManager, (User)dtoConverterContext.getUser());
        }
        return this.objectEntryLocalService.getSystemModelAttributes(objectDefinition, primaryKey);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry partialUpdateObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        com.liferay.object.rest.dto.v1_0.ObjectEntry existingObjectEntry = this.getObjectEntry(dtoConverterContext, objectDefinition, objectEntryId);
        if (objectEntry.getDateCreated() != null) {
            existingObjectEntry.setDateCreated(objectEntry.getDateCreated());
        }
        if (objectEntry.getDateModified() != null) {
            existingObjectEntry.setDateModified(objectEntry.getDateModified());
        }
        if (objectEntry.getKeywords() != null) {
            existingObjectEntry.setKeywords(objectEntry.getKeywords());
        }
        if (objectEntry.getProperties() != null) {
            Map properties = existingObjectEntry.getProperties();
            properties.putAll(objectEntry.getProperties());
            existingObjectEntry.setProperties(properties);
        }
        if (objectEntry.getTaxonomyCategoryIds() != null) {
            existingObjectEntry.setTaxonomyCategoryIds(objectEntry.getTaxonomyCategoryIds());
        }
        return this.updateObjectEntry(dtoConverterContext, objectDefinition, objectEntryId, existingObjectEntry);
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry updateObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(objectEntryId);
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        this.validateReadOnlyObjectFields(serviceBuilderObjectEntry.getExternalReferenceCode(), objectDefinition, objectEntry);
        serviceBuilderObjectEntry = this._objectEntryService.updateObjectEntry(objectEntryId, this._toObjectValues(dtoConverterContext.getUserId(), objectDefinition, objectEntry, dtoConverterContext.getLocale()), this._createServiceContext(objectEntry, dtoConverterContext.getUserId()));
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._addOrUpdateNestedObjectEntries(dtoConverterContext, objectDefinition, objectEntry, this._getObjectRelationships(objectDefinition, objectEntry), serviceBuilderObjectEntry.getPrimaryKey()));
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry updateObjectEntry(long companyId, DTOConverterContext dtoConverterContext, String externalReferenceCode, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, String scopeKey) throws Exception {
        this.validateReadOnlyObjectFields(externalReferenceCode, objectDefinition, objectEntry);
        long groupId = this.getGroupId(objectDefinition, scopeKey);
        ServiceContext serviceContext = this._createServiceContext(objectEntry, dtoConverterContext.getUserId());
        serviceContext.setCompanyId(companyId);
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.addOrUpdateObjectEntry(externalReferenceCode, groupId, objectDefinition.getObjectDefinitionId(), this._toObjectValues(dtoConverterContext.getUserId(), objectDefinition, objectEntry, dtoConverterContext.getLocale()), serviceContext);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, this._addOrUpdateNestedObjectEntries(dtoConverterContext, objectDefinition, objectEntry, this._getObjectRelationships(objectDefinition, objectEntry), serviceBuilderObjectEntry.getPrimaryKey()));
    }

    private Map<String, String> _addAction(String actionName, String methodName, ObjectEntry serviceBuilderObjectEntry, UriInfo uriInfo) throws Exception {
        Map map = ActionUtil.addAction((String)actionName, ObjectEntryResourceImpl.class, (Long)serviceBuilderObjectEntry.getObjectEntryId(), (String)methodName, null, (Long)serviceBuilderObjectEntry.getUserId(), (String)this._getObjectEntryPermissionName(serviceBuilderObjectEntry.getObjectDefinitionId()), (Long)serviceBuilderObjectEntry.getGroupId(), (UriInfo)uriInfo);
        if (map != null) {
            return map;
        }
        return ActionUtil.addAction((String)actionName, ObjectEntryResourceImpl.class, (Long)serviceBuilderObjectEntry.getObjectEntryId(), (String)methodName, null, (ModelResourcePermission)this._objectEntryService.getModelResourcePermission(serviceBuilderObjectEntry), (UriInfo)uriInfo);
    }

    private ObjectEntry _addOrUpdateNestedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, Map<String, ObjectRelationship> objectRelationships, long primaryKey) throws Exception {
        Map properties = objectEntry.getProperties();
        for (Map.Entry<String, ObjectRelationship> entry : objectRelationships.entrySet()) {
            List nestedObjectEntries;
            ObjectRelationship objectRelationship = objectRelationships.get(entry.getKey());
            ObjectDefinition relatedObjectDefinition = this._getRelatedObjectDefinition(objectDefinition, objectRelationship);
            ObjectRelationshipElementsParser objectRelationshipElementsParser = this._objectRelationshipElementsParserRegistry.getObjectRelationshipElementsParser(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
            if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
                SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(relatedObjectDefinition.getName());
                nestedObjectEntries = objectRelationshipElementsParser.parse(objectRelationship, properties.get(entry.getKey()));
                this.disassociateRelatedModels(dtoConverterContext, objectDefinition, objectRelationship, primaryKey, relatedObjectDefinition, dtoConverterContext.getUserId());
                for (Map nestedObjectEntry : nestedObjectEntries) {
                    this._relateNestedObjectEntry(objectDefinition, objectRelationship, primaryKey, systemObjectDefinitionManager.upsertBaseModel(String.valueOf(nestedObjectEntry.get("externalReferenceCode")), relatedObjectDefinition.getCompanyId(), dtoConverterContext.getUser(), nestedObjectEntry));
                }
            } else {
                ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(relatedObjectDefinition.getStorageType());
                nestedObjectEntries = objectRelationshipElementsParser.parse(objectRelationship, properties.get(entry.getKey()));
                this.disassociateRelatedModels(dtoConverterContext, objectDefinition, objectRelationship, primaryKey, relatedObjectDefinition, dtoConverterContext.getUserId());
                for (Map nestedObjectEntry : nestedObjectEntries) {
                    if (this._isManyToOneObjectRelationship(objectDefinition, objectRelationship, relatedObjectDefinition)) {
                        Map nestedObjectEntryProperties = nestedObjectEntry.getProperties();
                        String objectRelationshipName = StringBundler.concat((String[])new String[]{"r_", objectRelationship.getName(), "_", objectDefinition.getPKObjectFieldName()});
                        nestedObjectEntryProperties.put(objectRelationshipName, primaryKey);
                    }
                    nestedObjectEntry = objectEntryManager.updateObjectEntry(objectDefinition.getCompanyId(), dtoConverterContext, nestedObjectEntry.getExternalReferenceCode(), relatedObjectDefinition, (com.liferay.object.rest.dto.v1_0.ObjectEntry)nestedObjectEntry, relatedObjectDefinition.getScope());
                    if (this._isManyToOneObjectRelationship(objectDefinition, objectRelationship, relatedObjectDefinition)) continue;
                    this._relateNestedObjectEntry(objectDefinition, objectRelationship, primaryKey, nestedObjectEntry.getId());
                }
            }
            if (!properties.containsKey(entry.getKey())) continue;
            NestedFieldsSupplier.addFieldName((String)entry.getKey());
        }
        return this.objectEntryLocalService.getObjectEntry(primaryKey);
    }

    private void _checkObjectEntryObjectDefinitionId(ObjectDefinition objectDefinition, ObjectEntry serviceBuilderObjectEntry) throws Exception {
        if (objectDefinition.getObjectDefinitionId() != serviceBuilderObjectEntry.getObjectDefinitionId()) {
            throw new NoSuchObjectEntryException();
        }
    }

    private ServiceContext _createServiceContext(com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, long userId) {
        Map properties;
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        if (Validator.isNotNull((Object)objectEntry.getTaxonomyCategoryIds())) {
            serviceContext.setAssetCategoryIds(ArrayUtil.toArray((Long[])objectEntry.getTaxonomyCategoryIds()));
            serviceContext.setAssetTagNames(objectEntry.getKeywords());
        }
        if ((properties = objectEntry.getProperties()).get("categoryIds") != null) {
            serviceContext.setAssetCategoryIds(ListUtil.toLongArray((List)((List)properties.get("categoryIds")), Long::parseLong));
        }
        if (Validator.isNotNull((Object)objectEntry.getKeywords())) {
            serviceContext.setAssetTagNames(objectEntry.getKeywords());
        }
        if (properties.get("tagNames") != null) {
            serviceContext.setAssetTagNames(ArrayUtil.toStringArray((Collection)((List)properties.get("tagNames"))));
        }
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    private void _executeObjectAction(DTOConverterContext dtoConverterContext, String objectActionName, ObjectDefinition objectDefinition, ObjectEntry serviceBuilderObjectEntry) throws Exception {
        this._objectEntryService.checkModelResourcePermission(objectDefinition.getObjectDefinitionId(), serviceBuilderObjectEntry.getObjectEntryId(), objectActionName);
        this._objectActionEngine.executeObjectAction(objectActionName, "standalone", objectDefinition.getObjectDefinitionId(), JSONUtil.put((String)"classPK", (Object)serviceBuilderObjectEntry.getObjectEntryId()).put("objectEntry", (Object)HashMapBuilder.putAll((Map)serviceBuilderObjectEntry.getModelAttributes()).put((Object)"values", (Object)serviceBuilderObjectEntry.getValues()).build()).put("objectEntryDTO" + objectDefinition.getShortName(), () -> {
            dtoConverterContext.setAttribute("addActions", (Object)Boolean.FALSE);
            JSONObject jsonObject = this._jsonFactory.createJSONObject(this._jsonFactory.looseSerializeDeep((Object)this._toObjectEntry(dtoConverterContext, objectDefinition, serviceBuilderObjectEntry)));
            return jsonObject.toMap();
        }), dtoConverterContext.getUserId());
    }

    private int _getEndPosition(Pagination pagination) {
        if (pagination != null) {
            return pagination.getEndPosition();
        }
        return -1;
    }

    private Object _getManyToOneRelatedModel(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey, ObjectDefinition relatedObjectDefinition) throws Exception {
        if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
            ManyToOneObjectRelatedModelsProvider manyToOneObjectRelatedModelsProvider = (ManyToOneObjectRelatedModelsProvider)this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
            return manyToOneObjectRelatedModelsProvider.fetchRelatedModel(relatedObjectDefinition.getCompanyId(), objectRelationship.getObjectRelationshipId(), primaryKey);
        }
        return this.fetchRelatedManyToOneObjectEntry(dtoConverterContext, objectDefinition, primaryKey, objectRelationship.getName());
    }

    private String _getObjectEntriesPermissionName(long objectDefinitionId) {
        return "com.liferay.object#" + objectDefinitionId;
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _getObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, Map<String, Serializable> values) throws Exception {
        ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(GetterUtil.getLong((Object)values.get(objectDefinition.getPKObjectFieldName())));
        this._checkObjectEntryObjectDefinitionId(objectDefinition, serviceBuilderObjectEntry);
        return this._toObjectEntry(dtoConverterContext, objectDefinition, serviceBuilderObjectEntry);
    }

    private String _getObjectEntryPermissionName(long objectDefinitionId) {
        return ObjectDefinition.class.getName() + "#" + objectDefinitionId;
    }

    private Map<String, ObjectRelationship> _getObjectRelationships(ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry) throws Exception {
        HashMap<String, ObjectRelationship> objectRelationships = new HashMap<String, ObjectRelationship>();
        Map properties = objectEntry.getProperties();
        for (String key : properties.keySet()) {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId(objectDefinition.getObjectDefinitionId(), key);
            if (objectRelationship == null) continue;
            objectRelationships.put(key, objectRelationship);
        }
        return objectRelationships;
    }

    private long _getPrimaryKey(Object relatedModel) {
        if (relatedModel instanceof BaseModel) {
            BaseModel baseModel = (BaseModel)relatedModel;
            return (Long)baseModel.getPrimaryKeyObj();
        }
        if (relatedModel instanceof com.liferay.object.rest.dto.v1_0.ObjectEntry) {
            com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry = (com.liferay.object.rest.dto.v1_0.ObjectEntry)relatedModel;
            return objectEntry.getId();
        }
        return 0L;
    }

    private ObjectDefinition _getRelatedObjectDefinition(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship) throws Exception {
        ObjectDefinition relatedObjectDefinition = ObjectRelationshipUtil.getRelatedObjectDefinition((ObjectDefinition)objectDefinition, (ObjectRelationship)objectRelationship);
        if (!relatedObjectDefinition.isActive()) {
            throw new BadRequestException("Object definition " + relatedObjectDefinition.getObjectDefinitionId() + " is inactive");
        }
        return relatedObjectDefinition;
    }

    private int _getStartPosition(Pagination pagination) {
        if (pagination != null) {
            return pagination.getStartPosition();
        }
        return -1;
    }

    private Page<com.liferay.object.rest.dto.v1_0.ObjectEntry> _getSystemObjectRelatedObjectEntries(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, long objectEntryId, ObjectRelationship objectRelationship, ObjectRelatedModelsProvider objectRelatedModelsProvider, Pagination pagination) throws Exception {
        long groupId = GroupThreadLocal.getGroupId();
        SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
        PersistedModelLocalService persistedModelLocalService = this._persistedModelLocalServiceRegistry.getPersistedModelLocalService(systemObjectDefinitionManager.getModelClassName());
        PersistedModel persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(objectEntryId));
        if (Objects.equals(systemObjectDefinitionManager.getScope(), "site") && persistedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)persistedModel;
            groupId = groupedModel.getGroupId();
        }
        return Page.of(Collections.emptyMap(), this._toObjectEntries(dtoConverterContext, objectRelatedModelsProvider.getRelatedModels(groupId, objectRelationship.getObjectRelationshipId(), objectEntryId, null, this._getStartPosition(pagination), this._getEndPosition(pagination))), (Pagination)pagination, (long)objectRelatedModelsProvider.getRelatedModelsCount(groupId, objectRelationship.getObjectRelationshipId(), objectEntryId, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _hasRelatedObjectEntries(ObjectDefinition objectDefinition, ObjectEntry serviceBuilderObjectEntry) throws PortalException {
        for (ObjectRelationship objectRelationship : this._objectRelationshipLocalService.getObjectRelationships(objectDefinition.getObjectDefinitionId(), "prevent", false)) {
            ObjectDefinition objectDefinition2 = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
            if (!objectDefinition2.isActive()) continue;
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(objectDefinition2.getClassName(), objectDefinition2.getCompanyId(), objectRelationship.getType());
            int count = 0;
            try {
                ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
                count = objectRelatedModelsProvider.getRelatedModelsCount(serviceBuilderObjectEntry.getGroupId(), objectRelationship.getObjectRelationshipId(), serviceBuilderObjectEntry.getPrimaryKey(), null);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            finally {
                ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)false);
            }
            if (count <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean _isManyToOneObjectRelationship(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, ObjectDefinition relatedObjectDefinition) {
        return Objects.equals(objectRelationship.getType(), "oneToMany") && objectRelationship.getObjectDefinitionId1() == objectDefinition.getObjectDefinitionId() && objectRelationship.getObjectDefinitionId2() == relatedObjectDefinition.getObjectDefinitionId();
    }

    private void _processVulcanAggregation(Aggregations aggregations, Queries queries, SearchRequestBuilder searchRequestBuilder, Aggregation vulcanAggregation) {
        if (vulcanAggregation == null) {
            return;
        }
        Map aggregationTerms = vulcanAggregation.getAggregationTerms();
        for (Map.Entry entry : aggregationTerms.entrySet()) {
            String value = (String)entry.getValue();
            if (!value.startsWith("nestedFieldArray")) continue;
            NestedAggregation nestedAggregation = aggregations.nested((String)entry.getKey(), "nestedFieldArray");
            String[] valueParts = value.split("#");
            FilterAggregation filterAggregation = aggregations.filter("filterAggregation", (Query)queries.term("nestedFieldArray.fieldName", (Object)valueParts[1]));
            filterAggregation.addChildAggregation((com.liferay.portal.search.aggregation.Aggregation)aggregations.terms((String)entry.getKey(), valueParts[0]));
            nestedAggregation.addChildAggregation((com.liferay.portal.search.aggregation.Aggregation)filterAggregation);
            searchRequestBuilder.addAggregation((com.liferay.portal.search.aggregation.Aggregation)nestedAggregation);
        }
    }

    private void _relateNestedObjectEntry(ObjectDefinition objectDefinition, ObjectRelationship objectRelationship, long primaryKey, long relatedPrimaryKey) throws Exception {
        long primaryKey1 = relatedPrimaryKey;
        long primaryKey2 = primaryKey;
        if (objectDefinition.getObjectDefinitionId() == objectRelationship.getObjectDefinitionId1()) {
            primaryKey1 = primaryKey;
            primaryKey2 = relatedPrimaryKey;
        }
        this._objectRelationshipService.addObjectRelationshipMappingTableValues(objectRelationship.getObjectRelationshipId(), primaryKey1, primaryKey2, new ServiceContext());
    }

    private Date _toDate(Locale locale, String valueString) {
        if (Validator.isNull((String)valueString)) {
            return null;
        }
        try {
            return DateUtil.parseDate((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (String)valueString, (Locale)locale);
        }
        catch (ParseException parseException1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)parseException1);
            }
            try {
                return DateUtil.parseDate((String)"yyyy-MM-dd", (String)valueString, (Locale)locale);
            }
            catch (ParseException parseException2) {
                throw new BadRequestException("Unable to parse date that does not conform to ISO-8601", (Throwable)parseException2);
            }
        }
    }

    private Object _toDTO(BaseModel<?> baseModel, ObjectEntry serviceBuilderObjectEntry, SystemObjectDefinitionManager systemObjectDefinitionManager) throws Exception {
        return ObjectEntryDTOConverterUtil.toDTO(baseModel, (DTOConverterRegistry)this._dtoConverterRegistry, (SystemObjectDefinitionManager)systemObjectDefinitionManager, (User)this._userLocalService.getUser(serviceBuilderObjectEntry.getUserId()));
    }

    private List<com.liferay.object.rest.dto.v1_0.ObjectEntry> _toObjectEntries(DTOConverterContext dtoConverterContext, List<ObjectEntry> serviceBuilderObjectEntries) {
        return TransformUtil.transform(serviceBuilderObjectEntries, serviceBuilderObjectEntry -> this._toObjectEntry(dtoConverterContext, this._objectDefinitionLocalService.getObjectDefinition(serviceBuilderObjectEntry.getObjectDefinitionId()), (ObjectEntry)serviceBuilderObjectEntry));
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _toObjectEntry(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry serviceBuilderObjectEntry) throws Exception {
        HashMap actions = dtoConverterContext.getActions();
        if (GetterUtil.getBoolean((Object)dtoConverterContext.getAttribute("addActions"), (boolean)true)) {
            if (actions == null) {
                actions = Collections.emptyMap();
            }
            actions = HashMapBuilder.create(actions).put((Object)"delete", () -> {
                if (this._hasRelatedObjectEntries(objectDefinition, serviceBuilderObjectEntry)) {
                    return null;
                }
                return this._addAction("DELETE", "deleteObjectEntry", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo());
            }).put((Object)"get", this._addAction("VIEW", "getObjectEntry", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo())).put((Object)"permissions", this._addAction("PERMISSIONS", "getObjectEntryPermissionsPage", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo())).put((Object)"replace", this._addAction("UPDATE", "putObjectEntry", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo())).put((Object)"update", this._addAction("UPDATE", "patchObjectEntry", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo())).build();
            for (ObjectAction objectAction : this._objectActionLocalService.getObjectActions(objectDefinition.getObjectDefinitionId(), "standalone")) {
                actions.put(objectAction.getName(), this._addAction(objectAction.getName(), "putByExternalReferenceCodeObjectEntryExternalReferenceCodeObjectActionObjectActionName", serviceBuilderObjectEntry, dtoConverterContext.getUriInfo()));
            }
        }
        DefaultDTOConverterContext defaultDTOConverterContext = new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), actions, dtoConverterContext.getDTOConverterRegistry(), dtoConverterContext.getHttpServletRequest(), (Object)serviceBuilderObjectEntry.getObjectEntryId(), dtoConverterContext.getLocale(), dtoConverterContext.getUriInfo(), dtoConverterContext.getUser());
        defaultDTOConverterContext.setAttribute("objectDefinition", (Object)objectDefinition);
        return (com.liferay.object.rest.dto.v1_0.ObjectEntry)this._objectEntryDTOConverter.toDTO((DTOConverterContext)defaultDTOConverterContext, (Object)serviceBuilderObjectEntry);
    }

    private Map<String, Serializable> _toObjectValues(long userId, ObjectDefinition objectDefinition, com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry, Locale locale) throws Exception {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (ObjectField objectField : this.objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId())) {
            Object value = ObjectEntryValuesUtil.getValue(this._objectDefinitionLocalService, this.objectEntryLocalService, objectField, this._objectFieldBusinessTypeRegistry, userId, objectEntry.getProperties());
            if (Objects.equals(objectField.getName(), "externalReferenceCode") && Validator.isNull((Object)value) && Validator.isNotNull((String)objectEntry.getExternalReferenceCode())) {
                values.put(objectField.getName(), (Serializable)((Object)objectEntry.getExternalReferenceCode()));
                continue;
            }
            if (objectField.isLocalized()) {
                Map properties = objectEntry.getProperties();
                value = properties.get(objectField.getI18nObjectFieldName());
                if (value == null) continue;
                values.put(objectField.getI18nObjectFieldName(), (Serializable)value);
                continue;
            }
            if (value == null && !objectField.isRequired()) continue;
            if (Objects.equals(objectField.getDBType(), "Date")) {
                values.put(objectField.getName(), this._toDate(locale, String.valueOf(value)));
                continue;
            }
            if (objectField.getListTypeDefinitionId() != 0L) {
                if (value instanceof ListEntry) {
                    ListEntry listEntry = (ListEntry)value;
                    values.put(objectField.getName(), (Serializable)((Object)listEntry.getKey()));
                    continue;
                }
                if (value instanceof Map) {
                    HashMap map = (HashMap)value;
                    values.put(objectField.getName(), (Serializable)map.get("key"));
                    continue;
                }
                values.put(objectField.getName(), (Serializable)value);
                continue;
            }
            values.put(objectField.getName(), (Serializable)value);
        }
        return values;
    }
}

