/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.jaxrs.context.provider.util;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.rest.internal.deployer.ObjectDefinitionDeployerImpl;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.message.Message;

public class ObjectContextProviderUtil {
    private static final Log _log = LogFactoryUtil.getLog(ObjectContextProviderUtil.class);

    public static HttpServletRequest getHttpServletRequest(Message message) {
        return (HttpServletRequest)message.getContextualProperty("HTTP.REQUEST");
    }

    public static ObjectDefinition getObjectDefinition(Message message, ObjectDefinitionDeployerImpl objectDefinitionDeployerImpl, Portal portal) {
        long companyId = portal.getCompanyId(ObjectContextProviderUtil.getHttpServletRequest(message));
        String restContextPath = (String)message.getContextualProperty("org.apache.cxf.message.Message.BASE_PATH");
        restContextPath = restContextPath.substring(restContextPath.indexOf("/o/"));
        restContextPath = StringUtil.removeFirst((String)restContextPath, (String)"/o");
        restContextPath = StringUtil.replaceLast((String)restContextPath, (char)'/', (String)"");
        try {
            return objectDefinitionDeployerImpl.getObjectDefinition(companyId, restContextPath);
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            throw new RuntimeException(exception);
        }
    }
}

