/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.rest.internal.dto.v1_0.converter;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.list.type.model.ListTypeEntry;
import com.liferay.list.type.service.ListTypeEntryLocalService;
import com.liferay.object.entry.util.ObjectEntryDTOConverterUtil;
import com.liferay.object.entry.util.ObjectEntryValuesUtil;
import com.liferay.object.field.setting.util.ObjectFieldSettingUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.rest.dto.v1_0.AuditEvent;
import com.liferay.object.rest.dto.v1_0.AuditFieldChange;
import com.liferay.object.rest.dto.v1_0.FileEntry;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.dto.v1_0.Status;
import com.liferay.object.rest.dto.v1_0.TaxonomyCategoryBrief;
import com.liferay.object.rest.dto.v1_0.util.CreatorUtil;
import com.liferay.object.rest.dto.v1_0.util.LinkUtil;
import com.liferay.object.rest.internal.dto.v1_0.util.TaxonomyCategoryBriefUtil;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.object.system.SystemObjectDefinitionManager;
import com.liferay.object.system.SystemObjectDefinitionManagerRegistry;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.workflow.WorkflowConstants;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.security.audit.storage.service.AuditEventLocalService;
import com.liferay.portal.vulcan.dto.converter.DTOConverter;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.extension.EntityExtensionHandler;
import com.liferay.portal.vulcan.extension.ExtensionProviderRegistry;
import com.liferay.portal.vulcan.extension.util.ExtensionUtil;
import com.liferay.portal.vulcan.fields.NestedFieldsSupplier;
import com.liferay.portal.vulcan.jaxrs.extension.ExtendedEntity;
import com.liferay.portal.vulcan.util.LocalizedMapUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.UriInfo;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dto.class.name=com.liferay.object.model.ObjectEntry"}, service={DTOConverter.class})
public class ObjectEntryDTOConverter
implements DTOConverter<ObjectEntry, com.liferay.object.rest.dto.v1_0.ObjectEntry> {
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryDTOConverter.class);
    @Reference
    private AssetCategoryLocalService _assetCategoryLocalService;
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private AuditEventLocalService _auditEventLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryLocalService _dLFileEntryLocalService;
    @Reference
    private DLURLHelper _dlURLHelper;
    @Reference
    private ExtensionProviderRegistry _extensionProviderRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private ListTypeEntryLocalService _listTypeEntryLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private Portal _portal;
    @Reference
    private SystemObjectDefinitionManagerRegistry _systemObjectDefinitionManagerRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public String getContentType() {
        return com.liferay.object.rest.dto.v1_0.ObjectEntry.class.getSimpleName();
    }

    public com.liferay.object.rest.dto.v1_0.ObjectEntry toDTO(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        return this._toDTO(dtoConverterContext, objectEntry);
    }

    private void _addManyToOneObjectRelationshipNames(Map<String, Object> map, ObjectField objectField, String objectFieldName, ObjectRelationship objectRelationship, long primaryKey, Map<String, Serializable> values) {
        String objectRelationshipERCObjectFieldName = ObjectFieldSettingUtil.getValue((String)"objectRelationshipERCObjectFieldName", (ObjectField)objectField);
        String relatedObjectEntryERC = GetterUtil.getString((Object)values.get(objectRelationshipERCObjectFieldName));
        if (map.get(objectRelationship.getName()) == null) {
            map.put(objectRelationship.getName() + "ERC", relatedObjectEntryERC);
        }
        map.put(objectFieldName, primaryKey);
        map.put(objectRelationshipERCObjectFieldName, relatedObjectEntryERC);
    }

    private void _addManyToOneRelatedObjectEntries(DTOConverterContext dtoConverterContext, Map<String, Object> map, String objectFieldName, ObjectRelationship objectRelationship, long primaryKey) throws Exception {
        AtomicReference relatedObjectEntryAtomicReference;
        String manyToOneRelationshipName;
        String relatedObjectDefinitionName = StringUtil.replaceLast((String)objectFieldName.substring(objectFieldName.lastIndexOf("_") + 1), (String)"Id", (String)"");
        Map nestedFieldValues = NestedFieldsSupplier.supply(arg_0 -> this.lambda$_addManyToOneRelatedObjectEntries$0(relatedObjectDefinitionName, objectRelationship, manyToOneRelationshipName = StringUtil.removeLast((String)objectFieldName, (String)"Id"), relatedObjectEntryAtomicReference = new AtomicReference(), primaryKey, dtoConverterContext, arg_0));
        if (nestedFieldValues == null) {
            return;
        }
        for (Map.Entry entry : nestedFieldValues.entrySet()) {
            String nestedFieldName = (String)entry.getKey();
            if (StringUtil.equals((String)nestedFieldName, (String)objectRelationship.getName())) {
                map.put(objectRelationship.getName(), entry.getValue());
            }
            if (!nestedFieldName.contains(relatedObjectDefinitionName) && !StringUtil.equals((String)nestedFieldName, (String)objectRelationship.getName())) continue;
            map.put(manyToOneRelationshipName, entry.getValue());
        }
    }

    private DTOConverterContext _getDTOConverterContext(DTOConverterContext dtoConverterContext, long objectEntryId) {
        UriInfo uriInfo = dtoConverterContext.getUriInfo();
        return new DefaultDTOConverterContext(dtoConverterContext.isAcceptAllLanguages(), null, dtoConverterContext.getDTOConverterRegistry(), dtoConverterContext.getHttpServletRequest(), (Object)objectEntryId, dtoConverterContext.getLocale(), uriInfo, dtoConverterContext.getUser());
    }

    private ListEntry _getListEntry(final DTOConverterContext dtoConverterContext, String key, long listTypeDefinitionId) {
        final ListTypeEntry listTypeEntry = this._listTypeEntryLocalService.fetchListTypeEntry(listTypeDefinitionId, key);
        if (listTypeEntry == null) {
            return null;
        }
        return new ListEntry(){
            {
                this.key = listTypeEntry.getKey();
                this.name = listTypeEntry.getName(dtoConverterContext.getLocale());
                this.name_i18n = LocalizedMapUtil.getI18nMap((boolean)dtoConverterContext.isAcceptAllLanguages(), (Map)listTypeEntry.getNameMap());
            }
        };
    }

    private Map<String, Serializable> _getNestedFieldsRelatedProperties(DTOConverterContext dtoConverterContext, long groupId, ObjectDefinition objectDefinition, long primaryKey) throws Exception {
        return NestedFieldsSupplier.supply(nestedFieldName -> {
            ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectDefinitionId1(objectDefinition.getObjectDefinitionId(), nestedFieldName);
            if (objectRelationship == null || !objectRelationship.isAllowedObjectRelationshipType(objectRelationship.getType())) {
                return null;
            }
            ObjectDefinition relatedObjectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId2());
            if (!relatedObjectDefinition.isActive()) {
                return null;
            }
            ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(relatedObjectDefinition.getClassName(), relatedObjectDefinition.getCompanyId(), objectRelationship.getType());
            List relatedModels = objectRelatedModelsProvider.getRelatedModels(groupId, objectRelationship.getObjectRelationshipId(), primaryKey, null, -1, -1);
            if (relatedObjectDefinition.isUnmodifiableSystemObject()) {
                SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(relatedObjectDefinition.getName());
                return TransformUtil.transformToArray((Collection)relatedModels, relatedModel -> this._toExtendedEntity((BaseModel)relatedModel, dtoConverterContext, relatedObjectDefinition, systemObjectDefinitionManager), Object.class);
            }
            return TransformUtil.transformToArray((Collection)relatedModels, relatedModel -> {
                ObjectEntry objectEntry = (ObjectEntry)relatedModel;
                return this._toDTO(this._getDTOConverterContext(dtoConverterContext, objectEntry.getObjectEntryId()), objectEntry);
            }, com.liferay.object.rest.dto.v1_0.ObjectEntry.class);
        });
    }

    private ObjectDefinition _getObjectDefinition(DTOConverterContext dtoConverterContext, ObjectEntry objectEntry) throws Exception {
        ObjectDefinition objectDefinition = (ObjectDefinition)dtoConverterContext.getAttribute("objectDefinition");
        if (objectDefinition == null) {
            objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectEntry.getObjectDefinitionId());
        }
        return objectDefinition;
    }

    private String _getScopeKey(ObjectDefinition objectDefinition, ObjectEntry objectEntry) {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (objectScopeProvider.isGroupAware()) {
            Group group = this._groupLocalService.fetchGroup(objectEntry.getGroupId());
            if (group == null) {
                return null;
            }
            return group.getGroupKey();
        }
        return null;
    }

    private AuditEvent[] _toAuditEvents(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        return (AuditEvent[])NestedFieldsSupplier.supply((String)"auditEvents", nestedFieldNames -> {
            if (!objectDefinition.isEnableObjectEntryHistory() || !this._objectEntryService.hasModelResourcePermission(objectDefinition.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "OBJECT_ENTRY_HISTORY")) {
                return null;
            }
            return (AuditEvent[])TransformUtil.transformToArray((Collection)this._auditEventLocalService.getAuditEvents(0L, 0L, 0L, null, null, null, null, null, String.valueOf(objectEntry.getObjectEntryId()), null, null, null, 0, null, false, -1, -1), auditEvent -> {
                AuditEvent newAuditEvent = new AuditEvent();
                newAuditEvent.setAuditFieldChanges(this._toAuditFieldChanges(auditEvent.getAdditionalInfo(), auditEvent.getEventType()));
                newAuditEvent.setCreator(CreatorUtil.toCreator((Portal)this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)this._userLocalService.fetchUser(auditEvent.getUserId())));
                newAuditEvent.setDateCreated(auditEvent.getCreateDate());
                newAuditEvent.setEventType(auditEvent.getEventType());
                return newAuditEvent;
            }, AuditEvent.class);
        });
    }

    private AuditFieldChange[] _toAuditFieldChanges(String additionalInfo, String eventType) throws Exception {
        JSONObject jsonObject = this._jsonFactory.createJSONObject(additionalInfo);
        if (StringUtil.equals((String)eventType, (String)"ADD")) {
            Map map = jsonObject.toMap();
            return (AuditFieldChange[])TransformUtil.transformToArray(map.keySet(), key -> new AuditFieldChange((String)key, map){
                final /* synthetic */ String val$key;
                final /* synthetic */ Map val$map;
                {
                    this.val$key = string;
                    this.val$map = map;
                    this.name = this.val$key;
                    this.newValue = this.val$map.get(this.val$key);
                }
            }, AuditFieldChange.class);
        }
        return (AuditFieldChange[])JSONUtil.toArray((JSONArray)jsonObject.getJSONArray("attributes"), attributeJSONObject -> new AuditFieldChange((JSONObject)attributeJSONObject){
            final /* synthetic */ JSONObject val$attributeJSONObject;
            {
                this.val$attributeJSONObject = jSONObject;
                this.name = this.val$attributeJSONObject.getString("name");
                this.newValue = this.val$attributeJSONObject.get("newValue");
                this.oldValue = this.val$attributeJSONObject.get("oldValue");
            }
        }, AuditFieldChange.class);
    }

    private com.liferay.object.rest.dto.v1_0.ObjectEntry _toDTO(final DTOConverterContext dtoConverterContext, final ObjectEntry objectEntry) throws Exception {
        final ObjectDefinition objectDefinition = this._getObjectDefinition(dtoConverterContext, objectEntry);
        return new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
            {
                this.actions = dtoConverterContext.getActions();
                this.auditEvents = ObjectEntryDTOConverter.this._toAuditEvents(dtoConverterContext, objectDefinition, objectEntry);
                this.creator = CreatorUtil.toCreator((Portal)ObjectEntryDTOConverter.this._portal, (UriInfo)dtoConverterContext.getUriInfo(), (User)ObjectEntryDTOConverter.this._userLocalService.fetchUser(objectEntry.getUserId()));
                this.dateCreated = objectEntry.getCreateDate();
                this.dateModified = objectEntry.getModifiedDate();
                this.externalReferenceCode = objectEntry.getExternalReferenceCode();
                this.id = objectEntry.getObjectEntryId();
                if (objectDefinition.isEnableCategorization()) {
                    this.keywords = (String[])ListUtil.toArray((List)ObjectEntryDTOConverter.this._assetTagLocalService.getTags(objectDefinition.getClassName(), objectEntry.getObjectEntryId()), (Accessor)AssetTag.NAME_ACCESSOR);
                }
                this.properties = ObjectEntryDTOConverter.this._toProperties(dtoConverterContext, objectDefinition, objectEntry);
                this.scopeKey = ObjectEntryDTOConverter.this._getScopeKey(objectDefinition, objectEntry);
                this.status = new Status(){
                    {
                        this.code = objectEntry.getStatus();
                        this.label = WorkflowConstants.getStatusLabel((int)objectEntry.getStatus());
                        this.label_i18n = ObjectEntryDTOConverter.this._language.get(LanguageResources.getResourceBundle((Locale)dtoConverterContext.getLocale()), WorkflowConstants.getStatusLabel((int)objectEntry.getStatus()));
                    }
                };
                this.setTaxonomyCategoryBriefs(() -> {
                    if (!objectDefinition.isEnableCategorization()) {
                        return null;
                    }
                    return (TaxonomyCategoryBrief[])TransformUtil.transformToArray((Collection)ObjectEntryDTOConverter.this._assetCategoryLocalService.getCategories(objectDefinition.getClassName(), objectEntry.getObjectEntryId()), assetCategory -> TaxonomyCategoryBriefUtil.toTaxonomyCategoryBrief(assetCategory, dtoConverterContext), TaxonomyCategoryBrief.class);
                });
            }
        };
    }

    private ExtendedEntity _toExtendedEntity(BaseModel<?> baseModel, DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, SystemObjectDefinitionManager systemObjectDefinitionManager) throws Exception {
        DTOConverter dtoConverter = ObjectEntryDTOConverterUtil.getDTOConverter((DTOConverterRegistry)dtoConverterContext.getDTOConverterRegistry(), (SystemObjectDefinitionManager)systemObjectDefinitionManager);
        Object dto = ObjectEntryDTOConverterUtil.toDTO(baseModel, (DTOConverterRegistry)dtoConverterContext.getDTOConverterRegistry(), (SystemObjectDefinitionManager)systemObjectDefinitionManager, (User)dtoConverterContext.getUser());
        Map nestedFieldsRelatedProperties = null;
        EntityExtensionHandler entityExtensionHandler = ExtensionUtil.getEntityExtensionHandler((String)dtoConverter.getExternalDTOClassName(), (long)objectDefinition.getCompanyId(), (ExtensionProviderRegistry)this._extensionProviderRegistry);
        if (entityExtensionHandler != null) {
            nestedFieldsRelatedProperties = entityExtensionHandler.getExtendedProperties(objectDefinition.getCompanyId(), dto);
        }
        return ExtendedEntity.extend((Object)dto, nestedFieldsRelatedProperties, null);
    }

    private Map<String, Object> _toProperties(DTOConverterContext dtoConverterContext, ObjectDefinition objectDefinition, ObjectEntry objectEntry) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map values = objectEntry.getValues();
        List objectFields = this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId(), false);
        for (ObjectField objectField : objectFields) {
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-172017") && objectField.isLocalized()) {
                map.put(objectField.getI18nObjectFieldName(), values.get(objectField.getI18nObjectFieldName()));
            }
            String objectFieldName = objectField.getName();
            Serializable serializable = (Serializable)values.get(objectFieldName);
            if (objectField.compareBusinessType("Attachment")) {
                long fileEntryId = GetterUtil.getLong(values.get(objectField.getName()));
                if (fileEntryId == 0L) continue;
                FileEntry fileEntry = new FileEntry();
                DLFileEntry dlFileEntry = this._dLFileEntryLocalService.fetchDLFileEntry(fileEntryId);
                if (dlFileEntry != null) {
                    fileEntry.setId(Long.valueOf(dlFileEntry.getFileEntryId()));
                    fileEntry.setLink(LinkUtil.toLink((DLAppService)this._dlAppService, (DLFileEntry)dlFileEntry, (DLURLHelper)this._dlURLHelper, (String)objectDefinition.getExternalReferenceCode(), (String)objectEntry.getExternalReferenceCode(), (Portal)this._portal));
                    fileEntry.setName(dlFileEntry.getFileName());
                }
                map.put(objectFieldName, fileEntry);
                continue;
            }
            if (objectField.compareBusinessType("DateTime")) {
                Timestamp timestamp = (Timestamp)serializable;
                if (timestamp == null) continue;
                String pattern = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                if (StringUtil.equals((String)ObjectFieldSettingUtil.getValue((String)"timeStorage", (ObjectField)objectField), (String)"convertToUTC")) {
                    pattern = pattern + "'Z'";
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                map.put(objectFieldName, simpleDateFormat.format(timestamp));
                continue;
            }
            if (objectField.compareBusinessType("MultiselectPicklist")) {
                if (objectField.getListTypeDefinitionId() == 0L) continue;
                map.put(objectFieldName, TransformUtil.transformToList((Object[])StringUtil.split((String)((String)((Object)serializable)), (String)", "), key -> this._getListEntry(dtoConverterContext, (String)key, objectField.getListTypeDefinitionId())));
                continue;
            }
            if (objectField.compareBusinessType("Picklist")) {
                ListEntry listEntry;
                if (objectField.getListTypeDefinitionId() == 0L || (listEntry = this._getListEntry(dtoConverterContext, (String)((Object)serializable), objectField.getListTypeDefinitionId())) == null) continue;
                map.put(objectFieldName, listEntry);
                continue;
            }
            if (objectField.compareBusinessType("RichText")) {
                map.put(objectFieldName, serializable);
                map.put(objectFieldName + "RawText", ObjectEntryValuesUtil.getValueString((ObjectField)objectField, (Map)values));
                continue;
            }
            if (Objects.equals(objectField.getRelationshipType(), "oneToMany")) {
                long primaryKey = GetterUtil.getLong((Object)serializable);
                ObjectRelationship objectRelationship = this._objectRelationshipLocalService.fetchObjectRelationshipByObjectFieldId2(objectField.getObjectFieldId());
                if (primaryKey > 0L) {
                    this._addManyToOneRelatedObjectEntries(dtoConverterContext, map, objectFieldName, objectRelationship, primaryKey);
                }
                this._addManyToOneObjectRelationshipNames(map, objectField, objectFieldName, objectRelationship, primaryKey, values);
                continue;
            }
            map.put(objectFieldName, serializable);
        }
        values.remove(objectDefinition.getPKObjectFieldName());
        Map<String, Serializable> nestedFieldsRelatedProperties = this._getNestedFieldsRelatedProperties(dtoConverterContext, objectEntry.getGroupId(), objectDefinition, objectEntry.getObjectEntryId());
        if (nestedFieldsRelatedProperties != null) {
            map.putAll(nestedFieldsRelatedProperties);
        }
        return map;
    }

    private /* synthetic */ Serializable lambda$_addManyToOneRelatedObjectEntries$0(String relatedObjectDefinitionName, ObjectRelationship objectRelationship, String manyToOneRelationshipName, AtomicReference relatedObjectEntryAtomicReference, long primaryKey, DTOConverterContext dtoConverterContext, String nestedFieldName) throws Exception {
        if (!nestedFieldName.contains(relatedObjectDefinitionName) && !StringUtil.equals((String)nestedFieldName, (String)objectRelationship.getName())) {
            return null;
        }
        if (!StringUtil.equals((String)nestedFieldName, (String)manyToOneRelationshipName) && !StringUtil.equals((String)nestedFieldName, (String)objectRelationship.getName()) && !StringUtil.equals((String)nestedFieldName, (String)relatedObjectDefinitionName) && _log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Replace the deprecated nested field \"", nestedFieldName, "\" with \"", objectRelationship.getName()}));
        }
        if (relatedObjectEntryAtomicReference.get() != null) {
            return (Serializable)relatedObjectEntryAtomicReference.get();
        }
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectRelationship.getObjectDefinitionId1());
        if (objectDefinition.isUnmodifiableSystemObject()) {
            if (FeatureFlagManagerUtil.isEnabled((String)"LPS-183882")) {
                SystemObjectDefinitionManager systemObjectDefinitionManager = this._systemObjectDefinitionManagerRegistry.getSystemObjectDefinitionManager(objectDefinition.getName());
                BaseModel baseModel = systemObjectDefinitionManager.getBaseModelByExternalReferenceCode(systemObjectDefinitionManager.getBaseModelExternalReferenceCode(primaryKey), objectDefinition.getCompanyId());
                Map values = ObjectEntryDTOConverterUtil.toValues((BaseModel)baseModel, (DTOConverterRegistry)dtoConverterContext.getDTOConverterRegistry(), (String)objectDefinition.getName(), (SystemObjectDefinitionManagerRegistry)this._systemObjectDefinitionManagerRegistry, (User)dtoConverterContext.getUser());
                if (MapUtil.isNotEmpty((Map)values)) {
                    ObjectField objectField = this._objectFieldLocalService.fetchObjectField(objectDefinition.getTitleObjectFieldId());
                    values.put(objectField.getName(), ObjectEntryValuesUtil.getTitleFieldValue((String)objectField.getBusinessType(), (Map)baseModel.getModelAttributes(), (ObjectField)objectField, (User)dtoConverterContext.getUser(), (Map)values));
                }
                relatedObjectEntryAtomicReference.set((Serializable)((Object)values));
            } else {
                relatedObjectEntryAtomicReference.set((Serializable)((Object)this._objectEntryLocalService.getSystemModelAttributes(objectDefinition, primaryKey)));
            }
        } else {
            relatedObjectEntryAtomicReference.set(this.toDTO(this._getDTOConverterContext(dtoConverterContext, primaryKey), this._objectEntryLocalService.getObjectEntry(primaryKey)));
        }
        return (Serializable)relatedObjectEntryAtomicReference.get();
    }
}

