/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.portal.kernel.scheduler;

import com.liferay.dispatch.scheduler.SchedulerResponseManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TriggerState;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SchedulerResponseManager.class})
public class SchedulerResponseManagerImpl
implements SchedulerResponseManager {
    private static final Log _log = LogFactoryUtil.getLog(SchedulerResponseManagerImpl.class);
    @Reference
    private MessageBus _messageBus;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;

    public Date getNextFireDate(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getNextFireTime(schedulerResponse);
    }

    public List<SchedulerResponse> getSchedulerResponses(int start, int end) {
        List schedulerResponses = new ArrayList();
        try {
            schedulerResponses = this._schedulerEngineHelper.getScheduledJobs();
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)"Unable to get scheduler responses", (Throwable)schedulerException);
            return schedulerResponses;
        }
        schedulerResponses = ListUtil.filter(schedulerResponses, schedulerResponse -> {
            String jobName = schedulerResponse.getJobName();
            return !jobName.startsWith("DISPATCH_JOB_");
        });
        Collections.sort(schedulerResponses, Comparator.comparing(schedulerResponse -> this.getSimpleJobName(schedulerResponse.getJobName())));
        return schedulerResponses.subList(start, Math.min(end, schedulerResponses.size()));
    }

    public int getSchedulerResponsesCount() {
        List schedulerResponses = null;
        try {
            schedulerResponses = this._schedulerEngineHelper.getScheduledJobs();
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)"Unable to get scheduler responses", (Throwable)schedulerException);
            return 0;
        }
        return ListUtil.count((List)schedulerResponses, schedulerResponse -> {
            String jobName = schedulerResponse.getJobName();
            return !jobName.startsWith("DISPATCH_JOB_");
        });
    }

    public String getSimpleJobName(String jobName) {
        return jobName.substring(jobName.lastIndexOf(".") + 1);
    }

    public TriggerState getTriggerState(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getJobState(schedulerResponse);
    }

    public void pause(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngineHelper.pause(jobName, groupName, storageType);
    }

    public void resume(String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngineHelper.resume(jobName, groupName, storageType);
    }

    public void run(long companyId, String jobName, String groupName, StorageType storageType) throws SchedulerException {
        this._schedulerEngineHelper.run(companyId, jobName, groupName, storageType);
    }
}

