/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.helper;

import com.liferay.dispatch.exception.DispatchTriggerSchedulerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import java.util.Date;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DispatchTriggerHelper.class})
public class DispatchTriggerHelper {
    private static final Log _log = LogFactoryUtil.getLog(DispatchTriggerHelper.class);
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public void addSchedulerJob(long dispatchTriggerId, String cronExpression, Date startDate, Date endDate, StorageType storageType, String timeZoneId) throws DispatchTriggerSchedulerException {
        Trigger trigger = this._triggerFactory.createTrigger(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), startDate, endDate, cronExpression, TimeZone.getTimeZone(timeZoneId));
        try {
            this._schedulerEngineHelper.schedule(trigger, storageType, null, "liferay/dispatch/executor", (Object)this._getPayload(dispatchTriggerId));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Scheduler entry created for dispatch trigger " + dispatchTriggerId));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new DispatchTriggerSchedulerException("Unable to create scheduler entry for dispatch trigger " + dispatchTriggerId, (Throwable)schedulerException);
        }
    }

    public void deleteSchedulerJob(long dispatchTriggerId, StorageType storageType) {
        try {
            String jobName = this._getJobName(dispatchTriggerId);
            String groupName = this._getGroupName(dispatchTriggerId);
            this._schedulerEngineHelper.delete(jobName, groupName, storageType);
            SchedulerResponse scheduledJob = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
            while (scheduledJob != null) {
                scheduledJob = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
            }
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)("Unable to delete scheduler entry for dispatch trigger " + dispatchTriggerId), (Throwable)schedulerException);
        }
    }

    public Date getNextFireDate(long dispatchTriggerId, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getNextFireTime(schedulerResponse);
    }

    public Date getPreviousFireDate(long dispatchTriggerId, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getPreviousFireTime(schedulerResponse);
    }

    private String _getGroupName(long dispatchTriggerId) {
        return String.format("DISPATCH_GROUP_%07d", dispatchTriggerId);
    }

    private String _getJobName(long dispatchTriggerId) {
        return String.format("DISPATCH_JOB_%07d", dispatchTriggerId);
    }

    private String _getPayload(long dispatchTriggerId) {
        return String.format("{\"dispatchTriggerId\": %d}", dispatchTriggerId);
    }
}

