/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.executor;

import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskExecutorRegistry;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={DispatchTaskExecutorRegistry.class})
public class DispatchTaskExecutorRegistryImpl
implements DispatchTaskExecutorRegistry {
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_CLUSTER_MODE = "dispatch.task.executor.cluster.mode";
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_HIDDEN_IN_UI = "dispatch.task.executor.hidden-in-ui";
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_NAME = "dispatch.task.executor.name";
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_TYPE = "dispatch.task.executor.type";
    private static final Log _log = LogFactoryUtil.getLog(DispatchTaskExecutorRegistryImpl.class);
    private final List<String> _clusterModeSingleNodeDispatchTaskExecutors = new ArrayList<String>();
    private final Map<String, String> _dispatchTaskExecutorNames = new HashMap<String, String>();
    private final Map<String, DispatchTaskExecutor> _dispatchTaskExecutors = new HashMap<String, DispatchTaskExecutor>();

    public DispatchTaskExecutor fetchDispatchTaskExecutor(String dispatchTaskExecutorType) {
        return this._dispatchTaskExecutors.get(dispatchTaskExecutorType);
    }

    public String fetchDispatchTaskExecutorName(String dispatchTaskExecutorType) {
        return this._dispatchTaskExecutorNames.get(dispatchTaskExecutorType);
    }

    public Set<String> getDispatchTaskExecutorTypes() {
        return this._dispatchTaskExecutors.keySet();
    }

    public boolean isClusterModeSingle(String type) {
        return this._clusterModeSingleNodeDispatchTaskExecutors.contains(type);
    }

    public boolean isHiddenInUI(String type) {
        return !this._dispatchTaskExecutorNames.containsKey(type);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDispatchTaskExecutor(DispatchTaskExecutor dispatchTaskExecutor, Map<String, Object> properties) {
        String dispatchTaskExecutorType = (String)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_TYPE);
        this._validateDispatchTaskExecutorProperties(dispatchTaskExecutor, dispatchTaskExecutorType);
        if (!GetterUtil.getBoolean((Object)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_HIDDEN_IN_UI))) {
            this._dispatchTaskExecutorNames.put(dispatchTaskExecutorType, (String)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_NAME));
        }
        this._checkDispatchTaskClusterMode(dispatchTaskExecutorType, properties);
        this._dispatchTaskExecutors.put(dispatchTaskExecutorType, dispatchTaskExecutor);
    }

    protected void removeDispatchTaskExecutor(DispatchTaskExecutor dispatchTaskExecutor, Map<String, Object> properties) {
        String dispatchTaskExecutorType = (String)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_TYPE);
        this._dispatchTaskExecutorNames.remove(dispatchTaskExecutorType);
        this._dispatchTaskExecutors.remove(dispatchTaskExecutorType);
    }

    private void _checkDispatchTaskClusterMode(String dispatchTaskExecutorType, Map<String, Object> properties) {
        String label = GetterUtil.getString((Object)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_CLUSTER_MODE), (String)DispatchTaskClusterMode.ALL_NODES.getLabel());
        if (Objects.equals(label, DispatchTaskClusterMode.SINGLE_NODE.getLabel())) {
            this._clusterModeSingleNodeDispatchTaskExecutors.add(dispatchTaskExecutorType);
        }
    }

    private void _validateDispatchTaskExecutorProperties(DispatchTaskExecutor dispatchTaskExecutor, String dispatchTaskExecutorType) {
        if (!this._dispatchTaskExecutors.containsKey(dispatchTaskExecutorType)) {
            return;
        }
        DispatchTaskExecutor curDispatchTaskExecutor = this._dispatchTaskExecutors.get(dispatchTaskExecutorType);
        Class<?> clazz1 = curDispatchTaskExecutor.getClass();
        Class<?> clazz2 = dispatchTaskExecutor.getClass();
        _log.error((Object)StringBundler.concat((String[])new String[]{_KEY_DISPATCH_TASK_EXECUTOR_TYPE, " property must have unique ", "value. The same value is found in ", clazz1.getName(), " and ", clazz2.getName(), "."}));
    }
}

