/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.gen.simple;

import java.util.ArrayList;
import org.beetl.core.ErrorHandler;
import org.beetl.core.ReThrowConsoleErrorHandler;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.gen.BaseProject;
import org.beetl.sql.gen.SourceBuilder;
import org.beetl.sql.gen.SourceConfig;
import org.beetl.sql.gen.simple.EntitySourceBuilder;
import org.beetl.sql.gen.simple.MDSourceBuilder;
import org.beetl.sql.gen.simple.MapperSourceBuilder;
import org.beetl.sql.gen.simple.StringOnlyProject;

public class SimpleCodeTool {
    BaseProject project = new StringOnlyProject();
    SQLManager sqlManager;
    String jdbcUrl;
    String jdbcDriver;
    String userName;
    String passwd;
    DBStyle dbStyle;
    NameConversion nameConversion;

    public SimpleCodeTool(String jdbcUrl, String jdbcDriver, String userName, String passwd, DBStyle dbStyle, NameConversion nameConversion) {
        this.jdbcUrl = jdbcUrl;
        this.jdbcDriver = jdbcDriver;
        this.userName = userName;
        this.passwd = passwd;
        this.dbStyle = dbStyle;
        this.nameConversion = nameConversion;
        this.initSQLManager();
    }

    public SimpleCodeTool(String jdbcUrl, String jdbcDriver, String userName, String passwd) {
        this(jdbcUrl, jdbcDriver, userName, passwd, (DBStyle)new MySqlStyle(), (NameConversion)new UnderlinedNameConversion());
    }

    public SimpleCodeTool(SQLManager sqlManager) {
        this.sqlManager = sqlManager;
    }

    public String code(String table) {
        ArrayList<SourceBuilder> sourceBuilder = new ArrayList<SourceBuilder>();
        EntitySourceBuilder entityBuilder = new EntitySourceBuilder();
        MapperSourceBuilder mapperBuilder = new MapperSourceBuilder();
        MDSourceBuilder mdBuilder = new MDSourceBuilder();
        sourceBuilder.add(entityBuilder);
        sourceBuilder.add(mapperBuilder);
        sourceBuilder.add(mdBuilder);
        SourceConfig config = new SourceConfig(this.sqlManager, sourceBuilder);
        EntitySourceBuilder.getGroupTemplate().setErrorHandler((ErrorHandler)new ReThrowConsoleErrorHandler());
        config.gen(table, this.project);
        return ((StringOnlyProject)this.project).getContent();
    }

    protected void config(SourceConfig config) {
        config.setPreferDateType(SourceConfig.PreferDateType.Timestamp);
    }

    protected SQLManager initSQLManager() {
        ConnectionSource source = ConnectionSourceHelper.getSimple((String)this.jdbcDriver, (String)this.jdbcUrl, (String)this.userName, (String)this.passwd);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        builder.setNc((NameConversion)new UnderlinedNameConversion());
        builder.setInters(new Interceptor[]{new DebugInterceptor()});
        builder.setDbStyle(this.dbStyle);
        SQLManager sqlManager = builder.build();
        return sqlManager;
    }
}

