/*
 * Decompiled with CFR 0.152.
 */
package com.obs.shade.okio;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.shade.okio.Buffer;
import com.obs.shade.okio.Segment;
import com.obs.shade.okio.Sink;
import com.obs.shade.okio.Source;
import com.obs.shade.okio.Timeout;
import com.obs.shade.okio.Util;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class AsyncTimeout
extends Timeout {
    private static final ILogger ILOG = LoggerBuilder.getLogger(AsyncTimeout.class);
    private static final int TIMEOUT_WRITE_SIZE = 65536;
    private static final long IDLE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(60L);
    private static final long IDLE_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(IDLE_TIMEOUT_MILLIS);
    private boolean inQueue;
    private AsyncTimeout next;
    private long timeoutAt;
    private static final int LOCK_SIZE = Runtime.getRuntime().availableProcessors();
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private final Locker locker;
    private int id = RANDOM.nextInt(LOCK_SIZE);
    private static final Map<Integer, Locker> LOCKERS = new HashMap<Integer, Locker>();

    public AsyncTimeout() {
        this.locker = LOCKERS.get(this.id);
        if (ILOG.isDebugEnabled()) {
            ILOG.debug("id is : " + this.id + "; and locker is : " + this.locker);
        }
    }

    private Locker getLocker() {
        return this.locker;
    }

    public final void enter() {
        if (this.inQueue) {
            throw new IllegalStateException("Unbalanced enter/exit");
        }
        long timeoutNanos = this.timeoutNanos();
        boolean hasDeadline = this.hasDeadline();
        if (timeoutNanos == 0L && !hasDeadline) {
            return;
        }
        this.inQueue = true;
        AsyncTimeout.scheduleTimeout(this, timeoutNanos, hasDeadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleTimeout(AsyncTimeout node, long timeoutNanos, boolean hasDeadline) {
        Locker locker = node.getLocker();
        synchronized (locker) {
            long start = System.nanoTime();
            node.getLocker().startWatch();
            long now = System.nanoTime();
            if (timeoutNanos != 0L && hasDeadline) {
                node.timeoutAt = now + Math.min(timeoutNanos, node.deadlineNanoTime() - now);
            } else if (timeoutNanos != 0L) {
                node.timeoutAt = now + timeoutNanos;
            } else if (hasDeadline) {
                node.timeoutAt = node.deadlineNanoTime();
            } else {
                throw new AssertionError();
            }
            long remainingNanos = node.remainingNanos(now);
            AsyncTimeout prev = node.getLocker().head;
            while (true) {
                if (prev.next == null || remainingNanos < prev.next.remainingNanos(now)) {
                    node.next = prev.next;
                    prev.next = node;
                    if (prev != node.getLocker().head) break;
                    node.getLocker().notifyAll();
                    break;
                }
                prev = prev.next;
            }
            if (ILOG.isDebugEnabled()) {
                ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: scheduleTimeout.in()");
            }
        }
    }

    public final boolean exit() {
        if (!this.inQueue) {
            return false;
        }
        this.inQueue = false;
        return AsyncTimeout.cancelScheduledTimeout(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cancelScheduledTimeout(AsyncTimeout node) {
        Locker locker = node.getLocker();
        synchronized (locker) {
            long start = System.nanoTime();
            AsyncTimeout prev = node.getLocker().head;
            while (prev != null) {
                if (prev.next == node) {
                    prev.next = node.next;
                    node.next = null;
                    if (ILOG.isDebugEnabled()) {
                        ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: cancelScheduledTimeout.in.1()");
                    }
                    return false;
                }
                prev = prev.next;
            }
            if (ILOG.isDebugEnabled()) {
                ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: cancelScheduledTimeout.in.2()");
            }
            return true;
        }
    }

    private long remainingNanos(long now) {
        return this.timeoutAt - now;
    }

    protected void timedOut() {
    }

    public final Sink sink(final Sink sink) {
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) throws IOException {
                Util.checkOffsetAndCount(source.size, 0L, byteCount);
                while (byteCount > 0L) {
                    long toWrite = 0L;
                    Segment s = source.head;
                    while (toWrite < 65536L) {
                        int segmentSize = s.limit - s.pos;
                        if ((toWrite += (long)segmentSize) >= byteCount) {
                            toWrite = byteCount;
                            break;
                        }
                        s = s.next;
                    }
                    boolean throwOnTimeout = false;
                    AsyncTimeout.this.enter();
                    try {
                        sink.write(source, toWrite);
                        byteCount -= toWrite;
                        throwOnTimeout = true;
                    }
                    catch (IOException e) {
                        throw AsyncTimeout.this.exit(e);
                    }
                    finally {
                        AsyncTimeout.this.exit(throwOnTimeout);
                    }
                }
            }

            @Override
            public void flush() throws IOException {
                boolean throwOnTimeout = false;
                AsyncTimeout.this.enter();
                try {
                    sink.flush();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw AsyncTimeout.this.exit(e);
                }
                finally {
                    AsyncTimeout.this.exit(throwOnTimeout);
                }
            }

            @Override
            public void close() throws IOException {
                boolean throwOnTimeout = false;
                AsyncTimeout.this.enter();
                try {
                    sink.close();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw AsyncTimeout.this.exit(e);
                }
                finally {
                    AsyncTimeout.this.exit(throwOnTimeout);
                }
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.sink(" + sink + ")";
            }
        };
    }

    public final Source source(final Source source) {
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                boolean throwOnTimeout = false;
                long start = System.nanoTime();
                AsyncTimeout.this.enter();
                if (ILOG.isDebugEnabled()) {
                    ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: enter()");
                }
                try {
                    start = System.nanoTime();
                    long result = source.read(sink, byteCount);
                    if (ILOG.isDebugEnabled()) {
                        ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: source.read(); result: " + result + "; byteCount: " + byteCount);
                    }
                    throwOnTimeout = true;
                    long l = result;
                    return l;
                }
                catch (IOException e) {
                    throw AsyncTimeout.this.exit(e);
                }
                finally {
                    start = System.nanoTime();
                    AsyncTimeout.this.exit(throwOnTimeout);
                    if (ILOG.isDebugEnabled()) {
                        ILOG.debug("Thread : " + Thread.currentThread().getName() + " - " + (System.nanoTime() - start) + " - Method: exit()");
                    }
                }
            }

            @Override
            public void close() throws IOException {
                boolean throwOnTimeout = false;
                try {
                    source.close();
                    throwOnTimeout = true;
                }
                catch (IOException e) {
                    throw AsyncTimeout.this.exit(e);
                }
                finally {
                    AsyncTimeout.this.exit(throwOnTimeout);
                }
            }

            @Override
            public Timeout timeout() {
                return AsyncTimeout.this;
            }

            public String toString() {
                return "AsyncTimeout.source(" + source + ")";
            }
        };
    }

    final void exit(boolean throwOnTimeout) throws IOException {
        boolean timedOut = this.exit();
        if (timedOut && throwOnTimeout) {
            throw new InterruptedIOException("timeout");
        }
    }

    final IOException exit(IOException cause) throws IOException {
        if (!this.exit()) {
            return cause;
        }
        return this.newTimeoutException(cause);
    }

    protected IOException newTimeoutException(IOException cause) {
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            e.initCause(cause);
        }
        return e;
    }

    static AsyncTimeout awaitTimeout(Locker locker) throws InterruptedException {
        if (null == locker.head) {
            return null;
        }
        AsyncTimeout node = locker.head.next;
        if (node == null) {
            long startNanos = System.nanoTime();
            locker.wait(IDLE_TIMEOUT_MILLIS);
            return locker.head.next == null && System.nanoTime() - startNanos >= IDLE_TIMEOUT_NANOS ? locker.head : null;
        }
        long waitNanos = node.remainingNanos(System.nanoTime());
        if (waitNanos > 0L) {
            long waitMillis = waitNanos / 1000000L;
            locker.wait(waitMillis, (int)(waitNanos -= waitMillis * 1000000L));
            return null;
        }
        locker.head.next = node.next;
        node.next = null;
        return node;
    }

    static {
        for (int i = 0; i < LOCK_SIZE; ++i) {
            LOCKERS.put(i, new Locker(i));
        }
    }

    private static final class Watchdog
    extends Thread {
        private Locker locker;

        Watchdog(Locker locker) {
            super("Okio Watchdog : " + locker.toString());
            this.setDaemon(true);
            this.locker = locker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        AsyncTimeout timedOut;
                        Locker locker = this.locker;
                        synchronized (locker) {
                            timedOut = AsyncTimeout.awaitTimeout(this.locker);
                            if (timedOut == null) {
                                continue;
                            }
                            if (timedOut == this.locker.head) {
                                this.locker.head = null;
                                return;
                            }
                        }
                        timedOut.timedOut();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class Locker {
        private int lockerId;
        public AsyncTimeout head;

        public Locker(int id) {
            this.lockerId = id;
        }

        public String toString() {
            return "Locker [lockerId=" + this.lockerId + "]";
        }

        public void startWatch() {
            if (this.head == null) {
                this.head = new AsyncTimeout();
                new Watchdog(this).start();
            }
        }
    }
}

