/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.service.ObsBucketBaseService;
import com.obs.services.internal.trans.NewTransResult;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.xml.OBSXMLBuilder;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketCustomDomainInfo;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.CreateVirtualBucketRequest;
import com.obs.services.model.CreateVirtualBucketResult;
import com.obs.services.model.DeleteBucketCustomDomainRequest;
import com.obs.services.model.GetBucketCustomDomainRequest;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HistoricalObjectReplicationEnum;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketAliasResult;
import com.obs.services.model.Permission;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RuleStatusEnum;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketCustomDomainRequest;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.crr.GetCrrProgressRequest;
import com.obs.services.model.crr.GetCrrProgressResult;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.http.HttpStatusCode;
import com.obs.shade.okhttp3.Request;
import com.obs.shade.okhttp3.RequestBody;
import com.obs.shade.okhttp3.Response;
import com.oef.services.model.RequestParamEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ObsBucketAdvanceService
extends ObsBucketBaseService {
    private static final ILogger log = LoggerBuilder.getLogger(ObsBucketAdvanceService.class);

    protected HeaderResponse setBucketVersioningImpl(SetBucketVersioningRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = this.getIConvertor(request.getBucketName()).transVersioningConfiguration(request.getBucketName(), request.getStatus() != null ? request.getStatus().getCode() : null);
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected HeaderResponse setBucketRequestPaymentImpl(SetBucketRequestPaymentRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = this.getIConvertor(request.getBucketName()).transRequestPaymentConfiguration(request.getBucketName(), request.getPayer() != null ? request.getPayer().getCode() : null);
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected RequestPaymentConfiguration getBucketRequestPaymentImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(response);
        RequestPaymentConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.RequestPaymentHandler.class, false).getRequestPaymentConfiguration();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setBucketNotificationImpl(SetBucketNotificationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = this.getIConvertor(request.getBucketName()).transBucketNotificationConfiguration(request.getBucketNotificationConfiguration());
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketNotificationConfiguration getBucketNotificationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketNotificationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketNotificationConfigurationHandler.class, false).getBucketNotificationConfiguration();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse setBucketWebsiteConfigurationImpl(SetBucketWebsiteRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = this.getIConvertor(request.getBucketName()).transWebsiteConfiguration(request.getWebsiteConfig());
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected WebsiteConfiguration getBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        WebsiteConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketWebsiteConfigurationHandler.class, false).getWebsiteConfig();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketLifecycleConfigurationImpl(SetBucketLifecycleRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transLifecycleConfiguration(request.getLifecycleConfig());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected LifecycleConfiguration getBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(response);
        LifecycleConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketLifecycleConfigurationHandler.class, false).getLifecycleConfig();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse deleteBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketTaggingImpl(SetBucketTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transBucketTagInfo(request.getBucketTagInfo());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketTagInfo getBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketTagInfo result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketTagInfoHandler.class, false).getBucketTagInfo();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketEncryptionImpl(SetBucketEncryptionRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String xml = request.getBucketEncryption() == null ? "" : this.getIConvertor(request.getBucketName()).transBucketEcryption(request.getBucketEncryption());
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketEncryption getBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketEncryption ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketEncryptionHandler.class, false).getEncryption();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketReplicationConfigurationImpl(SetBucketReplicationRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transReplicationConfiguration(request.getReplicationConfiguration());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected ReplicationConfiguration getBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        ReplicationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketReplicationConfigurationHandler.class, false).getReplicationConfiguration();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected GetCrrProgressResult getCrrProgressImpl(GetCrrProgressRequest request) {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION_PROGRESS.getOriginalStringCode(), "");
        requestParameters.put(SpecialParamEnum.RULE_ID.getOriginalStringCode(), request.getRuleId());
        NewTransResult newResult = new NewTransResult();
        newResult.setHttpMethod(HttpMethodEnum.GET);
        newResult.setBucketName(request.getBucketName());
        newResult.setParams(requestParameters);
        Response httpResponse = this.performRequest(newResult, true, false, false, false);
        this.verifyResponseContentType(httpResponse);
        GetCrrProgressResult result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.GetCrrProgressResultHandler.class, false).getReplicationConfiguration();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketCorsImpl(SetBucketCorsRequest request) throws ServiceException {
        String xml = request.getBucketCors() == null ? "" : this.getIConvertor(request.getBucketName()).transBucketCors(request.getBucketCors());
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Length", String.valueOf(xml.length()));
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketCors getBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketCors ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketCorsHandler.class, false).getConfiguration();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse deleteBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected HeaderResponse setBucketQuotaImpl(SetBucketQuotaRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String xml = request.getBucketQuota() == null ? "" : this.getIConvertor(request.getBucketName()).transBucketQuota(request.getBucketQuota());
        headers.put("Content-Length", String.valueOf(xml.length()));
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketQuota getBucketQuotaImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketQuota ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketQuotaHandler.class, false).getQuota();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketAclImpl(SetBucketAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor(request.getBucketName()).transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(request.getBucketName(), headers, request.getAcl());
        if (isExtraAclPutRequired) {
            String xml = request.getAcl() == null ? "" : this.getIConvertor(request.getBucketName()).transAccessControlList(request.getAcl(), true);
            headers.put("Content-Length", String.valueOf(xml.length()));
            headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
            entity = this.createRequestBody("application/xml", xml);
        }
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(entity);
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected AccessControlList getBucketAclImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketLoggingConfigurationImpl(SetBucketLoggingRequest request) throws ServiceException {
        if (request.getLoggingConfiguration().isLoggingEnabled() && request.isUpdateTargetACLifRequired() && this.getProviderCredentials().getLocalAuthType(request.getBucketName()) != AuthTypeEnum.OBS) {
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = "http://acs.amazonaws.com/groups/s3/LogDelivery";
            BaseBucketRequest getBucketAclRequest = new BaseBucketRequest(request.getLoggingConfiguration().getTargetBucketName());
            getBucketAclRequest.setRequesterPays(request.isRequesterPays());
            AccessControlList logBucketACL = this.getBucketAclImpl(getBucketAclRequest);
            for (GrantAndPermission gap : logBucketACL.getGrantAndPermissions()) {
                if (!(gap.getGrantee() instanceof GroupGrantee)) continue;
                GroupGrantee grantee = (GroupGrantee)gap.getGrantee();
                if (!groupIdentifier.equals(this.getIConvertor(request.getBucketName()).transGroupGrantee(grantee.getGroupGranteeType()))) continue;
                if (Permission.PERMISSION_WRITE.equals(gap.getPermission())) {
                    isSetLoggingGroupWrite = true;
                    continue;
                }
                if (!Permission.PERMISSION_READ_ACP.equals(gap.getPermission())) continue;
                isSetLoggingGroupReadACP = true;
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                if (log.isWarnEnabled()) {
                    log.warn("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now");
                }
                if (logBucketACL.getOwner() != null) {
                    logBucketACL.getOwner().setDisplayName(null);
                }
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                SetBucketAclRequest aclReqeust = new SetBucketAclRequest(request.getBucketName(), logBucketACL);
                aclReqeust.setRequesterPays(request.isRequesterPays());
                this.setBucketAclImpl(aclReqeust);
            } else if (log.isDebugEnabled()) {
                log.debug("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' has the necessary ACL settings");
            }
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        String xml = request.getLoggingConfiguration() == null ? "" : this.getIConvertor(request.getBucketName()).transBucketLoggingConfiguration(request.getLoggingConfiguration());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketLoggingConfiguration getBucketLoggingConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketLoggingConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLoggingHandler.class, false).getBucketLoggingStatus();
        this.setHeadersAndStatus(ret, httpResponse);
        return ret;
    }

    protected HeaderResponse setBucketDirectColdAccessImpl(SetBucketDirectColdAccessRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String xml = this.getIConvertor(request.getBucketName()).transBucketDirectColdAccess(request.getAccess());
        headers.put("Content-MD5", ServiceUtils.computeMD5(xml));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        result.setBody(this.createRequestBody("application/xml", xml));
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected BucketDirectColdAccess getBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(httpResponse);
        BucketDirectColdAccess result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketDirectColdAccessHandler.class, false).getBucketDirectColdAccess();
        this.setHeadersAndStatus(result, httpResponse);
        return result;
    }

    protected HeaderResponse deleteBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected BucketCustomDomainInfo getBucketCustomDomainImpl(GetBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        this.verifyResponseContentType(response);
        BucketCustomDomainInfo ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketCustomDomainHandler.class, true).getBucketTagInfo();
        this.setHeadersAndStatus(ret, response);
        return ret;
    }

    protected HeaderResponse setBucketCustomDomainImpl(SetBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), request.getDomainName());
        Map<String, String> headers = this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName()));
        NewTransResult result = this.transRequest(request);
        result.setParams(requestParams);
        result.setHeaders(headers);
        Response response = this.performRequest(result);
        return this.build(response);
    }

    protected HeaderResponse deleteBucketCustomDomainImpl(DeleteBucketCustomDomainRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.CUSTOMDOMAIN.getOriginalStringCode(), request.getDomainName());
        Response response = this.performRestDelete(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders(request.getBucketName())), request.getUserHeaders());
        return this.build(response);
    }

    protected CreateVirtualBucketResult createVirtualBucketImpl(CreateVirtualBucketRequest request) throws ServiceException {
        List<String> azTextIds = this.listAvailableZoneInfo(request.getRegionId(), request.getToken());
        this.createBucketWithClusterId(request, azTextIds);
        this.createBucketAliasImpl(request);
        this.bindBucketAliasImpl(request.getBucketName1(), request.getBucketAlias());
        this.bindBucketAliasImpl(request.getBucketName2(), request.getBucketAlias());
        this.setVirtualReplication(request.getAgencyId(), request.getBucketName1(), request.getBucketName2());
        this.setVirtualReplication(request.getAgencyId(), request.getBucketName2(), request.getBucketName1());
        CreateVirtualBucketResult result = new CreateVirtualBucketResult();
        result.setBucketName1(request.getBucketName1());
        result.setBucketName2(request.getBucketName2());
        result.setVirtualBucketName(request.getBucketAlias());
        result.setMessage("create virtual bucket success, virtualBucketName: " + request.getBucketAlias() + "bucketName1: " + request.getBucketName1() + ", bucketName2: " + request.getBucketName2());
        result.setStatusCode(HttpStatusCode.HTTP_OK.getCode());
        return result;
    }

    protected List<String> listAvailableZoneInfo(String regionId, String token) {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("regionId", regionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        NewTransResult result = new NewTransResult();
        result.setParams(requestParams);
        result.setHttpMethod(HttpMethodEnum.GET);
        result.setHeaders(headers);
        HashMap<String, String> userHeaders = new HashMap<String, String>();
        userHeaders.put("X-Auth-Token", token);
        result.setUserHeaders(userHeaders);
        result.setEncodeUrl(false);
        result.setObjectKey(RequestParamEnum.SERVICES_CLUSTERS.getOriginalStringCode());
        Response response = this.performRequest(result, true, false, false, true);
        this.verifyResponseContentTypeForJson(response);
        List azIds = JSONChange.readNodeFromJson(RestUtils.readBodyFromResponse(response)).get("infos").findValues("id");
        if (azIds.size() != 2) {
            throw new ServiceException("az info is not 2az.");
        }
        ArrayList<String> azTextIds = new ArrayList<String>();
        azTextIds.add(((JsonNode)azIds.get(0)).asText());
        azTextIds.add(((JsonNode)azIds.get(1)).asText());
        return azTextIds;
    }

    protected ListBucketAliasResult listAliasBucketsImpl() {
        try {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put(SpecialParamEnum.OBSBUCKETALIAS.getOriginalStringCode(), "");
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "application/json");
            Response response = this.performRestGetForListBuckets("", null, requestParams, headers);
            this.verifyResponseContentType(response);
            XmlResponsesSaxParser.ListBucketAliasHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.ListBucketAliasHandler.class, true);
            ListBucketAliasResult listBucketAliasResult = new ListBucketAliasResult(handler.getListBucketAlias(), handler.getBucketAliasOwner());
            this.setHeadersAndStatus(listBucketAliasResult, response);
            return listBucketAliasResult;
        }
        catch (Exception e) {
            throw new ObsException("get alias buckets  failed ", e.getMessage());
        }
    }

    protected void createBucketWithClusterId(CreateVirtualBucketRequest request, List<String> azIds) {
        String locationClusterGroupIdHeader = this.getProviderCredentials().getLocalAuthType("") != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-location-clustergroup-id";
        BucketMetadataInfoRequest bucketMetadataInfoRequest = new BucketMetadataInfoRequest();
        bucketMetadataInfoRequest.setBucketName(request.getBucketName1());
        String bucket1Id = "";
        String bucket2Id = "";
        try {
            GetBucketFSStatusResult bucket1Metadata = this.getBucketMetadataImpl(bucketMetadataInfoRequest);
            bucket1Id = bucket1Metadata.getOriginalHeaders().get(locationClusterGroupIdHeader).toString();
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                log.warn("Bucket is existed when create " + request.getBucketName1());
            }
            throw e;
        }
        try {
            bucketMetadataInfoRequest.setBucketName(request.getBucketName2());
            GetBucketFSStatusResult bucket2Metadata = this.getBucketMetadataImpl(bucketMetadataInfoRequest);
            bucket2Id = bucket2Metadata.getOriginalHeaders().get(locationClusterGroupIdHeader).toString();
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                log.warn("Bucket is existed when create " + request.getBucketName2());
            }
            throw e;
        }
        if (bucket1Id.isEmpty() && bucket2Id.isEmpty()) {
            this.createBucketWithClusterGroupId(locationClusterGroupIdHeader, request.getBucketName1(), request.getRegionId(), azIds.get(0));
            this.createBucketWithClusterGroupId(locationClusterGroupIdHeader, request.getBucketName2(), request.getRegionId(), azIds.get(1));
        } else if (bucket1Id.isEmpty()) {
            this.createBucketWithClusterGroupId(locationClusterGroupIdHeader, request.getBucketName1(), request.getRegionId(), bucket2Id.equals(azIds.get(0)) ? azIds.get(1) : azIds.get(0));
        } else if (bucket2Id.isEmpty()) {
            this.createBucketWithClusterGroupId(locationClusterGroupIdHeader, request.getBucketName2(), request.getRegionId(), bucket1Id.equals(azIds.get(0)) ? azIds.get(1) : azIds.get(0));
        } else if (bucket1Id.equals(bucket2Id)) {
            throw new ObsException("the two bucket is in same az");
        }
    }

    private void createBucketWithClusterGroupId(String locationClusterGroupIdHeader, String bucketName, String regionId, String azId) {
        CreateBucketRequest request = new CreateBucketRequest();
        request.setBucketName(bucketName);
        request.addUserHeaders(locationClusterGroupIdHeader, azId);
        request.setLocation(regionId);
        this.createBucketImpl(request);
    }

    protected void bindBucketAliasImpl(String bucketName, String bucketAlias) {
        try {
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/xml");
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put(SpecialParamEnum.OBSALIAS.getOriginalStringCode(), "");
            NewTransResult transResult = new NewTransResult();
            transResult.setHttpMethod(HttpMethodEnum.PUT);
            transResult.setParams(requestParams);
            transResult.setBucketName(bucketName);
            OBSXMLBuilder xmlBuilder = OBSXMLBuilder.create("AliasList");
            xmlBuilder.elem("Alias").t(bucketAlias);
            transResult.setBody(this.createRequestBody("application/xml", xmlBuilder.asString()));
            Request.Builder builder = this.setupConnection(transResult, false, false);
            this.renameMetadataKeys(bucketName, builder, httpHeaders);
            Response response = this.performRequest(builder.build(), requestParams, bucketName, true, true);
        }
        catch (Exception e) {
            throw new ObsException("bind bucket alias ", e.getMessage());
        }
    }

    protected void createBucketAliasImpl(CreateVirtualBucketRequest request) {
        try {
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/xml");
            HashMap<String, String> requestParams = new HashMap<String, String>();
            requestParams.put(SpecialParamEnum.OBSBUCKETALIAS.getOriginalStringCode(), "");
            NewTransResult transResult = new NewTransResult();
            transResult.setHttpMethod(HttpMethodEnum.PUT);
            transResult.setParams(requestParams);
            transResult.setBucketName(request.getBucketAlias());
            OBSXMLBuilder xmlBuilder = OBSXMLBuilder.create("CreateBucketAlias");
            xmlBuilder = xmlBuilder.elem("BucketList");
            xmlBuilder.elem("Bucket").t(request.getBucketName1());
            xmlBuilder.elem("Bucket").t(request.getBucketName2());
            transResult.setBody(this.createRequestBody("application/xml", xmlBuilder.asString()));
            Request.Builder builder = this.setupConnection(transResult, false, false);
            this.renameMetadataKeys(request.getBucketAlias(), builder, httpHeaders);
            Response response = this.performRequest(builder.build(), requestParams, request.getBucketAlias(), true, false);
        }
        catch (Exception e) {
            throw new ObsException("create bucket alias ", e.getMessage());
        }
    }

    protected void setVirtualReplication(String agencyId, String sourceBucketName, String destBucketName) {
        ReplicationConfiguration replicationConfiguration = new ReplicationConfiguration();
        ReplicationConfiguration.Rule rule = new ReplicationConfiguration.Rule();
        rule.setId(sourceBucketName + "_to_" + destBucketName);
        rule.setStatus(RuleStatusEnum.ENABLED);
        rule.setHistoricalObjectReplication(HistoricalObjectReplicationEnum.ENABLED);
        ReplicationConfiguration.Destination destination = new ReplicationConfiguration.Destination();
        destination.setBucket(destBucketName);
        destination.setObjectStorageClass(StorageClassEnum.STANDARD);
        rule.setDestination(destination);
        ArrayList<ReplicationConfiguration.Rule> rules = new ArrayList<ReplicationConfiguration.Rule>();
        rules.add(rule);
        replicationConfiguration.setRules(rules);
        replicationConfiguration.setAgency(agencyId);
        SetBucketReplicationRequest request = new SetBucketReplicationRequest(sourceBucketName, replicationConfiguration);
        this.setBucketReplicationConfigurationImpl(request);
    }
}

