/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.schemawiring;

import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.rules.OnValidationErrorStrategy;
import graphql.validation.rules.ValidationRules;
import graphql.validation.schemawiring.FieldValidatorDataFetcher;
import java.util.Locale;

@PublicApi
public class ValidationSchemaWiring
implements SchemaDirectiveWiring {
    private final ValidationRules ruleCandidates;

    public ValidationSchemaWiring(ValidationRules ruleCandidates) {
        this.ruleCandidates = ruleCandidates;
    }

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> env) {
        GraphQLFieldsContainer fieldsContainer = env.getFieldsContainer();
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        OnValidationErrorStrategy errorStrategy = this.ruleCandidates.getOnValidationErrorStrategy();
        MessageInterpolator messageInterpolator = this.ruleCandidates.getMessageInterpolator();
        Locale locale = this.ruleCandidates.getLocale();
        DataFetcher currentDF = env.getCodeRegistry().getDataFetcher(fieldsContainer, fieldDefinition);
        DataFetcher<Object> newDF = this.buildValidatingDataFetcher(errorStrategy, messageInterpolator, currentDF, locale);
        env.getCodeRegistry().dataFetcher(fieldsContainer, fieldDefinition, newDF);
        return fieldDefinition;
    }

    private DataFetcher<Object> buildValidatingDataFetcher(OnValidationErrorStrategy errorStrategy, MessageInterpolator messageInterpolator, DataFetcher<?> currentDF, Locale defaultLocale) {
        return new FieldValidatorDataFetcher(errorStrategy, messageInterpolator, currentDF, defaultLocale, this.ruleCandidates);
    }
}

