/*
 * Decompiled with CFR 0.152.
 */
package graphql.scalars.alias;

import graphql.Assert;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Locale;

@Internal
public final class AliasedScalar {
    private AliasedScalar() {
    }

    private static GraphQLScalarType aliasedScalarImpl(String name, String description, final GraphQLScalarType aliasedScalar) {
        Assert.assertNotNull((Object)aliasedScalar);
        Coercing<Object, Object> coercing = new Coercing<Object, Object>(){

            public Object serialize(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingSerializeException {
                return aliasedScalar.getCoercing().serialize(input, graphQLContext, locale);
            }

            public Object parseValue(Object input, GraphQLContext graphQLContext, Locale locale) throws CoercingParseValueException {
                return aliasedScalar.getCoercing().parseValue(input, graphQLContext, locale);
            }

            public Object parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext graphQLContext, Locale locale) throws CoercingParseLiteralException {
                return aliasedScalar.getCoercing().parseLiteral(input, variables, graphQLContext, locale);
            }

            public Value<?> valueToLiteral(Object input, GraphQLContext graphQLContext, Locale locale) {
                return aliasedScalar.getCoercing().valueToLiteral(input, graphQLContext, locale);
            }
        };
        return GraphQLScalarType.newScalar().name(name).description(description).coercing((Coercing)coercing).build();
    }

    public static class Builder {
        private String name;
        private String description;
        private GraphQLScalarType aliasedScalar;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder aliasedScalar(GraphQLScalarType aliasedScalar) {
            this.aliasedScalar = aliasedScalar;
            return this;
        }

        public GraphQLScalarType build() {
            Assert.assertNotNull((Object)this.name);
            return AliasedScalar.aliasedScalarImpl(this.name, this.description, this.aliasedScalar);
        }
    }
}

