/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GraphQLResponse {
    private final ResponseEntity<String> responseEntity;
    private final ObjectMapper mapper;
    private final ReadContext context;

    public GraphQLResponse(ResponseEntity<String> responseEntity, ObjectMapper objectMapper) {
        this.responseEntity = Objects.requireNonNull(responseEntity);
        this.mapper = Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(responseEntity.getBody(), () -> "Body is empty with status " + responseEntity.getStatusCodeValue());
        this.context = JsonPath.parse((String)((String)responseEntity.getBody()));
    }

    public JsonNode readTree() throws IOException {
        return this.mapper.readTree((String)this.responseEntity.getBody());
    }

    public String get(String path) {
        return this.get(path, String.class);
    }

    public <T> T get(String path, Class<T> type) {
        return (T)this.mapper.convertValue(this.context.read(path, Object.class, new Predicate[0]), type);
    }

    public <T> List<T> getList(String path, Class<T> type) {
        List raw = (List)this.context.read(path, List.class, new Predicate[0]);
        return (List)this.mapper.convertValue((Object)raw, (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, type));
    }

    public ReadContext context() {
        return this.context;
    }

    public boolean isOk() {
        return this.getStatusCode() == HttpStatus.OK;
    }

    public HttpStatus getStatusCode() {
        return this.responseEntity.getStatusCode();
    }

    public ResponseEntity<String> getRawResponse() {
        return this.responseEntity;
    }
}

