/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.io.IOException;
import java.util.Objects;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class GraphQLResponse {
    private ResponseEntity<String> responseEntity;
    private ObjectMapper mapper;
    private ReadContext context;

    public GraphQLResponse(ResponseEntity<String> responseEntity) {
        this.responseEntity = Objects.requireNonNull(responseEntity);
        this.mapper = new ObjectMapper();
        Objects.requireNonNull(responseEntity.getBody(), () -> "Body is empty with status " + responseEntity.getStatusCodeValue());
        this.context = JsonPath.parse((String)((String)responseEntity.getBody()));
    }

    public JsonNode readTree() throws IOException {
        return this.mapper.readTree((String)this.responseEntity.getBody());
    }

    public String get(String path) {
        return (String)this.context.read(path, new Predicate[0]);
    }

    public <T> T get(String path, Class<T> type) {
        return (T)this.context.read(path, type, new Predicate[0]);
    }

    public ReadContext context() {
        return this.context;
    }

    public boolean isOk() {
        return this.getStatusCode() == HttpStatus.OK;
    }

    public HttpStatus getStatusCode() {
        return this.responseEntity.getStatusCode();
    }

    public ResponseEntity<String> getRawResponse() {
        return this.responseEntity;
    }
}

