/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test.assertions;

import com.fasterxml.jackson.databind.JavaType;
import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.assertions.GraphQLBigDecimalAssert;
import com.graphql.spring.boot.test.assertions.GraphQLBigIntegerAssert;
import com.graphql.spring.boot.test.assertions.GraphQLBooleanAssert;
import com.graphql.spring.boot.test.assertions.GraphQLByteAssert;
import com.graphql.spring.boot.test.assertions.GraphQLGenericObjectAssert;
import com.graphql.spring.boot.test.assertions.GraphQLIntegerAssert;
import com.graphql.spring.boot.test.assertions.GraphQLListAssert;
import com.graphql.spring.boot.test.assertions.GraphQLLongAssert;
import com.graphql.spring.boot.test.assertions.GraphQLResponseAssertion;
import com.graphql.spring.boot.test.assertions.GraphQLShortAssert;
import com.graphql.spring.boot.test.assertions.GraphQLStringAssert;
import com.jayway.jsonpath.PathNotFoundException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.assertj.core.api.Assertions;

public class GraphQLFieldAssert
implements GraphQLResponseAssertion {
    public static final String EXPECTED_FIELD_S_TO_BE_PRESENT = "Expected field %s to be present.";
    public static final String EXPECTED_THAT_CONTENT_OF_FIELD_S_CAN_BE_CONVERTED_TO_S = "Expected that content of field %s can be converted to %s.";
    private final GraphQLResponse graphQLResponse;
    private final String jsonPath;

    public GraphQLFieldAssert isNotPresent() {
        try {
            this.graphQLResponse.getRaw(this.jsonPath);
            Assertions.fail((String)"Expected that field %s is not present.", (Object[])new Object[]{this.jsonPath});
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return this;
    }

    public GraphQLFieldAssert isNotPresentOrNull() {
        try {
            if (Objects.nonNull(this.graphQLResponse.getRaw(this.jsonPath))) {
                Assertions.fail((String)"Expected field %s to be null or not present.", (Object[])new Object[]{this.jsonPath});
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return this;
    }

    public GraphQLFieldAssert isNull() {
        try {
            if (Objects.nonNull(this.graphQLResponse.getRaw(this.jsonPath))) {
                Assertions.fail((String)"Expected field %s to be null.", (Object[])new Object[]{this.jsonPath});
            }
        }
        catch (PathNotFoundException e) {
            Assertions.fail((String)String.format(EXPECTED_FIELD_S_TO_BE_PRESENT, this.jsonPath), (Throwable)e);
        }
        return this;
    }

    public GraphQLFieldAssert isNotNull() {
        try {
            if (Objects.isNull(this.graphQLResponse.getRaw(this.jsonPath))) {
                Assertions.fail((String)"Expected field %s to be non-null.", (Object[])new Object[]{this.jsonPath});
            }
        }
        catch (PathNotFoundException e) {
            Assertions.fail((String)String.format(EXPECTED_FIELD_S_TO_BE_PRESENT, this.jsonPath), (Throwable)e);
        }
        return this;
    }

    public GraphQLBigDecimalAssert asBigDecimal() {
        return new GraphQLBigDecimalAssert(this.graphQLResponse, this.getFieldAs(BigDecimal.class));
    }

    public GraphQLBigIntegerAssert asBigInteger() {
        return new GraphQLBigIntegerAssert(this.graphQLResponse, this.getFieldAs(BigInteger.class));
    }

    public GraphQLLongAssert asLong() {
        return new GraphQLLongAssert(this.graphQLResponse, this.getFieldAs(Long.class));
    }

    public GraphQLIntegerAssert asInteger() {
        return new GraphQLIntegerAssert(this.graphQLResponse, this.getFieldAs(Integer.class));
    }

    public GraphQLShortAssert asShort() {
        return new GraphQLShortAssert(this.graphQLResponse, this.getFieldAs(Short.class));
    }

    public GraphQLByteAssert asByte() {
        return new GraphQLByteAssert(this.graphQLResponse, this.getFieldAs(Byte.class));
    }

    public GraphQLBooleanAssert asBoolean() {
        return new GraphQLBooleanAssert(this.graphQLResponse, this.getFieldAs(Boolean.class));
    }

    public GraphQLStringAssert asString() {
        return new GraphQLStringAssert(this.graphQLResponse, this.getFieldAs(String.class));
    }

    public <T> GraphQLGenericObjectAssert<T> as(Class<T> clazz) {
        return new GraphQLGenericObjectAssert<T>(this.graphQLResponse, this.getFieldAs(clazz));
    }

    public <T> GraphQLGenericObjectAssert<T> as(JavaType javaType) {
        return new GraphQLGenericObjectAssert<T>(this.graphQLResponse, this.getFieldAs(javaType));
    }

    public <T> GraphQLListAssert<T> asList(JavaType javaListType) {
        return new GraphQLListAssert(this.graphQLResponse, (List)this.getFieldAs(javaListType));
    }

    public <T> GraphQLListAssert<T> asListOf(Class<T> elementClass) {
        return new GraphQLListAssert<T>(this.graphQLResponse, this.getFieldAsList(elementClass));
    }

    @Override
    public GraphQLResponse and() {
        return this.graphQLResponse;
    }

    private <T> T getFieldAs(Class<T> targetClass) {
        try {
            return this.graphQLResponse.get(this.jsonPath, targetClass);
        }
        catch (PathNotFoundException e) {
            Assertions.fail((String)String.format(EXPECTED_FIELD_S_TO_BE_PRESENT, this.jsonPath), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)String.format(EXPECTED_THAT_CONTENT_OF_FIELD_S_CAN_BE_CONVERTED_TO_S, this.jsonPath, targetClass), (Throwable)e);
            return null;
        }
    }

    private <T> T getFieldAs(JavaType javaType) {
        try {
            return this.graphQLResponse.get(this.jsonPath, javaType);
        }
        catch (PathNotFoundException e) {
            Assertions.fail((String)String.format(EXPECTED_FIELD_S_TO_BE_PRESENT, this.jsonPath), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)String.format(EXPECTED_THAT_CONTENT_OF_FIELD_S_CAN_BE_CONVERTED_TO_S, this.jsonPath, javaType), (Throwable)e);
            return null;
        }
    }

    private <T> List<T> getFieldAsList(Class<T> targetClass) {
        try {
            return this.graphQLResponse.getList(this.jsonPath, targetClass);
        }
        catch (PathNotFoundException e) {
            Assertions.fail((String)String.format(EXPECTED_FIELD_S_TO_BE_PRESENT, this.jsonPath), (Throwable)e);
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            Assertions.fail((String)String.format(EXPECTED_THAT_CONTENT_OF_FIELD_S_CAN_BE_CONVERTED_TO_S, this.jsonPath, targetClass), (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Generated
    public GraphQLFieldAssert(GraphQLResponse graphQLResponse, String jsonPath) {
        this.graphQLResponse = graphQLResponse;
        this.jsonPath = jsonPath;
    }
}

