/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test.assertions;

import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.GraphQLTestError;
import com.graphql.spring.boot.test.assertions.GraphQLResponseAssertion;
import com.jayway.jsonpath.PathNotFoundException;
import graphql.GraphQLError;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ObjectAssertFactory;

public class GraphQLErrorListAssertion
extends FactoryBasedNavigableListAssert<GraphQLErrorListAssertion, List<? extends GraphQLError>, GraphQLError, ObjectAssert<GraphQLError>>
implements GraphQLResponseAssertion {
    private final GraphQLResponse graphQLResponse;

    public GraphQLErrorListAssertion(GraphQLResponse graphQLResponse) {
        super(GraphQLErrorListAssertion.getGraphQLErrors(graphQLResponse), GraphQLErrorListAssertion.class, (AssertFactory)new ObjectAssertFactory());
        this.graphQLResponse = graphQLResponse;
    }

    private static List<? extends GraphQLError> getGraphQLErrors(GraphQLResponse graphQLResponse) {
        List<GraphQLTestError> errorList = null;
        try {
            errorList = graphQLResponse.getList("$.errors", GraphQLTestError.class);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return errorList;
    }

    public GraphQLResponseAssertion hasNoErrors() {
        List<? extends GraphQLError> graphQLErrors = GraphQLErrorListAssertion.getGraphQLErrors(this.graphQLResponse);
        if (Objects.nonNull(graphQLErrors) && !graphQLErrors.isEmpty()) {
            String combinedMessage = graphQLErrors.stream().map(Object::toString).collect(Collectors.joining(System.lineSeparator()));
            Assertions.fail((String)String.format("Expected no GraphQL errors, but got %s: %s", graphQLErrors.size(), combinedMessage));
        }
        return this;
    }

    @Override
    public GraphQLResponse and() {
        return this.graphQLResponse;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQLErrorListAssertion)) {
            return false;
        }
        GraphQLErrorListAssertion other = (GraphQLErrorListAssertion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphQLResponse this$graphQLResponse = this.graphQLResponse;
        GraphQLResponse other$graphQLResponse = other.graphQLResponse;
        return !(this$graphQLResponse == null ? other$graphQLResponse != null : !this$graphQLResponse.equals(other$graphQLResponse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GraphQLErrorListAssertion;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GraphQLResponse $graphQLResponse = this.graphQLResponse;
        result = result * 59 + ($graphQLResponse == null ? 43 : $graphQLResponse.hashCode());
        return result;
    }
}

