/*
 * Decompiled with CFR 0.152.
 */
package com.graphql.spring.boot.test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphql.spring.boot.test.GraphQLResponse;
import com.graphql.spring.boot.test.SubscriptionState;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import lombok.Generated;
import lombok.NonNull;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.ResourceUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;

public class GraphQLTestSubscription {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLTestSubscription.class);
    private static final WebSocketContainer WEB_SOCKET_CONTAINER = ContainerProvider.getWebSocketContainer();
    private static final Duration ACKNOWLEDGEMENT_AND_CONNECTION_TIMEOUT = Duration.ofMinutes(1L);
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(1);
    private static final UriBuilderFactory URI_BUILDER_FACTORY = new DefaultUriBuilderFactory();
    private static final Object STATE_LOCK = new Object();
    public static final String PAYLOAD = "payload";
    private final Environment environment;
    private final ObjectMapper objectMapper;
    private final String subscriptionPath;
    private Session session;
    private SubscriptionState state = SubscriptionState.builder().id(ID_COUNTER.incrementAndGet()).build();

    public boolean isInitialized() {
        return this.state.isInitialized();
    }

    public boolean isAcknowledged() {
        return this.state.isAcknowledged();
    }

    public boolean isStarted() {
        return this.state.isStarted();
    }

    public boolean isStopped() {
        return this.state.isStopped();
    }

    public boolean isCompleted() {
        return this.state.isCompleted();
    }

    public GraphQLTestSubscription init() {
        this.init(null);
        return this;
    }

    public GraphQLTestSubscription init(@Nullable Object payload) {
        if (this.isInitialized()) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already initialized.");
        }
        try {
            this.initClient();
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.fail((String)"Could not initialize test subscription client. No subscription defined?", (Throwable)e);
        }
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "connection_init");
        message.set(PAYLOAD, this.getFinalPayload(payload));
        this.sendMessage(message);
        this.state.setInitialized(true);
        this.awaitAcknowledgement();
        log.debug("Subscription successfully initialized");
        return this;
    }

    public GraphQLTestSubscription start(@NonNull String graphQLResource) {
        if (graphQLResource == null) {
            throw new NullPointerException("graphQLResource is marked non-null but is null");
        }
        this.start(graphQLResource, null);
        return this;
    }

    public GraphQLTestSubscription start(@NonNull String graphQLResource, @Nullable Object variables) {
        if (graphQLResource == null) {
            throw new NullPointerException("graphQLResource is marked non-null but is null");
        }
        if (!this.isInitialized()) {
            this.init();
        }
        if (this.isStarted()) {
            org.junit.jupiter.api.Assertions.fail((String)"Start message already sent. To start a new subscription, please call reset first.");
        }
        this.state.setStarted(true);
        ObjectNode payload = this.objectMapper.createObjectNode();
        payload.put("query", this.loadQuery(graphQLResource));
        payload.set("variables", this.getFinalPayload(variables));
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "start");
        message.put("id", this.state.getId());
        message.set(PAYLOAD, (JsonNode)payload);
        log.debug("Sending start message.");
        this.sendMessage(message);
        return this;
    }

    public GraphQLTestSubscription stop() {
        if (!this.isInitialized()) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription not yet initialized.");
        }
        if (this.isStopped()) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already stopped.");
        }
        ObjectNode message = this.objectMapper.createObjectNode();
        message.put("type", "stop");
        message.put("id", this.state.getId());
        log.debug("Sending stop message.");
        this.sendMessage(message);
        try {
            log.debug("Closing web socket session.");
            this.session.close();
            this.awaitStop();
            log.debug("Web socket session closed.");
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Could not close web socket session", (Throwable)e);
        }
        return this;
    }

    public void reset() {
        if (this.isInitialized() && !this.isStopped()) {
            this.stop();
        }
        this.state = SubscriptionState.builder().id(ID_COUNTER.incrementAndGet()).build();
        this.session = null;
        log.debug("Test subscription client reset.");
    }

    @Deprecated
    public GraphQLResponse awaitAndGetNextResponse(int timeout) {
        return this.awaitAndGetNextResponse(Duration.ofMillis(timeout));
    }

    public GraphQLResponse awaitAndGetNextResponse(Duration timeout) {
        return this.awaitAndGetNextResponses(timeout, 1, true).get(0);
    }

    @Deprecated
    public GraphQLResponse awaitAndGetNextResponse(int timeout, boolean stopAfter) {
        return this.awaitAndGetNextResponse(Duration.ofMillis(timeout), stopAfter);
    }

    public GraphQLResponse awaitAndGetNextResponse(Duration timeout, boolean stopAfter) {
        return this.awaitAndGetNextResponses(timeout, 1, stopAfter).get(0);
    }

    @Deprecated
    public List<GraphQLResponse> awaitAndGetAllResponses(int timeToWait) {
        return this.awaitAndGetAllResponses(Duration.ofMillis(timeToWait));
    }

    public List<GraphQLResponse> awaitAndGetAllResponses(Duration timeToWait) {
        return this.awaitAndGetNextResponses(timeToWait, -1, true);
    }

    @Deprecated
    public List<GraphQLResponse> awaitAndGetAllResponses(int timeToWait, boolean stopAfter) {
        return this.awaitAndGetNextResponses(Duration.ofMillis(timeToWait), -1, stopAfter);
    }

    public List<GraphQLResponse> awaitAndGetAllResponses(Duration timeToWait, boolean stopAfter) {
        return this.awaitAndGetNextResponses(timeToWait, -1, stopAfter);
    }

    @Deprecated
    public List<GraphQLResponse> awaitAndGetNextResponses(int timeout, int numExpectedResponses) {
        return this.awaitAndGetNextResponses(Duration.ofMillis(timeout), numExpectedResponses, true);
    }

    public List<GraphQLResponse> awaitAndGetNextResponses(Duration timeout, int numExpectedResponses) {
        return this.awaitAndGetNextResponses(timeout, numExpectedResponses, true);
    }

    @Deprecated
    public List<GraphQLResponse> awaitAndGetNextResponses(int timeout, int numExpectedResponses, boolean stopAfter) {
        return this.awaitAndGetNextResponses(Duration.ofMillis(timeout), numExpectedResponses, stopAfter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GraphQLResponse> awaitAndGetNextResponses(Duration timeout, int numExpectedResponses, boolean stopAfter) {
        if (!this.isStarted()) {
            org.junit.jupiter.api.Assertions.fail((String)"Start message not sent. Please send start message first.");
        }
        if (this.isStopped()) {
            org.junit.jupiter.api.Assertions.fail((String)"Subscription already stopped. Forgot to call reset after test case?");
        }
        if (numExpectedResponses > 0) {
            Awaitility.await().atMost(timeout).until(() -> this.state.getResponses().size() >= numExpectedResponses);
        } else {
            try {
                Thread.sleep(timeout.toMillis());
            }
            catch (InterruptedException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Unable to wait the specified amount of time.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        if (stopAfter) {
            this.stop();
        }
        Object object = STATE_LOCK;
        synchronized (object) {
            Queue<GraphQLResponse> responses = this.state.getResponses();
            int responsesToPoll = responses.size();
            if (numExpectedResponses == 0) {
                ((AbstractCollectionAssert)Assertions.assertThat(responses).as(String.format("Expected no responses in %s, but received %s", timeout, responses.size()), new Object[0])).isEmpty();
            }
            if (numExpectedResponses > 0) {
                ((AbstractCollectionAssert)Assertions.assertThat(responses).as("Expected at least %d message(s) in %s, but %d received.", new Object[]{numExpectedResponses, timeout, responses.size()})).hasSizeGreaterThanOrEqualTo(numExpectedResponses);
                responsesToPoll = numExpectedResponses;
            }
            ArrayList<GraphQLResponse> responseList = new ArrayList<GraphQLResponse>();
            for (int i = 0; i < responsesToPoll; ++i) {
                responseList.add(responses.poll());
            }
            log.debug("Returning {} responses.", (Object)responseList.size());
            return responseList;
        }
    }

    @Deprecated
    public GraphQLTestSubscription waitAndExpectNoResponse(int timeToWait, boolean stopAfter) {
        this.waitAndExpectNoResponse(Duration.ofMillis(timeToWait), stopAfter);
        return this;
    }

    public GraphQLTestSubscription waitAndExpectNoResponse(Duration timeToWait, boolean stopAfter) {
        this.awaitAndGetNextResponses(timeToWait, 0, stopAfter);
        return this;
    }

    @Deprecated
    public GraphQLTestSubscription waitAndExpectNoResponse(int timeToWait) {
        return this.waitAndExpectNoResponse(Duration.ofMillis(timeToWait));
    }

    public GraphQLTestSubscription waitAndExpectNoResponse(Duration timeToWait) {
        this.awaitAndGetNextResponses(timeToWait, 0, true);
        return this;
    }

    public List<GraphQLResponse> getRemainingResponses() {
        if (!this.isStopped()) {
            org.junit.jupiter.api.Assertions.fail((String)"getRemainingResponses should only be called after the subscription was stopped.");
        }
        ArrayList<GraphQLResponse> graphQLResponses = new ArrayList<GraphQLResponse>(this.state.getResponses());
        this.state.getResponses().clear();
        return graphQLResponses;
    }

    private void initClient() throws IOException, DeploymentException {
        String port = this.environment.getProperty("local.server.port");
        URI uri = URI_BUILDER_FACTORY.builder().scheme("ws").host("localhost").port(port).path(this.subscriptionPath).build(new Object[0]);
        log.debug("Connecting to client at {}", (Object)uri);
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().configurator((ClientEndpointConfig.Configurator)new TestWebSocketClientConfigurator()).build();
        clientEndpointConfig.getUserProperties().put("org.apache.tomcat.websocket.IO_TIMEOUT_MS", String.valueOf(ACKNOWLEDGEMENT_AND_CONNECTION_TIMEOUT.toMillis()));
        this.session = WEB_SOCKET_CONTAINER.connectToServer((Endpoint)new TestWebSocketClient(this.state), clientEndpointConfig, uri);
        this.session.addMessageHandler((MessageHandler)new TestMessageHandler(this.objectMapper, this.state));
    }

    private JsonNode getFinalPayload(Object variables) {
        return (JsonNode)Optional.ofNullable(variables).map(arg_0 -> ((ObjectMapper)this.objectMapper).valueToTree(arg_0)).orElseGet(() -> ((ObjectMapper)this.objectMapper).createObjectNode());
    }

    private String loadQuery(String graphGLResource) {
        try {
            File file = ResourceUtils.getFile((String)("classpath:" + graphGLResource));
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)String.format("Test setup failure - could not load GraphQL resource: %s", graphGLResource), (Throwable)e);
            return "";
        }
    }

    private void sendMessage(Object message) {
        try {
            this.session.getBasicRemote().sendText(this.objectMapper.writeValueAsString(message));
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((String)"Test setup failure - cannot serialize subscription payload.", (Throwable)e);
        }
    }

    private void awaitAcknowledgement() {
        this.awaitAcknowledgementOrConnection(GraphQLTestSubscription::isAcknowledged, "Connection was acknowledged by the GraphQL server.");
    }

    private void awaitStop() {
        this.awaitAcknowledgementOrConnection(GraphQLTestSubscription::isStopped, "Connection was stopped in time.");
    }

    private void awaitAcknowledgementOrConnection(Predicate<GraphQLTestSubscription> condition, String timeoutDescription) {
        Awaitility.await((String)timeoutDescription).atMost(ACKNOWLEDGEMENT_AND_CONNECTION_TIMEOUT).until(() -> condition.test(this));
    }

    @Generated
    public GraphQLTestSubscription(Environment environment, ObjectMapper objectMapper, String subscriptionPath) {
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.subscriptionPath = subscriptionPath;
    }

    @Generated
    public Session getSession() {
        return this.session;
    }

    static class TestWebSocketClientConfigurator
    extends ClientEndpointConfig.Configurator {
        TestWebSocketClientConfigurator() {
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            super.beforeRequest(headers);
            headers.put("sec-websocket-protocol", Collections.singletonList("graphql-ws"));
        }
    }

    private static class TestWebSocketClient
    extends Endpoint {
        private final SubscriptionState state;

        public void onOpen(Session session, EndpointConfig config) {
            log.debug("Connection established.");
        }

        public void onClose(Session session, CloseReason closeReason) {
            super.onClose(session, closeReason);
            this.state.setStopped(true);
        }

        @Generated
        public TestWebSocketClient(SubscriptionState state) {
            this.state = state;
        }
    }

    static class TestMessageHandler
    implements MessageHandler.Whole<String> {
        private final ObjectMapper objectMapper;
        private final SubscriptionState state;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(String message) {
            try {
                String type;
                log.debug("Received message from web socket: {}", (Object)message);
                JsonNode jsonNode = this.objectMapper.readTree(message);
                JsonNode typeNode = jsonNode.get("type");
                ((IterableAssert)Assertions.assertThat((Iterable)typeNode).as("GraphQL messages should have a type field.", new Object[0])).isNotNull();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)typeNode.isNull()).as("GraphQL messages type should not be null.", new Object[0])).isFalse();
                switch (type = typeNode.asText()) {
                    case "complete": {
                        this.state.setCompleted(true);
                        log.debug("Subscription completed.");
                        break;
                    }
                    case "connection_ack": {
                        this.state.setAcknowledged(true);
                        log.debug("WebSocket connection acknowledged by the GraphQL Server.");
                        break;
                    }
                    case "data": 
                    case "error": {
                        JsonNode payload = jsonNode.get(GraphQLTestSubscription.PAYLOAD);
                        ((IterableAssert)Assertions.assertThat((Iterable)payload).as("Data/error messages must have a payload.", new Object[0])).isNotNull();
                        String payloadString = this.objectMapper.writeValueAsString((Object)payload);
                        GraphQLResponse graphQLResponse = new GraphQLResponse((ResponseEntity<String>)ResponseEntity.ok((Object)payloadString), this.objectMapper);
                        if (this.state.isStopped() || this.state.isCompleted()) {
                            log.debug("Response discarded because subscription was stopped or completed in the meanwhile.");
                            break;
                        }
                        Object object = STATE_LOCK;
                        synchronized (object) {
                            this.state.getResponses().add(graphQLResponse);
                        }
                        log.debug("New response recorded.");
                        break;
                    }
                }
            }
            catch (JsonProcessingException e) {
                org.junit.jupiter.api.Assertions.fail((String)"Exception while parsing server response. Response is not a valid GraphQL response.", (Throwable)e);
            }
        }

        @Generated
        public TestMessageHandler(ObjectMapper objectMapper, SubscriptionState state) {
            this.objectMapper = objectMapper;
            this.state = state;
        }
    }
}

