/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.web.boot;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.preparsed.PreparsedDocumentProvider;
import graphql.kickstart.execution.GraphQLObjectMapper;
import graphql.kickstart.execution.GraphQLQueryInvoker;
import graphql.kickstart.execution.config.DefaultExecutionStrategyProvider;
import graphql.kickstart.execution.config.ExecutionStrategyProvider;
import graphql.kickstart.execution.config.GraphQLServletObjectMapperConfigurer;
import graphql.kickstart.execution.config.ObjectMapperProvider;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.servlet.AbstractGraphQLHttpServlet;
import graphql.kickstart.servlet.GraphQLConfiguration;
import graphql.kickstart.servlet.GraphQLHttpServlet;
import graphql.kickstart.servlet.config.DefaultGraphQLSchemaServletProvider;
import graphql.kickstart.servlet.config.GraphQLSchemaServletProvider;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import graphql.kickstart.servlet.core.GraphQLServletListener;
import graphql.kickstart.servlet.core.GraphQLServletRootObjectBuilder;
import graphql.kickstart.servlet.input.BatchInputPreProcessor;
import graphql.kickstart.servlet.input.GraphQLInvocationInputFactory;
import graphql.kickstart.spring.error.ErrorHandlerSupplier;
import graphql.kickstart.spring.error.GraphQLErrorStartupListener;
import graphql.kickstart.spring.web.boot.GraphQLServletProperties;
import graphql.kickstart.spring.web.boot.OnSchemaOrSchemaProviderBean;
import graphql.kickstart.spring.web.boot.metrics.MetricsInstrumentation;
import graphql.kickstart.tools.boot.GraphQLJavaToolsAutoConfiguration;
import graphql.schema.GraphQLSchema;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnClass(value={DispatcherServlet.class})
@Conditional(value={OnSchemaOrSchemaProviderBean.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={GraphQLJavaToolsAutoConfiguration.class, JacksonAutoConfiguration.class})
@EnableConfigurationProperties(value={GraphQLServletProperties.class})
public class GraphQLWebAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(GraphQLWebAutoConfiguration.class);
    public static final String QUERY_EXECUTION_STRATEGY = "queryExecutionStrategy";
    public static final String MUTATION_EXECUTION_STRATEGY = "mutationExecutionStrategy";
    public static final String SUBSCRIPTION_EXECUTION_STRATEGY = "subscriptionExecutionStrategy";
    @Autowired
    private GraphQLServletProperties graphQLServletProperties;
    @Autowired(required=false)
    private List<GraphQLServletListener> listeners;
    @Autowired(required=false)
    private List<Instrumentation> instrumentations;
    @Autowired(required=false)
    private GraphQLErrorHandler errorHandler;
    private ErrorHandlerSupplier errorHandlerSupplier = new ErrorHandlerSupplier(null);
    @Autowired(required=false)
    private Map<String, ExecutionStrategy> executionStrategies;
    @Autowired(required=false)
    private GraphQLServletContextBuilder contextBuilder;
    @Autowired(required=false)
    private GraphQLServletRootObjectBuilder graphQLRootObjectBuilder;
    @Autowired(required=false)
    private GraphQLServletObjectMapperConfigurer objectMapperConfigurer;
    @Autowired(required=false)
    private PreparsedDocumentProvider preparsedDocumentProvider;
    @Autowired(required=false)
    private MultipartConfigElement multipartConfigElement;
    @Autowired(required=false)
    private BatchInputPreProcessor batchInputPreProcessor;

    @PostConstruct
    void postConstruct() {
        if (this.errorHandler != null) {
            this.errorHandlerSupplier.setErrorHandler(this.errorHandler);
        }
    }

    @Bean
    public GraphQLErrorStartupListener graphQLErrorStartupListener() {
        return new GraphQLErrorStartupListener(this.errorHandlerSupplier, this.graphQLServletProperties.isExceptionHandlersEnabled());
    }

    @Bean
    @ConditionalOnClass(value={CorsFilter.class})
    @ConditionalOnProperty(value={"graphql.servlet.corsEnabled"}, havingValue="true", matchIfMissing=true)
    public CorsFilter corsConfigurer() {
        LinkedHashMap<String, CorsConfiguration> corsConfigurations = new LinkedHashMap<String, CorsConfiguration>(1);
        CorsConfiguration corsConfiguration = new CorsConfiguration().applyPermitDefaultValues();
        corsConfigurations.put(this.graphQLServletProperties.getCorsMapping(), corsConfiguration);
        UrlBasedCorsConfigurationSource configurationSource = new UrlBasedCorsConfigurationSource();
        configurationSource.setCorsConfigurations(corsConfigurations);
        configurationSource.setAlwaysUseFullPath(true);
        return new CorsFilter((CorsConfigurationSource)configurationSource);
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLSchemaServletProvider graphQLSchemaProvider(GraphQLSchema schema) {
        return new DefaultGraphQLSchemaServletProvider(schema);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExecutionStrategyProvider executionStrategyProvider() {
        if (this.executionStrategies == null || this.executionStrategies.isEmpty()) {
            return new DefaultExecutionStrategyProvider((ExecutionStrategy)new AsyncExecutionStrategy(), null, (ExecutionStrategy)new SubscriptionExecutionStrategy());
        }
        if (this.executionStrategies.entrySet().size() == 1) {
            return new DefaultExecutionStrategyProvider((ExecutionStrategy)((Map.Entry)this.executionStrategies.entrySet().stream().findFirst().get()).getValue());
        }
        if (!this.executionStrategies.containsKey(QUERY_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (this.executionStrategies.size() == 2 && !this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && !this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY)) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        if (!(this.executionStrategies.size() < 3 || this.executionStrategies.containsKey(MUTATION_EXECUTION_STRATEGY) && this.executionStrategies.containsKey(SUBSCRIPTION_EXECUTION_STRATEGY))) {
            this.throwIncorrectExecutionStrategyNameException();
        }
        return new DefaultExecutionStrategyProvider(this.executionStrategies.get(QUERY_EXECUTION_STRATEGY), this.executionStrategies.get(MUTATION_EXECUTION_STRATEGY), this.executionStrategies.get(SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    private void throwIncorrectExecutionStrategyNameException() {
        throw new IllegalStateException(String.format("When defining more than one execution strategy, they must be named %s, %s, or %s", QUERY_EXECUTION_STRATEGY, MUTATION_EXECUTION_STRATEGY, SUBSCRIPTION_EXECUTION_STRATEGY));
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLInvocationInputFactory invocationInputFactory(GraphQLSchemaServletProvider schemaProvider) {
        GraphQLInvocationInputFactory.Builder builder = GraphQLInvocationInputFactory.newBuilder((GraphQLSchemaServletProvider)schemaProvider);
        if (this.graphQLRootObjectBuilder != null) {
            builder.withGraphQLRootObjectBuilder(this.graphQLRootObjectBuilder);
        }
        if (this.contextBuilder != null) {
            builder.withGraphQLContextBuilder(this.contextBuilder);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLQueryInvoker queryInvoker(ExecutionStrategyProvider executionStrategyProvider) {
        GraphQLQueryInvoker.Builder builder = GraphQLQueryInvoker.newBuilder().withExecutionStrategyProvider(executionStrategyProvider);
        if (this.instrumentations != null) {
            this.instrumentations.sort((a, b) -> a instanceof MetricsInstrumentation ? 1 : 0);
            builder.with(this.instrumentations);
        }
        if (this.preparsedDocumentProvider != null) {
            builder.withPreparsedDocumentProvider(this.preparsedDocumentProvider);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLObjectMapper graphQLObjectMapper(ObjectProvider<ObjectMapperProvider> objectMapperProviderObjectProvider) {
        GraphQLObjectMapper.Builder builder = GraphQLObjectMapper.newBuilder();
        builder.withGraphQLErrorHandler((Supplier)this.errorHandlerSupplier);
        ObjectMapperProvider objectMapperProvider = (ObjectMapperProvider)objectMapperProviderObjectProvider.getIfAvailable();
        if (objectMapperProvider != null) {
            builder.withObjectMapperProvider(objectMapperProvider);
        } else if (this.objectMapperConfigurer != null) {
            builder.withObjectMapperConfigurer(this.objectMapperConfigurer);
        }
        log.info("Building GraphQLObjectMapper including errorHandler: {}", (Object)this.errorHandler);
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"graphql.servlet.use-default-objectmapper"}, havingValue="true", matchIfMissing=true)
    public ObjectMapperProvider objectMapperProvider(ObjectMapper objectMapper) {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ObjectMapper.class, (Object)objectMapper);
        objectMapper.setInjectableValues((InjectableValues)injectableValues);
        return () -> objectMapper;
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLConfiguration graphQLServletConfiguration(GraphQLInvocationInputFactory invocationInputFactory, GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper) {
        return GraphQLConfiguration.with((GraphQLInvocationInputFactory)invocationInputFactory).with(queryInvoker).with(graphQLObjectMapper).with(this.listeners).with(this.graphQLServletProperties.isAsyncModeEnabled()).with(this.graphQLServletProperties.getSubscriptionTimeout()).with(this.batchInputPreProcessor).with(this.graphQLServletProperties.getContextSetting()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public GraphQLHttpServlet graphQLHttpServlet(GraphQLConfiguration graphQLConfiguration) {
        return GraphQLHttpServlet.with((GraphQLConfiguration)graphQLConfiguration);
    }

    @Bean
    public ServletRegistrationBean<AbstractGraphQLHttpServlet> graphQLServletRegistrationBean(AbstractGraphQLHttpServlet servlet) {
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, new String[]{this.graphQLServletProperties.getServletMapping()});
        registration.setMultipartConfig(this.multipartConfigElement());
        return registration;
    }

    private MultipartConfigElement multipartConfigElement() {
        return Optional.ofNullable(this.multipartConfigElement).orElse(new MultipartConfigElement(""));
    }
}

