/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import com.oembedler.moon.graphql.boot.GraphQLServletProperties;
import com.oembedler.moon.graphql.boot.GraphQLWebsocketAutoConfiguration;
import com.oembedler.moon.graphql.boot.metrics.MetricsInstrumentation;
import com.oembedler.moon.graphql.boot.metrics.TracingNoResolversInstrumentation;
import com.oembedler.moon.graphql.boot.metrics.WebsocketMetrics;
import graphql.analysis.MaxQueryComplexityInstrumentation;
import graphql.analysis.MaxQueryDepthInstrumentation;
import graphql.execution.instrumentation.tracing.TracingInstrumentation;
import graphql.servlet.GraphQLWebsocketServlet;
import io.micrometer.core.instrument.MeterRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={MetricsAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, GraphQLWebsocketAutoConfiguration.class})
@ConditionalOnProperty(value={"graphql.servlet.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={GraphQLServletProperties.class})
public class GraphQLInstrumentationAutoConfiguration {
    @Value(value="${graphql.servlet.maxQueryComplexity:#{null}}")
    private Integer maxQueryComplexity;
    @Value(value="${graphql.servlet.maxQueryDepth:#{null}}")
    private Integer maxQueryDepth;
    @Value(value="${graphql.servlet.tracing-enabled:'false'}")
    private String tracingEnabled;

    @Bean
    @ConditionalOnMissingBean(value={TracingInstrumentation.class, MetricsInstrumentation.class})
    @ConditionalOnExpression(value="${graphql.servlet.tracing-enabled:'false'}.equals('metrics-only')|| ${graphql.servlet.tracing-enabled:'false'}.equals(true)")
    public TracingInstrumentation tracingInstrumentation() {
        return new TracingInstrumentation();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnExpression(value="${graphql.servlet.actuator-metrics:false}&& ${graphql.servlet.tracing-enabled:'false'}.toString().equals('false')")
    public TracingNoResolversInstrumentation tracingNoResolversInstrumentation() {
        return new TracingNoResolversInstrumentation();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"graphql.servlet.max-query-complexity"})
    public MaxQueryComplexityInstrumentation maxQueryComplexityInstrumentation() {
        return new MaxQueryComplexityInstrumentation(this.maxQueryComplexity.intValue());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(value={"graphql.servlet.max-query-depth"})
    public MaxQueryDepthInstrumentation maxQueryDepthInstrumentation() {
        return new MaxQueryDepthInstrumentation(this.maxQueryDepth.intValue());
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.servlet.actuator-metrics"}, havingValue="true")
    @ConditionalOnBean(value={MeterRegistry.class, TracingInstrumentation.class})
    @ConditionalOnMissingBean
    public MetricsInstrumentation metricsInstrumentation(MeterRegistry meterRegistry) {
        return new MetricsInstrumentation(meterRegistry, Boolean.TRUE.toString().equals(this.tracingEnabled));
    }

    @Bean
    @ConditionalOnProperty(value={"graphql.servlet.actuator-metrics"}, havingValue="true")
    @ConditionalOnBean(value={MeterRegistry.class, GraphQLWebsocketServlet.class})
    @ConditionalOnMissingBean
    public WebsocketMetrics websocketMetrics(MeterRegistry meterRegistry, GraphQLWebsocketServlet websocketServlet) {
        return new WebsocketMetrics(meterRegistry, websocketServlet);
    }
}

