/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot.error;

import com.oembedler.moon.graphql.boot.error.GraphQLErrorFactory;
import com.oembedler.moon.graphql.boot.error.Throwables;
import graphql.GraphQLError;
import graphql.servlet.GenericGraphQLError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

class ReflectiveGraphQLErrorFactory
implements GraphQLErrorFactory {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveGraphQLErrorFactory.class);
    private Object object;
    private Method method;
    private Throwables throwables;

    ReflectiveGraphQLErrorFactory(Object object, Method method) {
        this.object = object;
        this.method = method;
        this.throwables = new Throwables(method.getAnnotation(ExceptionHandler.class).value());
    }

    @Override
    public Optional<Class<? extends Throwable>> mostConcrete(Throwable t) {
        return this.throwables.mostConcrete(t);
    }

    @Override
    public GraphQLError create(Throwable t) {
        try {
            this.method.setAccessible(true);
            return (GraphQLError)this.method.invoke(this.object, t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Cannot create GraphQLError from throwable {}", (Object)t.getClass().getSimpleName(), (Object)e);
            return new GenericGraphQLError(t.getMessage());
        }
    }
}

