/*
 * Decompiled with CFR 0.152.
 */
package com.oembedler.moon.graphql.boot;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="graphql.servlet")
public class GraphQLServletProperties {
    private String mapping;
    private boolean asyncModeEnabled = false;
    private boolean exceptionHandlersEnabled = false;
    private long subscriptionTimeout = 0L;

    public String getMapping() {
        return this.mapping != null ? this.mapping : "/graphql";
    }

    private boolean mappingIsServletWildcard() {
        return this.getMapping().endsWith("/*");
    }

    private boolean mappingIsAntWildcard() {
        return this.getMapping().endsWith("/**");
    }

    public String getServletMapping() {
        String mapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return mapping.replaceAll("\\*$", "");
        }
        if (this.mappingIsServletWildcard()) {
            return mapping;
        }
        return mapping.endsWith("/") ? mapping + "*" : mapping + "/*";
    }

    public String getCorsMapping() {
        String mapping = this.getMapping();
        if (this.mappingIsAntWildcard()) {
            return mapping;
        }
        if (this.mappingIsServletWildcard()) {
            return mapping + "*";
        }
        return mapping.endsWith("/") ? mapping + "**" : mapping + "/**";
    }

    public void setMapping(String mapping) {
        this.mapping = mapping;
    }

    public boolean isAsyncModeEnabled() {
        return this.asyncModeEnabled;
    }

    public void setAsyncModeEnabled(boolean asyncModeEnabled) {
        this.asyncModeEnabled = asyncModeEnabled;
    }

    public boolean isExceptionHandlersEnabled() {
        return this.exceptionHandlersEnabled;
    }

    public void setExceptionHandlersEnabled(boolean exceptionHandlersEnabled) {
        this.exceptionHandlersEnabled = exceptionHandlersEnabled;
    }

    public long getSubscriptionTimeout() {
        return this.subscriptionTimeout;
    }

    public void setSubscriptionTimeout(long subscriptionTimeout) {
        this.subscriptionTimeout = subscriptionTimeout;
    }
}

