/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.autoconfigure.editor;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;

public class PropertyGroupReader {
    private final Environment environment;
    private final String prefix;
    private Properties props;

    public PropertyGroupReader(Environment environment, String prefix) {
        this.environment = Objects.requireNonNull(environment);
        this.prefix = Optional.ofNullable(prefix).orElse("");
    }

    public Properties load() {
        if (this.props == null) {
            this.props = new Properties();
            this.loadProps();
        }
        return this.props;
    }

    private void loadProps() {
        this.streamOfPropertySources().forEach(propertySource -> Arrays.stream(propertySource.getPropertyNames()).filter(this::isWanted).forEach(key -> this.add((EnumerablePropertySource<Object>)propertySource, (String)key)));
    }

    private Stream<EnumerablePropertySource<Object>> streamOfPropertySources() {
        if (this.environment instanceof ConfigurableEnvironment) {
            Iterator iterator = ((ConfigurableEnvironment)this.environment).getPropertySources().iterator();
            Iterable iterable = () -> iterator;
            return StreamSupport.stream(iterable.spliterator(), false).filter(EnumerablePropertySource.class::isInstance).map(EnumerablePropertySource.class::cast);
        }
        return Stream.empty();
    }

    private String withoutPrefix(String key) {
        return key.replace(this.prefix, "");
    }

    private boolean isWanted(String key) {
        return key.startsWith(this.prefix);
    }

    private void add(EnumerablePropertySource<Object> propertySource, String key) {
        this.props.put(this.withoutPrefix(key), propertySource.getProperty(key));
    }
}

