/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.GraphQLError;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import org.springframework.web.bind.annotation.ExceptionHandler;

class ReflectiveMethodValidator {
    static boolean isGraphQLExceptionHandler(Method method) {
        return method.isAnnotationPresent(ExceptionHandler.class) && (ReflectiveMethodValidator.isGraphQLErrorReturnType(method) || ReflectiveMethodValidator.hasGraphQLErrorCollectionReturnType(method));
    }

    private static boolean isGraphQLErrorReturnType(Method method) {
        return GraphQLError.class.isAssignableFrom(method.getReturnType());
    }

    private static boolean hasGraphQLErrorCollectionReturnType(Method method) {
        ParameterizedType collectionType;
        if (Collection.class.isAssignableFrom(method.getReturnType()) && (collectionType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments().length == 1) {
            return GraphQLError.class.isAssignableFrom((Class)collectionType.getActualTypeArguments()[0]);
        }
        return false;
    }

    private ReflectiveMethodValidator() {
    }
}

