/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.GraphQLError;
import graphql.kickstart.execution.error.GenericGraphQLError;
import graphql.kickstart.spring.error.ErrorContext;
import graphql.kickstart.spring.error.GraphQLErrorFactory;
import graphql.kickstart.spring.error.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;

class ReflectiveGraphQLErrorFactory
implements GraphQLErrorFactory {
    private static final Logger log = LoggerFactory.getLogger(ReflectiveGraphQLErrorFactory.class);
    private final boolean singularReturnType;
    private Object object;
    private Method method;
    private Throwables throwables;

    ReflectiveGraphQLErrorFactory(Object object, Method method) {
        this.object = object;
        this.method = method;
        this.singularReturnType = GraphQLError.class.isAssignableFrom(method.getReturnType());
        this.throwables = new Throwables(method.getAnnotation(ExceptionHandler.class).value());
    }

    @Override
    public Optional<Class<? extends Throwable>> mostConcrete(Throwable t) {
        return this.throwables.mostConcrete(t);
    }

    @Override
    public Collection<GraphQLError> create(Throwable t, ErrorContext errorContext) {
        try {
            this.method.setAccessible(true);
            if (this.singularReturnType) {
                return Collections.singletonList((GraphQLError)this.method.invoke(this.object, t));
            }
            return (Collection)this.method.invoke(this.object, t);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("Cannot create GraphQLError from throwable {}", (Object)t.getClass().getSimpleName(), (Object)e);
            return Collections.singletonList(new GenericGraphQLError(t.getMessage()));
        }
    }
}

