/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution.subscriptions.apollo;

import graphql.ExecutionResult;
import graphql.kickstart.execution.GraphQLInvoker;
import graphql.kickstart.execution.GraphQLRequest;
import graphql.kickstart.execution.input.GraphQLSingleInvocationInput;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionInvocationInputFactory;
import graphql.kickstart.execution.subscriptions.GraphQLSubscriptionMapper;
import graphql.kickstart.execution.subscriptions.SubscriptionSession;
import graphql.kickstart.execution.subscriptions.apollo.ApolloSubscriptionConnectionListener;
import graphql.kickstart.execution.subscriptions.apollo.OperationMessage;
import graphql.kickstart.execution.subscriptions.apollo.SubscriptionCommand;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionStartCommand
implements SubscriptionCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubscriptionStartCommand.class);
    private final GraphQLSubscriptionMapper mapper;
    private final GraphQLSubscriptionInvocationInputFactory invocationInputFactory;
    private final GraphQLInvoker graphQLInvoker;
    private final Collection<ApolloSubscriptionConnectionListener> connectionListeners;

    @Override
    public void apply(SubscriptionSession session, OperationMessage message) {
        log.debug("Apollo subscription start: {} --> {}", (Object)session, message.getPayload());
        this.connectionListeners.forEach(it -> it.onStart(session, message));
        CompletableFuture<ExecutionResult> executionResult = this.executeAsync(message.getPayload(), session);
        executionResult.thenAccept(result -> this.handleSubscriptionStart(session, message.getId(), (ExecutionResult)result));
    }

    private CompletableFuture<ExecutionResult> executeAsync(Object payload, SubscriptionSession session) {
        Objects.requireNonNull(payload, "Payload is required");
        GraphQLRequest graphQLRequest = this.mapper.convertGraphQLRequest(payload);
        GraphQLSingleInvocationInput invocationInput = this.invocationInputFactory.create(graphQLRequest, session);
        return this.graphQLInvoker.executeAsync(invocationInput);
    }

    private void handleSubscriptionStart(SubscriptionSession session, String id, ExecutionResult executionResult) {
        ExecutionResult sanitizedExecutionResult = this.mapper.sanitizeErrors(executionResult);
        if (this.mapper.hasNoErrors(sanitizedExecutionResult)) {
            session.subscribe(id, (Publisher<ExecutionResult>)((Publisher)sanitizedExecutionResult.getData()));
        } else {
            Map<String, Object> payload = this.mapper.convertSanitizedExecutionResult(sanitizedExecutionResult);
            session.sendMessage(new OperationMessage(OperationMessage.Type.GQL_ERROR, id, payload));
        }
    }

    @Generated
    public SubscriptionStartCommand(GraphQLSubscriptionMapper mapper, GraphQLSubscriptionInvocationInputFactory invocationInputFactory, GraphQLInvoker graphQLInvoker, Collection<ApolloSubscriptionConnectionListener> connectionListeners) {
        this.mapper = mapper;
        this.invocationInputFactory = invocationInputFactory;
        this.graphQLInvoker = graphQLInvoker;
        this.connectionListeners = connectionListeners;
    }
}

