/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import graphql.introspection.IntrospectionQuery;
import graphql.kickstart.execution.ExtensionsDeserializer;
import graphql.kickstart.execution.OperationNameExtractor;
import graphql.kickstart.execution.VariablesDeserializer;
import java.util.HashMap;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GraphQLRequest {
    private String query;
    @JsonDeserialize(using=VariablesDeserializer.class)
    private Map<String, Object> variables = new HashMap<String, Object>();
    @JsonDeserialize(using=ExtensionsDeserializer.class)
    private Map<String, Object> extensions = new HashMap<String, Object>();
    private String operationName;

    public GraphQLRequest() {
    }

    public GraphQLRequest(String query, Map<String, Object> variables, Map<String, Object> extensions, String operationName) {
        this.query = query;
        this.operationName = operationName;
        if (extensions != null) {
            this.extensions = extensions;
        }
        if (variables != null) {
            this.variables = variables;
        }
    }

    public static GraphQLRequest createIntrospectionRequest() {
        return new GraphQLRequest(IntrospectionQuery.INTROSPECTION_QUERY, new HashMap<String, Object>(), new HashMap<String, Object>(), "IntrospectionQuery");
    }

    public static GraphQLRequest createQueryOnlyRequest(String query) {
        return new GraphQLRequest(query, new HashMap<String, Object>(), new HashMap<String, Object>(), null);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, Object> variables) {
        if (variables != null) {
            this.variables = variables;
        }
    }

    public Map<String, Object> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(Map<String, Object> extensions) {
        if (extensions != null) {
            this.extensions = extensions;
        }
    }

    public String getOperationName() {
        return OperationNameExtractor.extractOperationName(this.query, this.operationName, null);
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }
}

