/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.execution;

import graphql.ExecutionResult;
import graphql.kickstart.execution.DecoratedExecutionResult;
import graphql.kickstart.execution.GraphQLBatchedQueryResult;
import graphql.kickstart.execution.GraphQLErrorQueryResult;
import graphql.kickstart.execution.GraphQLSingleQueryResult;
import java.util.Collections;
import java.util.List;

public interface GraphQLQueryResult {
    public static GraphQLSingleQueryResult create(ExecutionResult result) {
        return new GraphQLSingleQueryResult(new DecoratedExecutionResult(result));
    }

    public static GraphQLBatchedQueryResult create(List<ExecutionResult> results) {
        return new GraphQLBatchedQueryResult(results);
    }

    public static GraphQLErrorQueryResult createError(int statusCode, String message) {
        return new GraphQLErrorQueryResult(statusCode, message);
    }

    public boolean isBatched();

    public boolean isAsynchronous();

    default public DecoratedExecutionResult getResult() {
        return null;
    }

    default public List<ExecutionResult> getResults() {
        return Collections.emptyList();
    }

    default public boolean isError() {
        return false;
    }

    default public int getStatusCode() {
        return 200;
    }

    default public String getMessage() {
        return null;
    }
}

