/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.graphiql.boot;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.graphiql.boot.GraphiQLProperties;
import graphql.kickstart.graphiql.boot.PropertyGroupReader;
import graphql.kickstart.graphiql.boot.PropsLoader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class GraphiQLController {
    private static final Logger log = LoggerFactory.getLogger(GraphiQLController.class);
    private static final String CDNJS_CLOUDFLARE_COM_AJAX_LIBS = "//cdnjs.cloudflare.com/ajax/libs/";
    private static final String CDN_JSDELIVR_NET_NPM = "//cdn.jsdelivr.net/npm/";
    private static final String GRAPHIQL = "graphiql";
    private static final String FAVICON_GRAPHQL_ORG = "//graphql.org/img/favicon.png";
    @Autowired
    private Environment environment;
    @Autowired
    private GraphiQLProperties graphiQLProperties;
    private String template;
    private String props;
    private Properties headerProperties;

    public void onceConstructed() throws IOException {
        this.loadTemplate();
        this.loadProps();
        this.loadHeaders();
    }

    private void loadTemplate() throws IOException {
        try (InputStream inputStream = new ClassPathResource("graphiql.html").getInputStream();){
            this.template = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
    }

    private void loadProps() throws IOException {
        this.props = new PropsLoader(this.environment).load();
    }

    private void loadHeaders() {
        PropertyGroupReader propertyReader = new PropertyGroupReader(this.environment, "graphiql.headers.");
        this.headerProperties = propertyReader.load();
    }

    public byte[] graphiql(String contextPath, @PathVariable Map<String, String> params, Object csrf) {
        if (csrf != null) {
            CsrfToken csrfToken = (CsrfToken)csrf;
            this.headerProperties.setProperty(csrfToken.getHeaderName(), csrfToken.getToken());
        }
        Map<String, String> replacements = this.getReplacements(this.constructGraphQlEndpoint(contextPath, params), contextPath + this.graphiQLProperties.getEndpoint().getSubscriptions(), contextPath + this.graphiQLProperties.getSTATIC().getBasePath());
        String populatedTemplate = StringSubstitutor.replace((Object)this.template, replacements);
        return populatedTemplate.getBytes(Charset.defaultCharset());
    }

    private Map<String, String> getReplacements(String graphqlEndpoint, String subscriptionsEndpoint, String staticBasePath) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("graphqlEndpoint", graphqlEndpoint);
        replacements.put("subscriptionsEndpoint", subscriptionsEndpoint);
        replacements.put("staticBasePath", staticBasePath);
        replacements.put("pageTitle", this.graphiQLProperties.getPageTitle());
        replacements.put("pageFavicon", this.getResourceUrl(staticBasePath, "favicon.ico", FAVICON_GRAPHQL_ORG));
        replacements.put("es6PromiseJsUrl", this.getResourceUrl(staticBasePath, "es6-promise.auto.min.js", this.joinCdnjsPath("es6-promise", "4.1.1", "es6-promise.auto.min.js")));
        replacements.put("fetchJsUrl", this.getResourceUrl(staticBasePath, "fetch.min.js", this.joinCdnjsPath("fetch", "2.0.4", "fetch.min.js")));
        replacements.put("reactJsUrl", this.getResourceUrl(staticBasePath, "react.min.js", this.joinCdnjsPath("react", "16.8.3", "umd/react.production.min.js")));
        replacements.put("reactDomJsUrl", this.getResourceUrl(staticBasePath, "react-dom.min.js", this.joinCdnjsPath("react-dom", "16.8.3", "umd/react-dom.production.min.js")));
        replacements.put("graphiqlCssUrl", this.getResourceUrl(staticBasePath, "graphiql.min.css", this.joinJsDelivrPath(GRAPHIQL, this.graphiQLProperties.getCdn().getVersion(), "graphiql.css")));
        replacements.put("graphiqlJsUrl", this.getResourceUrl(staticBasePath, "graphiql.min.js", this.joinJsDelivrPath(GRAPHIQL, this.graphiQLProperties.getCdn().getVersion(), "graphiql.min.js")));
        replacements.put("subscriptionsTransportWsBrowserClientUrl", this.getResourceUrl(staticBasePath, "subscriptions-transport-ws-browser-client.js", this.joinJsDelivrPath("subscriptions-transport-ws", "0.8.3", "browser/client.js")));
        replacements.put("graphiqlSubscriptionsFetcherBrowserClientUrl", this.getResourceUrl(staticBasePath, "graphiql-subscriptions-fetcher-browser-client.js", this.joinJsDelivrPath("graphiql-subscriptions-fetcher", "0.0.2", "browser/client.js")));
        replacements.put("props", this.props);
        try {
            replacements.put("headers", new ObjectMapper().writeValueAsString((Object)this.headerProperties));
        }
        catch (JsonProcessingException e) {
            log.error("Cannot serialize headers", (Throwable)e);
        }
        replacements.put("subscriptionClientTimeout", String.valueOf(this.graphiQLProperties.getSubscriptions().getTimeout() * 1000));
        replacements.put("subscriptionClientReconnect", String.valueOf(this.graphiQLProperties.getSubscriptions().isReconnect()));
        replacements.put("editorThemeCss", this.getEditorThemeCssURL());
        return replacements;
    }

    private String getEditorThemeCssURL() {
        String theme = this.graphiQLProperties.getProps().getVariables().getEditorTheme();
        if (theme != null) {
            return String.format("https://cdnjs.cloudflare.com/ajax/libs/codemirror/%s/theme/%s.min.css", this.graphiQLProperties.getCodeMirror().getVersion(), theme.split("\\s")[0]);
        }
        return "";
    }

    private String getResourceUrl(String staticBasePath, String staticFileName, String cdnUrl) {
        if (this.graphiQLProperties.getCdn().isEnabled() && StringUtils.isNotBlank((CharSequence)cdnUrl)) {
            return cdnUrl;
        }
        return this.joinStaticPath(staticBasePath, staticFileName);
    }

    private String joinStaticPath(String staticBasePath, String staticFileName) {
        return staticBasePath + "vendor/graphiql/" + staticFileName;
    }

    private String joinCdnjsPath(String library, String cdnVersion, String cdnFileName) {
        return CDNJS_CLOUDFLARE_COM_AJAX_LIBS + library + "/" + cdnVersion + "/" + cdnFileName;
    }

    private String joinJsDelivrPath(String library, String cdnVersion, String cdnFileName) {
        return CDN_JSDELIVR_NET_NPM + library + "@" + cdnVersion + "/" + cdnFileName;
    }

    private String constructGraphQlEndpoint(String contextPath, @RequestParam Map<String, String> params) {
        String endpoint = this.graphiQLProperties.getEndpoint().getGraphql();
        for (Map.Entry<String, String> param : params.entrySet()) {
            endpoint = endpoint.replaceAll("\\{" + param.getKey() + "}", param.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)contextPath) && !endpoint.startsWith(contextPath)) {
            return contextPath + endpoint;
        }
        return endpoint;
    }
}

