/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.graphiql.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.kickstart.graphiql.boot.PropertyGroupReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

class PropsLoader {
    private static final String GRAPHIQL_PROPS_PREFIX = "graphiql.props.";
    private static final String GRAPHIQL_PROPS_RESOURCES_PREFIX = "graphiql.props.resources.";
    private static final String GRAPHIQL_PROPS_VALUES_PREFIX = "graphiql.props.variables.";
    private Environment environment;

    PropsLoader(Environment environment) {
        this.environment = environment;
    }

    String load() throws IOException {
        PropertyGroupReader reader = new PropertyGroupReader(this.environment, GRAPHIQL_PROPS_VALUES_PREFIX);
        Properties props = reader.load();
        ObjectMapper objectMapper = new ObjectMapper();
        this.loadPropFromResource("defaultQuery").ifPresent(it -> props.put("defaultQuery", it));
        this.loadPropFromResource("query").ifPresent(it -> props.put("query", it));
        this.loadPropFromResource("variables").ifPresent(it -> props.put("variables", it));
        return objectMapper.writeValueAsString((Object)props);
    }

    private Optional<String> loadPropFromResource(String prop) throws IOException {
        String property = GRAPHIQL_PROPS_RESOURCES_PREFIX + prop;
        if (this.environment.containsProperty(property)) {
            String location = this.environment.getProperty(property);
            ClassPathResource resource = new ClassPathResource(location);
            return Optional.of(this.loadResource((Resource)resource));
        }
        return Optional.empty();
    }

    private String loadResource(Resource resource) throws IOException {
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

