/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.mavenplugin;

import com.graphql_java_generator.mavenplugin.AbstractCommonMojo;
import com.graphql_java_generator.plugin.conf.CustomScalarDefinition;
import com.graphql_java_generator.plugin.conf.GenerateCodeCommonConfiguration;
import com.graphql_java_generator.plugin.conf.QueryMutationExecutionProtocol;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractGenerateCodeCommonMojo
extends AbstractCommonMojo
implements GenerateCodeCommonConfiguration {
    int nbGeneratedClasses = 0;
    @Parameter(property="com.graphql_java_generator.mavenplugin.copyRuntimeSources", defaultValue="false")
    boolean copyRuntimeSources;
    @Parameter(property="com.graphql_java_generator.mavenplugin.customScalars")
    List<CustomScalarDefinition> customScalars = null;
    @Parameter(property="com.graphql_java_generator.mavenplugin.packageName", defaultValue="com.generated.graphql")
    String packageName;
    @Parameter(property="com.graphql_java_generator.mavenplugin.queryMutationExecutionProtocol", defaultValue="http")
    QueryMutationExecutionProtocol queryMutationExecutionProtocol;
    @Parameter(property="com.graphql_java_generator.mavenplugin.separateUtilityClasses", defaultValue="true")
    boolean separateUtilityClasses;
    @Parameter(property="com.graphql_java_generator.mavenplugin.sourceEncoding", defaultValue="UTF-8")
    String sourceEncoding;
    @Parameter(property="com.graphql_java_generator.mavenplugin.springBeanSuffix", defaultValue="")
    String springBeanSuffix;
    @Parameter(property="com.graphql_java_generator.mavenplugin.targetResourceFolder", defaultValue="./target/generated-resources/graphql-maven-plugin")
    File targetResourceFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.targetSourceFolder", defaultValue="./target/generated-sources/graphql-maven-plugin")
    File targetSourceFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.useJakartaEE9", defaultValue="false")
    boolean useJakartaEE9;

    public List<CustomScalarDefinition> getCustomScalars() {
        return this.customScalars;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public QueryMutationExecutionProtocol getQueryMutationExecutionProtocol() {
        return this.queryMutationExecutionProtocol;
    }

    public String getSourceEncoding() {
        return this.sourceEncoding;
    }

    public String getSpringBeanSuffix() {
        return this.springBeanSuffix;
    }

    public File getTargetFolder() {
        return new File(this.project.getBasedir(), "target");
    }

    public File getTargetClassFolder() {
        return new File(this.getTargetFolder(), "classes");
    }

    public File getTargetResourceFolder() {
        return this.targetResourceFolder;
    }

    public File getTargetSourceFolder() {
        return this.targetSourceFolder;
    }

    public boolean isCopyRuntimeSources() {
        return this.copyRuntimeSources;
    }

    public boolean isSeparateUtilityClasses() {
        return this.separateUtilityClasses;
    }

    public boolean isAddRelayConnections() {
        return this.addRelayConnections;
    }

    public boolean isUseJakartaEE9() {
        return this.useJakartaEE9;
    }

    protected AbstractGenerateCodeCommonMojo(Class<?> springConfigurationClass) {
        super(springConfigurationClass);
    }

    @Override
    protected void executePostExecutionTask() throws IOException {
        String generatedSourceFolder = this.getTargetSourceFolder().getAbsolutePath();
        this.getLog().debug((CharSequence)("Adding the generated source folder: " + generatedSourceFolder));
        this.project.addCompileSourceRoot(generatedSourceFolder);
        this.buildContext.refresh(this.getTargetSourceFolder());
        this.getLog().debug((CharSequence)("compileSourceRoots: " + String.join((CharSequence)", ", this.project.getCompileSourceRoots())));
        this.projectHelper.addResource(this.project, this.getTargetResourceFolder().getAbsolutePath(), Arrays.asList("**/*"), null);
        this.buildContext.refresh(this.getTargetResourceFolder());
    }
}

