/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.mavenplugin;

import com.graphql_java_generator.plugin.PluginExecutor;
import com.graphql_java_generator.plugin.conf.CommonConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class AbstractCommonMojo
extends AbstractMojo
implements CommonConfiguration {
    @Component
    protected BuildContext buildContext;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter(property="com.graphql_java_generator.mavenplugin.addRelayConnections", defaultValue="false")
    boolean addRelayConnections;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(property="com.graphql_java_generator.mavenplugin.schemaFileFolder", defaultValue="src/main/resources")
    File schemaFileFolder;
    @Parameter(property="com.graphql_java_generator.mavenplugin.schemaFilePattern", defaultValue="*.graphqls")
    String schemaFilePattern;
    @Parameter(property="com.graphql_java_generator.mavenplugin.skipGenerationIfSchemaHasNotChanged", defaultValue="true")
    boolean skipGenerationIfSchemaHasNotChanged;
    @Parameter(property="com.graphql_java_generator.mavenplugin.templates")
    Map<String, String> templates;
    protected final Class<?> springConfigurationClass;
    protected AnnotationConfigApplicationContext ctx;

    public File getProjectDir() {
        return this.project.getBasedir();
    }

    public File getSchemaFileFolder() {
        return this.schemaFileFolder;
    }

    public String getSchemaFilePattern() {
        return this.schemaFilePattern;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public boolean isSkipGenerationIfSchemaHasNotChanged() {
        return this.skipGenerationIfSchemaHasNotChanged;
    }

    AbstractCommonMojo(Class<?> springConfigurationClass) {
        this.springConfigurationClass = springConfigurationClass;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        try {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).debug("Starting generation of java classes from graphqls files");
            this.ctx = new AnnotationConfigApplicationContext();
            this.ctx.getBeanFactory().registerSingleton("mojo", (Object)this);
            this.ctx.register(new Class[]{this.springConfigurationClass});
            this.ctx.refresh();
            ((CommonConfiguration)this.ctx.getBean(CommonConfiguration.class)).logConfiguration();
            PluginExecutor executor = (PluginExecutor)this.ctx.getBean(PluginExecutor.class);
            executor.execute();
            this.executePostExecutionTask();
            this.ctx.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected void executePostExecutionTask() throws IOException {
    }
}

