/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.graphql.GraphQlSourceBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ComponentScan.Filter;
import org.springframework.core.io.ClassPathResource;
import org.springframework.graphql.execution.ClassNameTypeResolver;
import org.springframework.graphql.execution.GraphQlSource;

#if($configuration.generateJPAAnnotation)
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
#end

import com.graphql_java_generator.server.util.GraphqlServerUtils;

/**
 * @author generated by graphql-java-generator
 * @see <a href="https://github.com/graphql-java-generator/graphql-java-generator">https://github.com/graphql-java-generator/graphql-java-generator</a>
 */
@SpringBootApplication()
@ComponentScan(
		basePackages = { "${configuration.packageName}", "com.graphql_java_generator.server", "com.graphql_java_generator.util" ${configuration.quotedScanBasePackages}},
		// To allow Controller overriding, the controller are declared as @Controller (mandatory for the AnnotatedControllerResolver), 
		// but they must be found by the autoconfiguration class to allow them to be overriding.
		// So we prevent the default component scan to find them. They will be available as default bean in GraphQLPluginAutoConfiguration 
		excludeFilters = {@Filter(type = FilterType.REGEX, pattern = "${packageUtilName}\\.[^.]*Controller") })
#if($configuration.generateJPAAnnotation)
@EnableJpaRepositories(basePackages = { "${configuration.packageName}", "com.graphql_java_generator" ${configuration.quotedScanBasePackages} })
@EntityScan(basePackages = { "${configuration.packageName}", "com.graphql_java_generator" ${configuration.quotedScanBasePackages} })
#end
@EnableConfigurationProperties
@SuppressWarnings("unused")
public class GraphQLServerMain#if(${configuration.packaging}=="war") extends SpringBootServletInitializer#end {

	@Autowired
	protected ApplicationContext applicationContext;

	@Autowired
	GraphqlServerUtils graphqlServerUtils;

#if($packaging=="war")
	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
		return application.sources(GraphQLServerMain.class);
	}
#end

	@SuppressWarnings("resource")
	public static void main(String[] args) {
		SpringApplication.run(GraphQLServerMain.class, args);
	}

#if($configuration.parserOptions && $configuration.parserOptions.maxTokens)
	public GraphQLServerMain() {
		// Configuration of the GraphQL schema parser, from the project configuration
		ParserOptions newDefault = ParserOptions.newParserOptions().maxTokens(${configuration.parserOptions.maxTokens}).build();
		ParserOptions.setDefaultParserOptions(newDefault);
	}
#end

	/**
	 * This {@link GraphQlSourceBuilderCustomizer} configures stuff that is mandatory for plugin. Other 
	 * {@link GraphQlSourceBuilderCustomizer} may be registered to add other customization to the spring 
	 * {@link GraphQlSource}. The only constraint is that other such beans must have different names.
	 * 
	 * @return
	 */
	@Bean
	public GraphQlSourceBuilderCustomizer defaultSourceBuilderCustomizer() {
		ClassNameTypeResolver classNameTypeResolver = new ClassNameTypeResolver();
		classNameTypeResolver.setClassNameExtractor((cls) -> {
			return this.graphqlServerUtils.classNameExtractor(cls);
		});
		return (builder) -> builder.defaultTypeResolver(classNameTypeResolver);
	}
}
