##
## Velocity template for the executor of a Subscription type (client side). 
##
## The generated class contains:
## - All the utility classes that allow to prepare and execute the subscription
##
##
## This template has these inputs:
## packageUtilName 			The package where this class must be generated
## configuration		The plugin's configuration
## object					The subscription type, for which this executor is being generated
##
#################################################################################################################
## Import of common.vm  (commons Velocity macro and definitions)
#################################################################################################################
#parse ("templates/common.vm")
##
##
/** Generated by the default template from graphql-java-generator */
package ${packageUtilName};
##
## The inputParams macro lists the input parameters for a field
#macro(inputParams)
#foreach ($inputParameter in $field.inputParameters)
#appliedDirectives(${inputParameter.appliedDirectives}, "			")
			${inputParameter.javaTypeFullClassname} ${inputParameter.javaName},
#end
#end
##
## The inputValues macro lists the input values for the parameters for a field
#macro(inputValues)#foreach ($inputParameter in $field.inputParameters), ${inputParameter.javaName}#end#end
##
##
##
#if($configuration.generateDeprecatedRequestResponse)
#set ($executionResponse = "${object.name}Response")
#else
#set ($executionResponse = "${configuration.packageName}.${object.classSimpleName}")
#end

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.graphql.client.GraphQlClient;
import org.springframework.stereotype.Component;
import com.graphql_java_generator.annotation.GraphQLDirective;
import com.graphql_java_generator.annotation.GraphQLNonScalar;
import com.graphql_java_generator.annotation.GraphQLScalar;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import com.graphql_java_generator.exception.GraphQLRequestPreparationException;
import com.graphql_java_generator.util.GraphqlUtils;
import com.graphql_java_generator.client.GraphqlClientUtils;
import com.graphql_java_generator.client.GraphQLObjectMapper;
import com.graphql_java_generator.client.GraphQLSubscriptionExecutor;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.request.InputParameter;
import com.graphql_java_generator.client.request.InputParameter.InputParameterType;
import com.graphql_java_generator.client.request.ObjectResponse;

#foreach($import in ${object.importsForUtilityClasses})
import $import;
#end

/**
#if ($object.description)
#foreach ($line in $object.description.lines)
 * ${line}
#end
#end
 * 
 * This class contains the methods that allows the execution of the subscriptions that are defined in the ${object.name} of the GraphQL schema.<BR/>
 * These methods allows:
 * <UL>
 * <LI>Preparation of partial subscription requests</LI>
 * <LI>Execution of partial prepared subscription requests</LI>
 * <LI>Execution of partial direct subscription requests</LI>
 * </UL>
 * You'll find all the documentation on the <A HREF="https://github.com/graphql-java-generator/graphql-maven-plugin-project/wiki/client_spring">client page doc</A>.
 * 
 * @author generated by graphql-java-generator
 */
@Component
@SuppressWarnings("unused")
public class ${object.name}Executor${springBeanSuffix}  implements GraphQLSubscriptionExecutor {

	/** Logger for this class */
	private static Logger logger = LoggerFactory.getLogger(${object.name}Executor${springBeanSuffix}.class);

	@Autowired
	@Qualifier("webSocketGraphQlClient${springBeanSuffix}")
	GraphQlClient graphQlClient;

	GraphqlUtils graphqlUtils = GraphqlUtils.graphqlUtils; // must be set that way, to be used in the constructor
	
	@Autowired
	GraphqlClientUtils graphqlClientUtils;

	public ${object.name}Executor${springBeanSuffix}() {
## The @..@ is the placeholder for the maven resource filtering
		if (!"2.7".equals(this.graphqlUtils.getRuntimeVersion())) { //$NON-NLS-1$
			throw new RuntimeException("The GraphQL runtime version doesn't match the GraphQL plugin version. The runtime's version is '" //$NON-NLS-1$
					+ this.graphqlUtils.getRuntimeVersion() 
					+ "' whereas the GraphQL plugin version is '2.7'"); //$NON-NLS-1$
		}
		CustomScalarRegistryInitializer.initCustomScalarRegistry();
		DirectiveRegistryInitializer.initDirectiveRegistry();
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a subscription executor, the provided request must be a subscription full request. It may <B>only return one 
	 * subscription's field</B>.<BR/>
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 * 
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the 
	 *      *    returned type for the ${field.name} subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 * 	        Map<String, Object> params = new HashMap<>();
	 *          params.put("param", paramValue);   // param is optional, as it is marked by a "?" in the request
	 *          params.put("skip", Boolean.FALSE); // skip is mandatory, as it is marked by a "&" in the request
	 *          
	 *          subscriptionClient = subscriptionExecutor.execWithBindValues(
	 *              "subscription { sampleSubscriptionField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}",
	 *              callback,
	 *              params);
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param queryResponseDef
	 *            The response definition of the ${object.requestType}, in the native GraphQL format (see here above). It's a full
	 *            request, as you would write it in graphiql. Is must include the subscription keyword.
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the class of the 
	 *            subscription, that is the GraphQL type of the subscription's field that is subscribed.
	 * @param parameters
	 *            The map of values, for the bind variables defined in the query. If there is no bind variable in the
	 *            defined Query, this argument may be null or an empty {@link Map}. The key is the parameter name, as
	 *            defined in the query (in the above sample: heroParam is an optional parameter and skip is a mandatory
	 *            one). The value is the parameter vale in its Java type (for instance a {@link Date} for the
	 *            {@link GraphQLScalarTypeDate}). The parameters which value is missing in this map will no be
	 *            transmitted toward the GraphQL server.
	 * @return
	 *            The {@link SubscriptionClient} that allows the caller to act on the subscribed subscription.
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public SubscriptionClient execWithBindValues(
			String queryResponseDef, 
			SubscriptionCallback<?> subscriptionCallback,
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} {} ", queryResponseDef); //$NON-NLS-1$
		ObjectResponse objectResponse = getResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return exec(objectResponse, subscriptionCallback, parameters);
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a subscription executor, the provided request must be a subscription full request. It may <B>only return one 
	 * subscription's field</B>.<BR/>
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 * 
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the 
	 *      *    returned type for the ${field.name} subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 *         subscriptionClient = subscriptionExecutor.execWithBindValues(
	 *             "subscription { sampleSubscriptionField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}",
	 *             callback,
	 *             "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *             "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *             );
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param queryResponseDef
	 *            The response definition of the ${object.requestType}, in the native GraphQL format (see here above). It's a full
	 *            request, as you would write it in graphiql. Is must include the subscription keyword.
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the class of the 
	 *            subscription, that is the GraphQL type of the subscription's field that is subscribed. 	
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters: it must be a series of name and values :
	 *            (paramName1, paramValue1, paramName2, paramValue2...)
	 * @return
	 *            The {@link SubscriptionClient} that allows the caller to act on the subscribed subscription.
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public SubscriptionClient exec(
			String queryResponseDef, 
			SubscriptionCallback<?> subscriptionCallback,
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing ${object.requestType} {} ", queryResponseDef); //$NON-NLS-1$
		ObjectResponse objectResponse = getResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return execWithBindValues(objectResponse, subscriptionCallback, this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a subscription executor, the provided request must be a subscription full request. It may <B>only return one 
	 * subscription's field</B>.<BR/>
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = subscriptionExecutor
	 *             .getResponseBuilder()
	 *             .withQueryResponseDef("subscription { sampleSubscriptionField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}")
	 *             .build();
	 *     }
	 *     
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the 
	 *      *    returned type for the ${field.name} subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 * 	        Map<String, Object> params = new HashMap<>();
	 *          params.put("param", paramValue);   // param is optional, as it is marked by a "?" in the request
	 *          params.put("skip", Boolean.FALSE); // skip is mandatory, as it is marked by a "&" in the request
	 *          
	 *          subscriptionClient = subscriptionExecutor.execWithBindValues(
	 *              preparedRequest,
	 *              callback,
	 *              params);
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link getGraphQLRequest(String)} method or one of the <code>getXxxxGraphQLRequest(String)</code> methods.
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the class of the 
	 *            subscription, that is the GraphQL type of the subscription's field that is subscribed. 	
	 * @param parameters
	 *            The map of values, for the bind variables defined in the query. If there is no bind variable in the
	 *            defined Query, this argument may be null or an empty {@link Map}
	 * @return
	 *            The {@link SubscriptionClient} that allows the caller to act on the subscribed subscription.
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	@SuppressWarnings({ "unchecked", "static-method" })
	public SubscriptionClient execWithBindValues(
			ObjectResponse objectResponse, 
			SubscriptionCallback<?> subscriptionCallback,
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException {
		if (logger.isTraceEnabled()) {
			if (parameters == null) {
				logger.trace("Executing ${object.requestType} without parameters"); //$NON-NLS-1$
			} else {
				StringBuilder sb = new StringBuilder("Executing root ${object.requestType} with parameters: "); //$NON-NLS-1$
				boolean addComma = false;
				for (String key : parameters.keySet()) {
					sb.append(key).append(":").append(parameters.get(key)); //$NON-NLS-1$
					if (addComma)
						sb.append(", "); //$NON-NLS-1$
					addComma = true;
				}
				logger.trace(sb.toString());
			}
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing ${object.requestType} '${object.name}'"); //$NON-NLS-1$
		}

		// Given values for the BindVariables
		Map<String, Object> parametersLocal = (parameters != null) ? parameters : new HashMap<>();

		// The subscription may only subscribe to one subscription at a time, even for a full request.
		// Let's check that, and find the type returned by this subscription (that is: the type of the notifications
		// that will be received)
		//
		// The subscription must query only one subscription
		if (objectResponse.getQuery() != null || objectResponse.getMutation() != null) {
			throw new GraphQLRequestExecutionException(
					"This method may only be called for subscription, but the given GraphQL request is a " //$NON-NLS-1$
							+ (objectResponse.getQuery() != null ? "query" : "mutation")); //$NON-NLS-1$ //$NON-NLS-2$
		}
		if (objectResponse.getSubscription() == null) {
			throw new GraphQLRequestExecutionException(
					"This method may only be called for subscription, but the given GraphQL request has no mutation field"); //$NON-NLS-1$
		}
		if (objectResponse.getSubscription().getFields().size() != 1) {
			throw new GraphQLRequestExecutionException(
					"Full Request for subscription may only be called for one subscription, but the given GraphQL request has " //$NON-NLS-1$
							+ objectResponse.getSubscription().getFields().size() + " subscription fields"); //$NON-NLS-1$
		}
		
		// It's probably possible to do much better than this switch!  
		// If someone has a better idea to call this parameterized method, please come in.
		switch (objectResponse.getSubscription().getFields().get(0).getName()) {
#foreach ($field in $object.fields)
#if ($field.name != "__typename")
		case "${field.name}": //$NON-NLS-1$
			return objectResponse.exec(parametersLocal,
					 (SubscriptionCallback<#if($field.fieldTypeAST.listDepth>0)List#else${field.javaTypeFullClassname}#end>) subscriptionCallback, 
					 ${executionResponse}.class, 
					 #if($field.fieldTypeAST.listDepth>0)List#else${field.javaTypeFullClassname}#end.class);
#end
#end
		default:
			throw new GraphQLRequestExecutionException("Unexpected field name: " + objectResponse.getSubscription().getFields().get(0).getName()); //$NON-NLS-1$
		}
	}

	/**
	 * This method takes a <B>full request</B> definition, and executes it against the GraphQL server. As this class is 
	 * a subscription executor, the provided request must be a subscription full request. It may <B>only return one 
	 * subscription's field</B>.<BR/>
	 * You must also provide a callback instance of the {@link SubscriptionCallback}, that will be called each time a message
	 * or an error is sent by this subscribed subscription.<br/>
	 * It offers a logging of the call (if in debug mode), or of the call and its parameters (if in trace mode).<BR/>
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     public void setup() {
	 *         // Preparation of the query, so that it is prepared once then executed several times
	 *         preparedRequest = subscriptionExecutor
	 *             .getResponseBuilder()
	 *             .withQueryResponseDef("subscription { sampleSubscriptionField(param: ?param)  {subfield1 @skip(if: &skip) subfield2 {id name}}}")
	 *             .build();
	 *     }
	 *     
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the 
	 *      *    returned type for the ${field.name} subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 *          subscriptionClient = subscriptionExecutor.exec(
	 *              preparedRequest,
	 *              callback,
	 *              "param", paramValue,   // param is optional, as it is marked by a "?" in the request
	 *              "skip", Boolean.FALSE // skip is mandatory, as it is marked by a "&" in the request
	 *              );
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link getGraphQLRequest(String)} method or one of the <code>getXxxxGraphQLRequest(String)</code> methods.
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the class of the 
	 *            subscription, that is the GraphQL type of the subscription's field that is subscribed. 	
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters: it must be a series of name and values :
	 *            (paramName1, paramValue1, paramName2, paramValue2...)
	 * @return
	 *            The {@link SubscriptionClient} that allows the caller to act on the subscribed subscription.
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
	public SubscriptionClient exec(
			ObjectResponse objectResponse, 
			SubscriptionCallback<?> subscriptionCallback,
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException {
		return execWithBindValues(objectResponse, subscriptionCallback, this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

	/**
	 * Get the {@link com.graphql_java_generator.client.request.Builder} for a <B>full request</B>, as expected by the exec 
	 * and execWithBindValues methods.
	 * 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public com.graphql_java_generator.client.request.Builder getResponseBuilder() throws GraphQLRequestPreparationException {
		return new com.graphql_java_generator.client.request.Builder(this.graphQlClient, GraphQLRequest${springBeanSuffix}.class);
	}

	/**
	 * Get the {@link GraphQLRequest${springBeanSuffix}}, to obtain a prepared <B>full request</B>. For instance:
	 * <PRE>
	 * GraphQLRequest${springBeanSuffix} request = new GraphQLRequest${springBeanSuffix}(fullRequest);
	 * </PRE>
	 * 
	 * @param fullRequest The full GraphQL request, as specified in the GraphQL specification
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	@SuppressWarnings("static-method")
	public GraphQLRequest${springBeanSuffix} getGraphQLRequest(String fullRequest) throws GraphQLRequestPreparationException {
		return new GraphQLRequest${springBeanSuffix}(fullRequest);
	}

#foreach ($field in $object.fields)
#if ($field.name != "__typename")
##
##
##
##
#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method registers a subscription, by executing a direct partial ${field.name} subscription against the GraphQL server. 
	 * This subscription is one of the fields defined in the GraphQL subscription object. The queryResponseDef contains the
	 * part of the subscription that <B><U>is after</U></B> the subscription name (see the sample below), for instance
	 * "{id name}" if you want these two fields to be sent in the notifications you'll receive for this
	 * subscription.<BR/>
	 * You must also provide a callback instance that will be called each time a message
	 * or an error is sent by this subscribed subscription. As the plugin limits the actual subscriptions at one par call (one
	 * field from the ${object.name} GraphQL type), it allows the deserialization of this exact field. So the callback is expected 
	 * to be an instance of <code>SubscriptionCallback<${field.type.classSimpleName}></code>, as the <code>${object.name}.${field.name}</code> 
	 * is of type <code>${field.type.classSimpleName}</code>. 
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 * 
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the returned type for the ${field.name} 
	 * 	    *    subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 * 	        Map<String, Object> params = new HashMap<>();
	 * 	        params.put("anOptionalParam", "a param value");
	 * 
	 * 	        subscriptionClient = subscriptionExecutor.${field.javaName}WithBindValues(
	 * 			    "{ list of the expected subfields for the ${field.name} subscription (empty list for scalars) }",
	 * 			    callback, 
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              // Optionally, bind variables values may or must be provided, if you've defined any in your query.
	 *              // This method allows you to provide them as a map (which is may be null or empty, if no bind 
	 *              // variables were defined in the request)
	 *              params);
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param queryResponseDef
	 *            The response definition of the subscription, in the native GraphQL format (see here above)
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the ${field.name}
	 *            subscription field.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the subscription. If there is no bind variable in the
	 *            defined subscription, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
#appliedDirectives(${field.appliedDirectives}, "	")
	public SubscriptionClient ${field.javaName}WithBindValues(
			String queryResponseDef, 
			SubscriptionCallback<${field.javaTypeFullClassname}> subscriptionCallback,
#inputParams()
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		ObjectResponse objectResponse = get${field.pascalCaseName}ResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return ${field.javaName}(objectResponse, subscriptionCallback#inputValues(), parameters);
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method registers a subscription, by executing a direct partial ${field.name} subscription against the GraphQL server. 
	 * This subscription is one of the fields defined in the GraphQL subscription object. The queryResponseDef contains the
	 * part of the subscription that <B><U>is after</U></B> the subscription name (see the sample below), for instance
	 * "{id name}" if you want these two fields to be sent in the notifications you'll receive for this
	 * subscription.<BR/>
	 * You must also provide a callback instance that will be called each time a message
	 * or an error is sent by this subscribed subscription. As the plugin limits the actual subscriptions at one par call (one
	 * field from the ${object.name} GraphQL type), it allows the deserialization of this exact field. So the callback is expected 
	 * to be an instance of <code>SubscriptionCallback<${field.type.classSimpleName}></code>, as the <code>${object.name}.${field.name}</code> 
	 * is of type <code>${field.type.classSimpleName}</code>. 
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 * 
	 *     /**
	 *      * @param callback 
	 *      *    implements SubscriptionCallback<${field.type.classSimpleName}>, as ${field.type.classSimpleName} is the returned type for the ${field.name} 
	 * 	    *    subscription.<br/>
	 * 	    *    Its onMessage(T) method will be called for each notification received from this subscription.<br/>
	 * 	    *    Its onError(Throwable) method will be called for each error received from this subscription.
	 *      * /
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 * 	        subscriptionClient = subscriptionExecutor.${field.javaName}(
	 * 			    "{ list of the expected subfields for the ${field.name} subscription (empty list for scalars) }",
	 * 			    callback, 
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *             // Optionally, bind variables values must be provided, if you've defined any in your query.
	 *             // This method allows you to provide them as a list of couples of (name, value)
	 *             "anOptionalParam", "a param value", 
	 *             ...  
	 *          );
	 *     }
	 * 
	 *     void freeResources() {
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param queryResponseDef
	 *            The response definition of the subscription, in the native GraphQL format (see here above)
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the ${field.name}
	 *            subscription field.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the subscription. If there is no bind variable in the
	 *            defined subscription, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestPreparationException
	 *             When an error occurs during the request preparation, typically when building the
	 *             {@link ObjectResponse}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
#appliedDirectives(${field.appliedDirectives}, "	")
	public SubscriptionClient ${field.javaName}(
			String queryResponseDef, 
			SubscriptionCallback<${field.javaTypeFullClassname}> subscriptionCallback,
#inputParams()
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException, GraphQLRequestPreparationException {
		logger.debug("Executing subscription '${field.name}'. queryResponseDef is '{}'", queryResponseDef); //$NON-NLS-1$
		ObjectResponse objectResponse = get${field.pascalCaseName}ResponseBuilder().withQueryResponseDef(queryResponseDef).build();
		return ${field.javaName}WithBindValues(objectResponse, subscriptionCallback#inputValues(), this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues));
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method registers a subscription, by executing a direct partial ${field.name} subscription against the GraphQL server. 
	 * This subscription is one of the fields defined in the GraphQL subscription object. The queryResponseDef contains the
	 * part of the subscription that <B><U>is after</U></B> the subscription name (see the sample below), for instance
	 * "{id name}" if you want these two fields to be sent in the notifications you'll receive for this
	 * subscription.<BR/>
	 * You must also provide a callback instance that will be called each time a message
	 * or an error is sent by this subscribed subscription. As the plugin limits the actual subscriptions at one par call (one
	 * field from the ${object.name} GraphQL type), it allows the deserialization of this exact field. So the callback is expected 
	 * to be an instance of <code>SubscriptionCallback<${field.type.classSimpleName}></code>, as the <code>${object.name}.${field.name}</code> 
	 * is of type <code>${field.type.classSimpleName}</code>. 
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     void setup() {
	 *         // Preparation of the query, so that itis prepared once then executed several times
	 *         preparedRequest = subscriptionExecutor
	 *			   .get${field.pascalCaseName}GraphQLRequest("{ list of the expected subfields for the ${field.name} subscription (empty list for scalars) }");
	 *     }
	 * 
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 *         Map<String, Object> params = new HashMap<>();
	 *         params.put("anOptionalParam", "a param value");
	 *         
	 *         subscriptionClient = subscriptionType.${field.javaName}WithBindValues(
	 * 			 preparedRequest,
	 * 			 callback, 
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *              // Optionally, bind variables values may or must be provided, if you've defined any in your query.
	 *              // This method allows you to provide them as a map (which is may be null or empty, if no bind 
	 *              // variables were defined in the request)
	 *              params
	 *          );
	 *     }
	 * 
	 *     /**
	 *      * Release of the resources used for this subscription (mandatory to avoid memory leaks)
	 *      * / 
	 *     void freeResources() { 
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link get${field.pascalCaseName}GraphQLRequest(String)} method. 
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the ${field.name}
	 *            subscription field.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param parameters
	 *            The list of values, for the bind variables defined in the subscription. If there is no bind variable in the
	 *            defined Query, this argument may be null or an empty {@link Map}
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
#appliedDirectives(${field.appliedDirectives}, "	")
#if($field.fieldTypeAST.listDepth>0)
	@SuppressWarnings({"unchecked", "rawtypes", "static-method"})
#else 
	@SuppressWarnings("static-method")
#end
	public SubscriptionClient ${field.javaName}WithBindValues(
			ObjectResponse objectResponse,
			SubscriptionCallback<${field.javaTypeFullClassname}> subscriptionCallback,
#inputParams() 
			Map<String, Object> parameters)
			throws GraphQLRequestExecutionException  {
		if (logger.isTraceEnabled()) {
			logger.trace("Executing ${object.requestType} '${field.name}' with parameters: #foreach ($inputParameter in $field.inputParameters){}#if($foreach.hasNext),#end #end"#foreach ($inputParameter in $field.inputParameters), ${inputParameter.javaName}#end); //$NON-NLS-1$
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing ${object.requestType} '${field.name}'"); //$NON-NLS-1$
		}
	
		// Given values for the BindVariables
		Map<String, Object> parametersLocal = (parameters != null) ? parameters : new HashMap<>();
#foreach ($inputParameter in $field.inputParameters)
		parametersLocal.put("${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}", ${inputParameter.javaName}); //$NON-NLS-1$
#end

#if($field.fieldTypeAST.listDepth>0)
		// This ugly double casting is necessary to make the code compile. If anyone has a better idea... please raise an issue
#end 
		return objectResponse.exec(parametersLocal,#if($field.fieldTypeAST.listDepth>0) (SubscriptionCallback<List>) (Object)#end subscriptionCallback, ${object.classFullName}.class, #if($field.fieldTypeAST.listDepth>0)List#else${field.javaTypeFullClassname}#end.class);
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * This method registers a subscription, by executing a direct partial ${field.name} subscription against the GraphQL server. 
	 * This subscription is one of the fields defined in the GraphQL subscription object. The queryResponseDef contains the
	 * part of the subscription that <B><U>is after</U></B> the subscription name (see the sample below), for instance
	 * "{id name}" if you want these two fields to be sent in the notifications you'll receive for this
	 * subscription.<BR/>
	 * You must also provide a callback instance that will be called each time a message
	 * or an error is sent by this subscribed subscription. As the plugin limits the actual subscriptions at one par call (one
	 * field from the ${object.name} GraphQL type), it allows the deserialization of this exact field. So the callback is expected 
	 * to be an instance of <code>SubscriptionCallback<${field.type.classSimpleName}></code>, as the <code>${object.name}.${field.name}</code> 
	 * is of type <code>${field.type.classSimpleName}</code>. 
	 * Here is a sample on how to use it:
	 * 
	 * <PRE>
	 * @Component // This class must be a spring component
	 * public class MyClass {
	 * 
	 *     @Autowired
	 *     ${object.name}Executor${springBeanSuffix} subscriptionExecutor;
	 *     
	 *     SubscriptionClient subscriptionClient;
	 *     
	 *     GraphQLRequest${springBeanSuffix} preparedRequest;
	 *     
	 *     @PostConstruct
	 *     void setup() {
	 *         preparedRequest = subscriptionExecutor
	 *			   .get${field.pascalCaseName}GraphQLRequest("{ list of the expected subfields for the ${field.name} subscription (empty list for scalars) }");
	 *     }
	 * 
	 *     void myMethod(SubscriptionCallback<${field.type.classSimpleName}> callback) {
	 *         subscriptionClient = subscriptionType.${field.javaName}(
	 * 			 preparedRequest,
	 * 			 callback, 
#foreach ($inputParameter in $field.inputParameters)
	 *              ${inputParameter.name}, // A value for ${field.name}'s ${inputParameter.name} input parameter
#end
	 *             // Optionally, bind variables values must be provided, if you've defined any in your query.
	 *             // This method allows you to provide them as a list of couples of (name, value)
	 *             "anOptionalParam", "a param value", 
	 *             ...  
	 *          );
	 *     }
	 * 
	 *     void freeResources() {
	 *         subscriptionClient.unsubscribe();
	 *     }
	 * }
	 * </PRE>
#if($graphqlUtils.isJavaReservedWords(${field.name}))
	 * This method name is prefixed by ${underscore}, as ${field.name} is a java reserved keyword. 
#end
	 * 
	 * @param objectResponse
	 *            The definition of the response format, that describes what the GraphQL server is expected to return<br/>
	 *            Note: the <code>ObjectResponse</code> type of this parameter is defined for backward compatibility. In new implementations,
	 *            the expected type is the generated GraphQLRequest${springBeanSuffix} POJO, as returned by the
	 *            {@link get${field.pascalCaseName}GraphQLRequest(String)} method. 
	 * @param subscriptionCallback
	 *            The instance that will be called for each notification (message or error) received for this subscription.<br/>
	 *            It's an instance of {@link SubscriptionCallback}&lt;clazz&gt;, where <code>clazz</code> is the ${field.name}
	 *            subscription field.
#foreach ($inputParameter in $field.inputParameters)
#if (${inputParameter.description} && ${inputParameter.description.getContent()} != "")
	* @param ${inputParameter.name} ${inputParameter.description.getContent()}
#else
	* @param ${inputParameter.name} Parameter for the ${field.name} field of ${object.name}, as defined in the GraphQL schema
#end
#end
	 * @param paramsAndValues
	 *            This parameter contains all the name and values for the Bind Variables defined in the objectResponse
	 *            parameter, that must be sent to the server. Optional parameter may not have a value. They will be
	 *            ignored and not sent to the server. Mandatory parameter must be provided in this argument.<BR/>
	 *            This parameter contains an even number of parameters. It must be a series of name and values, like :
	 *            paramName1, paramValue1, paramName2, paramValue2...
	 * @throws GraphQLRequestExecutionException
	 *             When an error occurs during the request execution, typically a network error, an error from the
	 *             GraphQL server or if the server response can't be parsed
	 */
#appliedDirectives(${field.appliedDirectives}, "	")
#if($field.fieldTypeAST.listDepth>0)
	@SuppressWarnings({ "unchecked", "rawtypes" })
#end 
	public SubscriptionClient ${field.javaName}(
			ObjectResponse objectResponse,
			SubscriptionCallback<${field.javaTypeFullClassname}> subscriptionCallback,
#inputParams() 
			Object... paramsAndValues)
			throws GraphQLRequestExecutionException  {
		if (logger.isTraceEnabled()) {
			StringBuilder sb = new StringBuilder();
			sb.append("Executing subscription '${field.name}' with bind variables: "); //$NON-NLS-1$
			boolean addComma = false;
			for (Object o : paramsAndValues) {
				if (o != null) {
					sb.append(o.toString());
					if (addComma)
						sb.append(", "); //$NON-NLS-1$
					addComma = true;
				}
			}
			logger.trace(sb.toString());
		} else if (logger.isDebugEnabled()) {
			logger.debug("Executing subscription '${field.name}' (with bind variables)"); //$NON-NLS-1$
		}

		Map<String, Object> parametersLocal = this.graphqlClientUtils.generatesBindVariableValuesMap(paramsAndValues);
#foreach ($inputParameter in $field.inputParameters)
		parametersLocal.put("${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}", ${inputParameter.javaName}); //$NON-NLS-1$
#end
		
		return objectResponse.exec(parametersLocal, #if($field.fieldTypeAST.listDepth>0) (SubscriptionCallback<List>) (Object)#end subscriptionCallback, ${object.classFullName}.class, #if($field.fieldTypeAST.listDepth>0)List#else${field.javaTypeFullClassname}#end.class);
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 *
	 * Get the {@link com.graphql_java_generator.client.request.Builder} for the ${field.type.classSimpleName}, 
	 * as expected by the ${field.name} subscription.
	 * 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public com.graphql_java_generator.client.request.Builder get${field.pascalCaseName}ResponseBuilder() throws GraphQLRequestPreparationException {
		return new com.graphql_java_generator.client.request.Builder(this.graphQlClient, GraphQLRequest${springBeanSuffix}.class, "${field.name}", RequestType.${object.requestType} //$NON-NLS-1$
#foreach ($inputParameter in $field.inputParameters)
			, InputParameter.newBindParameter("$springBeanSuffix", "${inputParameter.name}","${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}",#if(${inputParameter.fieldTypeAST.mandatory}) InputParameterType.MANDATORY#else InputParameterType.OPTIONAL#end, "${inputParameter.graphQLTypeSimpleName}", ${inputParameter.fieldTypeAST.mandatory}, ${inputParameter.fieldTypeAST.listDepth}, ${inputParameter.fieldTypeAST.itemMandatory}) //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ 
#end
			);
	}

#foreach ($comment in $field.comments)
	// $comment
#end
	/**
#foreach ($line in $field.description.lines)
	 * $line<br/>
#end
	 * Get the {@link GraphQLRequest${springBeanSuffix}} for the ${field.name} $type, created with the given Partial request.
	 * 
	 * @param partialRequest
	 * 				The Partial GraphQL request, as explained in the 
	 * 				<A HREF="https://graphql-maven-plugin-project.graphql-java-generator.com/client.html">plugin client documentation</A> 
	 * @return
	 * @throws GraphQLRequestPreparationException
	 */
	public GraphQLRequest${springBeanSuffix} get${field.pascalCaseName}GraphQLRequest(String partialRequest) throws GraphQLRequestPreparationException {
		return new GraphQLRequest${springBeanSuffix}(this.graphQlClient,partialRequest, RequestType.${object.requestType}, "${field.name}" //$NON-NLS-1$
#foreach ($inputParameter in $field.inputParameters)
		, InputParameter.newBindParameter(
				"$springBeanSuffix", //$NON-NLS-1$
				"${inputParameter.name}", //$NON-NLS-1$
				"${object.camelCaseName}${field.pascalCaseName}${inputParameter.pascalCaseName}", //$NON-NLS-1$
				#if(${inputParameter.fieldTypeAST.mandatory}) InputParameterType.MANDATORY#else InputParameterType.OPTIONAL#end, 
				"${inputParameter.graphQLTypeSimpleName}", //$NON-NLS-1$
				${inputParameter.fieldTypeAST.mandatory}, 
				${inputParameter.fieldTypeAST.listDepth}, 
				${inputParameter.fieldTypeAST.itemMandatory})
#end
		);
	}
	
#end
#end
}
