/** Generated by the default template from graphql-java-generator */
##
## Velocity template for the BatchLoaderDelegateXxxxImpl classes, where Xxxx successively every object in the GraphQL schema
## which has an ID.
##
## This template has these inputs:
## package
## batchLoader
##
package ${packageUtilName};

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

import javax.annotation.Resource;

#if($configuration.generateBatchLoaderEnvironment)
import org.dataloader.BatchLoaderEnvironment;
#end
import org.dataloader.DataLoaderRegistry;
import org.springframework.stereotype.Component;

import com.graphql_java_generator.server.util.BatchLoaderDelegate#if($configuration.generateBatchLoaderEnvironment)WithContext#end;	

/**
 * This is the default implementation for BathLoaderDelegate. It is implemented for each object of the GraphQL model
 * that has a field of type ID, which is identified as an identifier. <BR/>
 * It can be used in a DataFetcherDelegate implementation in this way : 
 * <PRE>
 * &#64;Override
 * public CompletableFuture<List<${batchLoader.type.classSimpleName}>> friends(DataFetchingEnvironment environment, DataLoader<${configuration.javaTypeForIDType}, ${batchLoader.type.classSimpleName}> dataLoader,
 * 		${batchLoader.type.classSimpleName} source) {
 * 	logger.debug("Executing characterImpl.friends, with this character: {}", source.getId().toString());
 * 	List<${configuration.javaTypeForIDType}> friendIds = graphQLUtil
 * 			.convertListByteArrayToList(characterRepository.findFriendsId(source.getId()));
 * 	return dataLoader.loadMany(friendIds);
 * }
 *
 * </PRE>
 * @author generated by graphql-java-generator
 */
@Component
@SuppressWarnings("unused")
public class BatchLoaderDelegate${batchLoader.type.classSimpleName}Impl implements BatchLoaderDelegate#if($configuration.generateBatchLoaderEnvironment)WithContext#end<${batchLoader.type.identifier.type.classFullName}, ${batchLoader.type.classFullName}> {

	/** The DataFetcherDelegates contain the requests to the data */
	@Resource
	${batchLoader.dataFetchersDelegate.pascalCaseName} ${batchLoader.dataFetchersDelegate.camelCaseName};

	/**
	 * A batch loader function that will be called with N or more keys for batch loading. This can be a singleton object
	 * since it's stateless.
	 * 
	 * @param keys
	 *            the list of keys, for which we want to retrieve the instances.
	 * @return the list of ${batchLoader.type.classSimpleName}s corresponding to the given keys
	 */
	@Override
	public CompletionStage<List<${batchLoader.type.classFullName}>> load(List<${batchLoader.type.identifier.type.classFullName}> keys#if($configuration.generateBatchLoaderEnvironment), BatchLoaderEnvironment environment#end) {
		// We use supplyAsync() of values here for maximum parallelism
		return CompletableFuture.supplyAsync(() -> ${batchLoader.dataFetchersDelegate.camelCaseName}.batchLoader(keys#if($configuration.generateBatchLoaderEnvironment), environment#end));
	}

	/**
	 * The name for this {@link BatchLoaderDelegate}, as ot is stored in the {@link DataLoaderRegistry}. <BR/>
	 * The BatchLoader can then be retrieved by this command, in a DataFetchDelegate implementation:<BR/>
	 */
	@Override
	public String getName() {
		return "${batchLoader.type.classSimpleName}";
	}

}
