/*
 * Decompiled with CFR 0.152.
 */
package com.graphql_java_generator.client;

import com.graphql_java_generator.annotation.RequestType;
import com.graphql_java_generator.client.GraphQLRequestObject;
import com.graphql_java_generator.client.RequestExecution;
import com.graphql_java_generator.client.RequestExecutionSpringReactiveImpl;
import com.graphql_java_generator.client.SubscriptionCallback;
import com.graphql_java_generator.client.SubscriptionClient;
import com.graphql_java_generator.client.SubscriptionClientImpl;
import com.graphql_java_generator.client.SubscriptionClientWebSocket;
import com.graphql_java_generator.client.request.AbstractGraphQLRequest;
import com.graphql_java_generator.client.response.JsonResponseWrapper;
import com.graphql_java_generator.exception.GraphQLRequestExecutionException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RequestExecutionImpl
implements RequestExecution {
    private static Logger logger;
    Client client;
    String graphqlEndpoint;
    WebTarget webTarget;

    public RequestExecutionImpl(String graphqlEndpoint) {
        this(graphqlEndpoint, ClientBuilder.newClient());
        this.graphqlEndpoint = graphqlEndpoint;
    }

    public RequestExecutionImpl(String graphqlEndpoint, SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        if (graphqlEndpoint.startsWith("http:")) {
            throw new IllegalArgumentException("This GraphQL endpoint is an http one. Please use the relevant Query/Mutation/Subscription constructor (without the SSLContext and HostnameVerifier parameters)");
        }
        this.client = ClientBuilder.newBuilder().sslContext(sslContext).hostnameVerifier(hostnameVerifier).build();
        this.graphqlEndpoint = graphqlEndpoint;
        this.webTarget = this.client.target(graphqlEndpoint);
    }

    @Deprecated
    public RequestExecutionImpl(String graphqlEndpoint, Client client) {
        this.client = client;
        this.graphqlEndpoint = graphqlEndpoint;
        this.webTarget = client.target(graphqlEndpoint);
    }

    @Override
    public <R extends GraphQLRequestObject> R execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, Class<R> dataResponseType) throws GraphQLRequestExecutionException {
        if (graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may not be called for subscriptions");
        }
        String jsonRequest = graphQLRequest.buildRequestAsString(parameters);
        try {
            logger.trace(GRAPHQL_MARKER, "Executing GraphQL request: {}", (Object)jsonRequest);
            Invocation.Builder invocationBuilder = this.webTarget.request(new String[]{"application/json"});
            JsonResponseWrapper response = (JsonResponseWrapper)invocationBuilder.post(Entity.entity((Object)jsonRequest, (String)"application/json"), JsonResponseWrapper.class);
            return RequestExecutionSpringReactiveImpl.parseDataFromGraphQLServerResponse(graphQLRequest.getGraphQLObjectMapper(), response, dataResponseType);
        }
        catch (IOException e) {
            throw new GraphQLRequestExecutionException("Error when executing query <" + jsonRequest + ">: " + e.getMessage(), e);
        }
    }

    @Override
    public <R, T> SubscriptionClient execute(AbstractGraphQLRequest graphQLRequest, Map<String, Object> parameters, SubscriptionCallback<T> subscriptionCallback, Class<R> subscriptionType, Class<T> messageType) throws GraphQLRequestExecutionException {
        if (!graphQLRequest.getRequestType().equals((Object)RequestType.subscription)) {
            throw new GraphQLRequestExecutionException("This method may be called only for subscriptions");
        }
        if (graphQLRequest.getSubscription().getFields().size() != 1) {
            throw new GraphQLRequestExecutionException("This method may be called only for one subscription at a time, but there was " + graphQLRequest.getSubscription().getFields().size() + " subscriptions in this GraphQLRequest");
        }
        String subscriptionName = graphQLRequest.getSubscription().getFields().get(0).getName();
        String request = graphQLRequest.buildRequestAsString(parameters);
        logger.trace(GRAPHQL_MARKER, "Executing GraphQL subscription '{}' with request {}", (Object)subscriptionName, (Object)request);
        boolean trustAll = System.getProperty("com.graphql-java-generator.websocket.nosslcheck") != null;
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(trustAll);
        HttpClient httpClient = new HttpClient((SslContextFactory)sslContextFactory);
        WebSocketClient wsClient = new WebSocketClient(httpClient);
        SubscriptionClientWebSocket<R, T> subscriptionClientWebSocket = new SubscriptionClientWebSocket<R, T>(request, subscriptionName, subscriptionCallback, subscriptionType, messageType, graphQLRequest.getGraphQLObjectMapper());
        URI uri = this.getWebSocketURI();
        try {
            wsClient.start();
            ClientUpgradeRequest clientUpgradeRequest = new ClientUpgradeRequest();
            wsClient.connect(subscriptionClientWebSocket, uri, clientUpgradeRequest);
            logger.debug("Connecting to {}", (Object)uri);
        }
        catch (Exception e) {
            String msg = "Error while opening the Web Socket connection to " + uri;
            logger.error(msg);
            throw new GraphQLRequestExecutionException(msg, e);
        }
        return new SubscriptionClientImpl(wsClient);
    }

    URI getWebSocketURI() throws GraphQLRequestExecutionException {
        if (this.graphqlEndpoint.startsWith("http:") || this.graphqlEndpoint.startsWith("https:")) {
            try {
                return new URI("ws" + this.graphqlEndpoint.substring(4));
            }
            catch (URISyntaxException e) {
                throw new GraphQLRequestExecutionException("Error when trying to determine the Web Socket endpoint for GraphQL endpoint " + this.graphqlEndpoint, e);
            }
        }
        throw new GraphQLRequestExecutionException("non managed protocol for endpoint " + this.graphqlEndpoint + ". This method manages only http and https");
    }

    static {
        GRAPHQL_QUERY_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_MUTATION_MARKER.add(GRAPHQL_MARKER);
        GRAPHQL_SUBSCRIPTION_MARKER.add(GRAPHQL_MARKER);
        logger = LoggerFactory.getLogger(RequestExecutionImpl.class);
    }
}

