/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.model.component.Service;
import com.evento.parser.model.handler.ServiceCommandHandler;
import com.evento.parser.model.payload.ServiceCommand;
import com.evento.parser.model.payload.ServiceEvent;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public class JavaServiceParser
extends JavaComponentParser<Service> {
    public JavaServiceParser(Node node) {
        super(node);
    }

    private List<ServiceCommandHandler> findCommandHandler() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("CommandHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String commandName = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            ASTClassOrInterfaceType eventClass = (ASTClassOrInterfaceType)md.getResultType().getFirstDescendantOfType(ASTClassOrInterfaceType.class);
            return new ServiceCommandHandler(new ServiceCommand(commandName), eventClass == null ? null : new ServiceEvent(eventClass.getImage()), n.getBeginLine());
        }).collect(Collectors.toList());
    }

    @Override
    public Service parse() throws Exception {
        Service service = new Service();
        service.setComponentName(this.getDeclaredClassName());
        service.setCommandHandlers(this.findCommandHandler());
        this.findCommandInvocations(service.getCommandHandlers());
        this.findQueryInvocations(service.getCommandHandlers());
        return service;
    }
}

