/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.model.component.Saga;
import com.evento.parser.model.handler.SagaEventHandler;
import com.evento.parser.model.payload.Event;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValuePair;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public class JavaSagaParser
extends JavaComponentParser<Saga> {
    public JavaSagaParser(Node node) {
        super(node);
    }

    private List<SagaEventHandler> findSagaEventHandlers() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("SagaEventHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String eventName = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            String associationProperty = n.getParent().getChild(0).findDescendantsOfType(ASTMemberValuePair.class).stream().filter(m -> m.getImage().equals("associationProperty")).findFirst().map(m -> ((ASTLiteral)m.getFirstDescendantOfType(ASTLiteral.class)).getImage().replace("\"", "")).orElseThrow();
            return new SagaEventHandler(new Event(eventName), associationProperty, n.getBeginLine());
        }).collect(Collectors.toList());
    }

    @Override
    public Saga parse() throws Exception {
        Saga saga = new Saga();
        saga.setComponentName(this.getDeclaredClassName());
        saga.setSagaEventHandlers(this.findSagaEventHandlers());
        this.findCommandInvocations(saga.getSagaEventHandlers());
        this.findQueryInvocations(saga.getSagaEventHandlers());
        return saga;
    }
}

