/*
 * Decompiled with CFR 0.152.
 */
package com.evento.parser.java;

import com.evento.parser.java.JavaComponentParser;
import com.evento.parser.model.component.Projection;
import com.evento.parser.model.handler.QueryHandler;
import com.evento.parser.model.payload.MonoResultQueryReturnType;
import com.evento.parser.model.payload.MultipleResultQueryReturnType;
import com.evento.parser.model.payload.Query;
import com.evento.parser.model.payload.QueryReturnType;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import org.jaxen.JaxenException;

public class JavaProjectionParser
extends JavaComponentParser<Projection> {
    public JavaProjectionParser(Node node) {
        super(node);
    }

    private List<QueryHandler> findQueryHandlers() throws JaxenException {
        String query = this.getQueryForAnnotatedMethod("QueryHandler");
        return ((ASTTypeDeclaration)this.node.getFirstChildOfType(ASTTypeDeclaration.class)).findChildNodesWithXPath(query).stream().map(n -> {
            ASTMethodDeclaration md = (ASTMethodDeclaration)n;
            String name = ((ASTClassOrInterfaceType)md.getFormalParameters().getFirstDescendantOfType(ASTClassOrInterfaceType.class)).getImage();
            ASTResultType msgRetType = md.getResultType();
            List resultTypeDefinitions = msgRetType.findDescendantsOfType(ASTClassOrInterfaceType.class);
            boolean isMultiple = !((ASTClassOrInterfaceType)resultTypeDefinitions.get(0)).getImage().equals("Single");
            QueryReturnType type = isMultiple ? new MultipleResultQueryReturnType(((ASTClassOrInterfaceType)resultTypeDefinitions.get(1)).getImage()) : new MonoResultQueryReturnType(((ASTClassOrInterfaceType)resultTypeDefinitions.get(1)).getImage());
            return new QueryHandler(new Query(name, type), n.getBeginLine());
        }).collect(Collectors.toList());
    }

    @Override
    public Projection parse() throws Exception {
        Projection projection = new Projection();
        projection.setComponentName(this.getDeclaredClassName());
        projection.setQueryHandlers(this.findQueryHandlers());
        this.findQueryInvocations(projection.getQueryHandlers());
        return projection;
    }
}

